/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.CompressedProcesser;
import org.jglrxavpok.hephaistos.nbt.ExtensionsKt;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB!\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\nB!\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\rB!\b\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTReader;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "compressedProcesser", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "(Ljava/io/File;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "array", "", "([BLorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "source", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "reader", "Ljava/io/DataInputStream;", "close", "", "read", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "readNamed", "Lkotlin/Pair;", "", "readRaw", "id", "", "Companion", "common"})
public final class NBTReader
implements AutoCloseable,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataInputStream reader;

    @JvmOverloads
    public NBTReader(@NotNull InputStream source, @NotNull CompressedProcesser<?, ?> compressedProcesser) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this.reader = new DataInputStream(compressedProcesser.generateInputStream(source));
    }

    public /* synthetic */ NBTReader(InputStream inputStream, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(inputStream, compressedProcesser);
    }

    @JvmOverloads
    public NBTReader(@NotNull File file, @NotNull CompressedProcesser<?, ?> compressedProcesser) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this(new BufferedInputStream(new FileInputStream(file)), compressedProcesser);
    }

    public /* synthetic */ NBTReader(File file, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(file, compressedProcesser);
    }

    @JvmOverloads
    public NBTReader(@NotNull Path path, @NotNull CompressedProcesser<?, ?> compressedProcesser) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), compressedProcesser);
    }

    public /* synthetic */ NBTReader(Path path, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(path, compressedProcesser);
    }

    @JvmOverloads
    public NBTReader(@NotNull byte[] array, @NotNull CompressedProcesser<?, ?> compressedProcesser) throws IOException {
        Intrinsics.checkNotNullParameter(array, "array");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this(new ByteArrayInputStream(array), compressedProcesser);
    }

    public /* synthetic */ NBTReader(byte[] byArray, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(byArray, compressedProcesser);
    }

    @NotNull
    public final Pair<String, NBT> readNamed() throws IOException, NBTException {
        return ExtensionsKt.readFullyFormedTag(this.reader);
    }

    @NotNull
    public final NBT read() throws IOException, NBTException {
        return this.readNamed().getSecond();
    }

    @NotNull
    public final NBT readRaw(int id2) throws IOException, NBTException {
        return ExtensionsKt.readTag(this.reader, id2);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @JvmOverloads
    public NBTReader(@NotNull InputStream source) {
        Intrinsics.checkNotNullParameter(source, "source");
        this(source, null, 2, null);
    }

    @JvmOverloads
    public NBTReader(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        this(file, null, 2, null);
    }

    @JvmOverloads
    public NBTReader(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        this(path, null, 2, null);
    }

    @JvmOverloads
    public NBTReader(@NotNull byte[] array) throws IOException {
        Intrinsics.checkNotNullParameter(array, "array");
        this(array, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTReader fromArray(@NotNull byte[] array, @NotNull CompressedProcesser<?, ?> compressedProcesser) {
        return Companion.fromArray(array, compressedProcesser);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NBTReader fromArray(@NotNull byte[] array) {
        return Companion.fromArray(array);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTReader$Companion;", "", "()V", "fromArray", "Lorg/jglrxavpok/hephaistos/nbt/NBTReader;", "array", "", "compressedProcesser", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NBTReader fromArray(@NotNull byte[] array, @NotNull CompressedProcesser<?, ?> compressedProcesser) {
            Intrinsics.checkNotNullParameter(array, "array");
            Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
            return new NBTReader(new ByteArrayInputStream(array), compressedProcesser);
        }

        public static /* synthetic */ NBTReader fromArray$default(Companion companion, byte[] byArray, CompressedProcesser compressedProcesser, int n, Object object) {
            if ((n & 2) != 0) {
                compressedProcesser = CompressedProcesser.NONE;
            }
            return companion.fromArray(byArray, compressedProcesser);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NBTReader fromArray(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            return org.jglrxavpok.hephaistos.nbt.NBTReader$Companion.fromArray$default(this, array, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

