/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTLongArray;
import org.jglrxavpok.hephaistos.nbt.NBTReaderCompanion;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001$B\u0013\b\u0016\u0012\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000fH\u0086\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTLongArray;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "", "", "numbers", "", "([J)V", "value", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "(Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;)V", "ID", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "getID", "()Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "size", "", "getSize", "()I", "getValue", "()Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "equals", "", "other", "", "get", "index", "hashCode", "iterator", "", "toSNBT", "", "toString", "writeContents", "", "destination", "Ljava/io/DataOutputStream;", "Companion", "common"})
public final class NBTLongArray
implements NBT,
Iterable<Long>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableLongArray value;
    @NotNull
    private final NBTType<NBTLongArray> ID;
    @JvmField
    @NotNull
    public static final NBTLongArray EMPTY = new NBTLongArray(new long[0]);

    public NBTLongArray(@NotNull ImmutableLongArray value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
        this.ID = NBTType.TAG_Long_Array;
    }

    @Override
    @NotNull
    public ImmutableLongArray getValue() {
        return this.value;
    }

    public final int getSize() {
        return this.getValue().getSize();
    }

    @NotNull
    public NBTType<NBTLongArray> getID() {
        return this.ID;
    }

    public NBTLongArray(long ... numbers) {
        Intrinsics.checkNotNullParameter(numbers, "numbers");
        this(new ImmutableLongArray(Arrays.copyOf(numbers, numbers.length)));
    }

    @Override
    public void writeContents(@NotNull DataOutputStream destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        destination.writeInt(this.getSize());
        long[] $this$forEach$iv = this.getValue().getNumbers$common();
        boolean $i$f$forEach = false;
        long[] lArray = $this$forEach$iv;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long p0 = element$iv = lArray[i];
            boolean bl = false;
            destination.writeLong(p0);
        }
    }

    public final long get(int index) {
        return this.getValue().get(index);
    }

    @Override
    @NotNull
    public String toSNBT() {
        String list2 = ImmutableLongArray.joinToString$default(this.getValue(), ",", null, null, 0, null, toSNBT.list.1.INSTANCE, 30, null);
        return "[L;" + list2 + ']';
    }

    @Override
    @NotNull
    public String toString() {
        return this.toSNBT();
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jglrxavpok.hephaistos.nbt.NBTLongArray");
        }
        NBTLongArray cfr_ignored_0 = (NBTLongArray)other;
        return this.getValue().contentEquals(((NBTLongArray)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public Iterator<Long> iterator() {
        return this.getValue().iterator();
    }

    @Override
    @NotNull
    public byte[] toByteArray() throws IOException {
        return NBT.DefaultImpls.toByteArray(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTLongArray$Companion;", "Lorg/jglrxavpok/hephaistos/nbt/NBTReaderCompanion;", "Lorg/jglrxavpok/hephaistos/nbt/NBTLongArray;", "()V", "EMPTY", "readContents", "source", "Ljava/io/DataInputStream;", "common"})
    public static final class Companion
    implements NBTReaderCompanion<NBTLongArray> {
        private Companion() {
        }

        @Override
        @NotNull
        public NBTLongArray readContents(@NotNull DataInputStream source) {
            Intrinsics.checkNotNullParameter(source, "source");
            int length = source.readInt();
            byte[] inArray = source.readNBytes(length * 8);
            long[] outArray = new long[length];
            int n = 0;
            if (n < length) {
                do {
                    int i = n++;
                    int index = i * 8;
                    outArray[i] = (long)inArray[index] << 56 | ((long)inArray[index + 1] & 0xFFL) << 48 | ((long)inArray[index + 2] & 0xFFL) << 40 | ((long)inArray[index + 3] & 0xFFL) << 32 | ((long)inArray[index + 4] & 0xFFL) << 24 | ((long)inArray[index + 5] & 0xFFL) << 16 | ((long)inArray[index + 6] & 0xFFL) << 8 | (long)inArray[index + 7] & 0xFFL;
                } while (n < length);
            }
            return new NBTLongArray(Arrays.copyOf(outArray, outArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

