/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTReaderCompanion;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\u001a\u0010\u000b\u001a\u00020\t*\u00020\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"readFullyFormedTag", "Lkotlin/Pair;", "", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "Ljava/io/DataInputStream;", "readTag", "id", "", "writeEndTag", "", "Ljava/io/DataOutputStream;", "writeFullyFormedTag", "name", "tag", "common"})
public final class ExtensionsKt {
    @NotNull
    public static final Pair<String, NBT> readFullyFormedTag(@NotNull DataInputStream $this$readFullyFormedTag) throws IOException, NBTException {
        Intrinsics.checkNotNullParameter($this$readFullyFormedTag, "<this>");
        byte id2 = $this$readFullyFormedTag.readByte();
        if (id2 == NBTType.TAG_End.getOrdinal()) {
            return TuplesKt.to("", NBTEnd.INSTANCE);
        }
        String name2 = $this$readFullyFormedTag.readUTF();
        return TuplesKt.to(name2, ExtensionsKt.readTag($this$readFullyFormedTag, id2));
    }

    @NotNull
    public static final NBT readTag(@NotNull DataInputStream $this$readTag, int id2) throws IOException, NBTException {
        Intrinsics.checkNotNullParameter($this$readTag, "<this>");
        NBTReaderCompanion<?> readerCompanion = NBTType.Companion.byIndex(id2).getReaderCompanion();
        return readerCompanion.readContents($this$readTag);
    }

    public static final void writeFullyFormedTag(@NotNull DataOutputStream $this$writeFullyFormedTag, @NotNull String name2, @NotNull NBT tag) throws IOException {
        Intrinsics.checkNotNullParameter($this$writeFullyFormedTag, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(tag, "tag");
        $this$writeFullyFormedTag.writeByte(tag.getID().getOrdinal());
        $this$writeFullyFormedTag.writeUTF(name2);
        tag.writeContents($this$writeFullyFormedTag);
    }

    public static final void writeEndTag(@NotNull DataOutputStream $this$writeEndTag) throws IOException {
        Intrinsics.checkNotNullParameter($this$writeEndTag, "<this>");
        $this$writeEndTag.writeByte(NBTType.TAG_End.getOrdinal());
    }
}

