/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u0016\u0018\u0000 \u000b*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "I", "Ljava/io/InputStream;", "O", "Ljava/io/OutputStream;", "", "()V", "generateInputStream", "originalInputStream", "generateOutputStream", "originalOutputStream", "Companion", "ParameterizedGzip", "ParameterizedZlib", "common"})
public class CompressedProcesser<I extends InputStream, O extends OutputStream> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final CompressedProcesser<InputStream, OutputStream> NONE = new CompressedProcesser<InputStream, OutputStream>(){};
    @JvmField
    @NotNull
    public static final ParameterizedGzip GZIP = new ParameterizedGzip(0, 1, null);
    @JvmField
    @NotNull
    public static final ParameterizedZlib ZLIB = new ParameterizedZlib(null, null, 0, 7, null);

    @NotNull
    public InputStream generateInputStream(@NotNull InputStream originalInputStream) {
        Intrinsics.checkNotNullParameter(originalInputStream, "originalInputStream");
        return originalInputStream;
    }

    @NotNull
    public OutputStream generateOutputStream(@NotNull OutputStream originalOutputStream) {
        Intrinsics.checkNotNullParameter(originalOutputStream, "originalOutputStream");
        return originalOutputStream;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$Companion;", "", "()V", "GZIP", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$ParameterizedGzip;", "NONE", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "ZLIB", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$ParameterizedZlib;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$ParameterizedGzip;", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "Ljava/util/zip/GZIPInputStream;", "Ljava/util/zip/GZIPOutputStream;", "bufferSize", "", "(I)V", "getBufferSize", "()I", "generateInputStream", "originalInputStream", "Ljava/io/InputStream;", "generateOutputStream", "originalOutputStream", "Ljava/io/OutputStream;", "common"})
    public static final class ParameterizedGzip
    extends CompressedProcesser<GZIPInputStream, GZIPOutputStream> {
        private final int bufferSize;

        @JvmOverloads
        public ParameterizedGzip(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public /* synthetic */ ParameterizedGzip(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 512;
            }
            this(n);
        }

        public final int getBufferSize() {
            return this.bufferSize;
        }

        @Override
        @NotNull
        public GZIPInputStream generateInputStream(@NotNull InputStream originalInputStream) {
            Intrinsics.checkNotNullParameter(originalInputStream, "originalInputStream");
            return new GZIPInputStream(originalInputStream, this.bufferSize);
        }

        @Override
        @NotNull
        public GZIPOutputStream generateOutputStream(@NotNull OutputStream originalOutputStream) {
            Intrinsics.checkNotNullParameter(originalOutputStream, "originalOutputStream");
            return new GZIPOutputStream(originalOutputStream, this.bufferSize);
        }

        @JvmOverloads
        public ParameterizedGzip() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B%\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$ParameterizedZlib;", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "Ljava/util/zip/InflaterInputStream;", "Ljava/util/zip/InflaterOutputStream;", "inflater", "Ljava/util/zip/Inflater;", "deflater", "Ljava/util/zip/Deflater;", "bufferSize", "", "(Ljava/util/zip/Inflater;Ljava/util/zip/Deflater;I)V", "getBufferSize", "()I", "getDeflater", "()Ljava/util/zip/Deflater;", "getInflater", "()Ljava/util/zip/Inflater;", "generateInputStream", "originalInputStream", "Ljava/io/InputStream;", "generateOutputStream", "Ljava/util/zip/DeflaterOutputStream;", "originalOutputStream", "Ljava/io/OutputStream;", "Companion", "common"})
    public static final class ParameterizedZlib
    extends CompressedProcesser<InflaterInputStream, InflaterOutputStream> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Inflater inflater;
        @NotNull
        private final Deflater deflater;
        private final int bufferSize;
        @NotNull
        private static final Inflater DEFAULT_INFLATER = new Inflater();
        @NotNull
        private static final Deflater DEFAULT_DEFLATER = new Deflater();

        @JvmOverloads
        public ParameterizedZlib(@NotNull Inflater inflater, @NotNull Deflater deflater, int bufferSize) {
            Intrinsics.checkNotNullParameter(inflater, "inflater");
            Intrinsics.checkNotNullParameter(deflater, "deflater");
            this.inflater = inflater;
            this.deflater = deflater;
            this.bufferSize = bufferSize;
        }

        public /* synthetic */ ParameterizedZlib(Inflater inflater, Deflater deflater, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                inflater = DEFAULT_INFLATER;
            }
            if ((n2 & 2) != 0) {
                deflater = DEFAULT_DEFLATER;
            }
            if ((n2 & 4) != 0) {
                n = 512;
            }
            this(inflater, deflater, n);
        }

        @NotNull
        public final Inflater getInflater() {
            return this.inflater;
        }

        @NotNull
        public final Deflater getDeflater() {
            return this.deflater;
        }

        public final int getBufferSize() {
            return this.bufferSize;
        }

        @Override
        @NotNull
        public InflaterInputStream generateInputStream(@NotNull InputStream originalInputStream) {
            Intrinsics.checkNotNullParameter(originalInputStream, "originalInputStream");
            return Intrinsics.areEqual(this.inflater, DEFAULT_INFLATER) ? new InflaterInputStream(originalInputStream) : new InflaterInputStream(originalInputStream, this.inflater, this.bufferSize);
        }

        @Override
        @NotNull
        public DeflaterOutputStream generateOutputStream(@NotNull OutputStream originalOutputStream) {
            Intrinsics.checkNotNullParameter(originalOutputStream, "originalOutputStream");
            return Intrinsics.areEqual(this.deflater, DEFAULT_DEFLATER) ? new DeflaterOutputStream(originalOutputStream) : new DeflaterOutputStream(originalOutputStream, this.deflater, this.bufferSize);
        }

        @JvmOverloads
        public ParameterizedZlib(@NotNull Inflater inflater, @NotNull Deflater deflater) {
            Intrinsics.checkNotNullParameter(inflater, "inflater");
            Intrinsics.checkNotNullParameter(deflater, "deflater");
            this(inflater, deflater, 0, 4, null);
        }

        @JvmOverloads
        public ParameterizedZlib(@NotNull Inflater inflater) {
            Intrinsics.checkNotNullParameter(inflater, "inflater");
            this(inflater, null, 0, 6, null);
        }

        @JvmOverloads
        public ParameterizedZlib() {
            this(null, null, 0, 7, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser$ParameterizedZlib$Companion;", "", "()V", "DEFAULT_DEFLATER", "Ljava/util/zip/Deflater;", "getDEFAULT_DEFLATER", "()Ljava/util/zip/Deflater;", "DEFAULT_INFLATER", "Ljava/util/zip/Inflater;", "getDEFAULT_INFLATER", "()Ljava/util/zip/Inflater;", "common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Inflater getDEFAULT_INFLATER() {
                return DEFAULT_INFLATER;
            }

            @NotNull
            public final Deflater getDEFAULT_DEFLATER() {
                return DEFAULT_DEFLATER;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

