/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca.writer;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.collections.ImmutableIntArray;
import org.jglrxavpok.hephaistos.mca.ChunkColumn;
import org.jglrxavpok.hephaistos.mca.CoordinatesKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.ChunkVersionedFieldsKt;
import org.jglrxavpok.hephaistos.nbt.CompoundBuilder;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTLongArray;
import org.jglrxavpok.hephaistos.nbt.NBTShort;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0014\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#J\u001a\u0010$\u001a\u00020\r2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00120\u0012J\u000e\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u000e\u0010,\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u000e\u0010-\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0007J\u0014\u00101\u001a\u00020\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u001c\u00103\u001a\u00020\r2\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00120\u0012H\u0007J\u001c\u00105\u001a\u00020\r2\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00120\u0012H\u0007J\u001a\u00106\u001a\u00020\r2\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00120\u0012J\u0014\u00108\u001a\u00020\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u0013J\u000e\u0010?\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u000e\u0010@\u001a\u00020\r2\u0006\u0010)\u001a\u00020*J\u000e\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u0018J\u0006\u0010C\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006D"}, d2={"Lorg/jglrxavpok/hephaistos/mca/writer/ChunkWriter;", "", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "(Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;)V", "carvingMasks", "Lorg/jglrxavpok/hephaistos/nbt/mutable/MutableNBTCompound;", "heightMaps", "levelData", "nbt", "getVersion", "()Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "setAirCarvingMask", "", "mask", "Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "setBlockEntityData", "blockEntities", "Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "setBlockTicks", "blockTicks", "setCoordinates", "x", "", "z", "setFluidTicks", "liquidTicks", "setInhabitedTime", "inhabitedTime", "", "setLastUpdate", "lastUpdate", "setLightOn", "lightOn", "", "setLights", "lights", "Lorg/jglrxavpok/hephaistos/nbt/NBTShort;", "setLiquidCarvingMask", "setMotionBlockingHeightMap", "compactedHeightmap", "Lorg/jglrxavpok/hephaistos/nbt/NBTLongArray;", "setMotionBlockingNoLeavesHeightMap", "setOceanFloorHeightMap", "setOceanFloorWorldGenHeightMap", "setOldBiomes", "biomes", "Lorg/jglrxavpok/hephaistos/collections/ImmutableIntArray;", "setOldEntityData", "entities", "setOldLiquidsToBeTicked", "toBeTicked", "setOldToBeTicked", "setPostProcessing", "postProcessingData", "setSectionsData", "sections", "setStatus", "generationStatus", "Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "setStructures", "structures", "setWorldSurfaceHeightMap", "setWorldSurfaceWorldGenHeightMap", "setYPos", "minY", "toNBT", "common"})
public final class ChunkWriter {
    @NotNull
    private final SupportedVersion version;
    @NotNull
    private final MutableNBTCompound nbt;
    @NotNull
    private MutableNBTCompound levelData;
    @NotNull
    private final MutableNBTCompound heightMaps;
    @NotNull
    private final MutableNBTCompound carvingMasks;

    public ChunkWriter(@NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        this.version = version2;
        this.nbt = new MutableNBTCompound(null, 1, null);
        this.heightMaps = new MutableNBTCompound(null, 1, null);
        this.carvingMasks = new MutableNBTCompound(null, 1, null);
        this.nbt.setInt("DataVersion", this.version.getLowestDataVersion());
        this.levelData = this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0 ? new MutableNBTCompound(null, 1, null) : this.nbt;
    }

    @NotNull
    public final SupportedVersion getVersion() {
        return this.version;
    }

    public final void setCoordinates(int x, int z) {
        this.levelData.set("xPos", NBT.Companion.Int(x));
        this.levelData.set("zPos", NBT.Companion.Int(z));
    }

    public final void setYPos(int minY) {
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) >= 0) {
            this.levelData.set("yPos", NBT.Companion.Int(CoordinatesKt.blockToSection(minY)));
        }
    }

    public final void setLastUpdate(long lastUpdate) {
        this.levelData.set("LastUpdate", NBT.Companion.Long(lastUpdate));
    }

    public final void setInhabitedTime(long inhabitedTime) {
        this.levelData.set("InhabitedTime", NBT.Companion.Long(inhabitedTime));
    }

    public final void setStatus(@NotNull ChunkColumn.GenerationStatus generationStatus) {
        Intrinsics.checkNotNullParameter((Object)generationStatus, "generationStatus");
        this.levelData.set("Status", NBT.Companion.String(generationStatus.getId()));
    }

    public final void setMotionBlockingHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("MOTION_BLOCKING", compactedHeightmap);
    }

    public final void setMotionBlockingNoLeavesHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("MOTION_BLOCKING_NO_LEAVES", compactedHeightmap);
    }

    public final void setOceanFloorHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("OCEAN_FLOOR", compactedHeightmap);
    }

    public final void setOceanFloorWorldGenHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("OCEAN_FLOOR_WG", compactedHeightmap);
    }

    public final void setWorldSurfaceHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("WORLD_SURFACE", compactedHeightmap);
    }

    public final void setWorldSurfaceWorldGenHeightMap(@NotNull NBTLongArray compactedHeightmap) {
        Intrinsics.checkNotNullParameter(compactedHeightmap, "compactedHeightmap");
        this.heightMaps.set("WORLD_SURFACE_WG", compactedHeightmap);
    }

    public final void setPostProcessing(@NotNull NBTList<NBTList<NBTShort>> postProcessingData) {
        Intrinsics.checkNotNullParameter(postProcessingData, "postProcessingData");
        this.levelData.set("PostProcessing", postProcessingData);
    }

    public final void setLights(@NotNull NBTList<NBTList<NBTShort>> lights) {
        Intrinsics.checkNotNullParameter(lights, "lights");
        this.levelData.set("Lights", lights);
    }

    public final void setLightOn(boolean lightOn) {
        this.levelData.set("isLightOn", NBT.Companion.Boolean(lightOn));
    }

    @Deprecated(message="toBeTicked no longer exists in 1.18+ worlds", level=DeprecationLevel.WARNING)
    public final void setOldToBeTicked(@NotNull NBTList<NBTList<NBTShort>> toBeTicked) {
        Intrinsics.checkNotNullParameter(toBeTicked, "toBeTicked");
        this.levelData.set("ToBeTicked", toBeTicked);
    }

    @Deprecated(message="liquidsToBeTicked no longer exists in 1.18+ worlds", level=DeprecationLevel.WARNING)
    public final void setOldLiquidsToBeTicked(@NotNull NBTList<NBTList<NBTShort>> toBeTicked) {
        Intrinsics.checkNotNullParameter(toBeTicked, "toBeTicked");
        this.levelData.set("LiquidsToBeTicked", toBeTicked);
    }

    public final void setStructures(@NotNull NBTCompound structures) {
        Intrinsics.checkNotNullParameter(structures, "structures");
        this.levelData.set(ChunkVersionedFieldsKt.StructuresName(this.version), structures);
    }

    public final void setSectionsData(@NotNull NBTList<NBTCompound> sections) {
        Intrinsics.checkNotNullParameter(sections, "sections");
        this.levelData.set(ChunkVersionedFieldsKt.SectionName(this.version), sections);
    }

    public final void setOldEntityData(@NotNull NBTList<NBTCompound> entities) {
        Intrinsics.checkNotNullParameter(entities, "entities");
        this.levelData.set(ChunkVersionedFieldsKt.EntitiesName(this.version), entities);
    }

    public final void setBlockEntityData(@NotNull NBTList<NBTCompound> blockEntities) {
        Intrinsics.checkNotNullParameter(blockEntities, "blockEntities");
        this.levelData.set(ChunkVersionedFieldsKt.BlockEntitiesName(this.version), blockEntities);
    }

    public final void setBlockTicks(@NotNull NBTList<NBTCompound> blockTicks) {
        Intrinsics.checkNotNullParameter(blockTicks, "blockTicks");
        this.levelData.set(ChunkVersionedFieldsKt.BlockTicksName(this.version), blockTicks);
    }

    public final void setFluidTicks(@NotNull NBTList<NBTCompound> liquidTicks) {
        Intrinsics.checkNotNullParameter(liquidTicks, "liquidTicks");
        this.levelData.set(ChunkVersionedFieldsKt.FluidTicksName(this.version), liquidTicks);
    }

    public final void setAirCarvingMask(@NotNull ImmutableByteArray mask) {
        Intrinsics.checkNotNullParameter(mask, "mask");
        this.carvingMasks.set("AIR", NBT.Companion.ByteArray(mask));
    }

    public final void setLiquidCarvingMask(@NotNull ImmutableByteArray mask) {
        Intrinsics.checkNotNullParameter(mask, "mask");
        this.carvingMasks.set("LIQUID", NBT.Companion.ByteArray(mask));
    }

    @Deprecated(message="Biomes are stored per-section in 1.18+ worlds", level=DeprecationLevel.WARNING)
    public final void setOldBiomes(@NotNull ImmutableIntArray biomes) {
        Intrinsics.checkNotNullParameter(biomes, "biomes");
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            this.levelData.set("Biomes", NBT.Companion.IntArray(biomes));
        }
    }

    @NotNull
    public final NBTCompound toNBT() {
        NBT.Companion this_$iv = NBT.Companion;
        boolean $i$f$Kompound = false;
        return this_$iv.Compound(new CompoundBuilder(this){
            final /* synthetic */ ChunkWriter this$0;
            {
                this.this$0 = chunkWriter;
            }

            public final void run(@NotNull MutableNBTCompound it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MutableNBTCompound $this$toNBT_u24lambda_u2d1 = it;
                boolean bl = false;
                if (this.this$0.getVersion().compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
                    $this$toNBT_u24lambda_u2d1.setAll(ChunkWriter.access$getNbt$p(this.this$0));
                    NBT.Companion this_$iv = NBT.Companion;
                    boolean $i$f$Kompound = false;
                    $this$toNBT_u24lambda_u2d1.set("Level", this_$iv.Compound(new CompoundBuilder(this.this$0){
                        final /* synthetic */ ChunkWriter this$0;
                        {
                            this.this$0 = chunkWriter;
                        }

                        public final void run(@NotNull MutableNBTCompound it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            MutableNBTCompound $this$toNBT_u24lambda_u2d1_u24lambda_u2d0 = it;
                            boolean bl = false;
                            $this$toNBT_u24lambda_u2d1_u24lambda_u2d0.setAll(ChunkWriter.access$getLevelData$p(this.this$0));
                            $this$toNBT_u24lambda_u2d1_u24lambda_u2d0.set("Heightmaps", ChunkWriter.access$getHeightMaps$p(this.this$0).toCompound());
                            if (!ChunkWriter.access$getCarvingMasks$p(this.this$0).isEmpty()) {
                                $this$toNBT_u24lambda_u2d1_u24lambda_u2d0.set("CarvingMasks", ChunkWriter.access$getCarvingMasks$p(this.this$0).toCompound());
                            }
                        }
                    }));
                } else {
                    $this$toNBT_u24lambda_u2d1.setAll(ChunkWriter.access$getNbt$p(this.this$0));
                    $this$toNBT_u24lambda_u2d1.set("Heightmaps", ChunkWriter.access$getHeightMaps$p(this.this$0).toCompound());
                    if (!ChunkWriter.access$getCarvingMasks$p(this.this$0).isEmpty()) {
                        $this$toNBT_u24lambda_u2d1.set("CarvingMasks", ChunkWriter.access$getCarvingMasks$p(this.this$0).toCompound());
                    }
                }
            }
        });
    }

    public static final /* synthetic */ MutableNBTCompound access$getLevelData$p(ChunkWriter $this) {
        return $this.levelData;
    }

    public static final /* synthetic */ MutableNBTCompound access$getHeightMaps$p(ChunkWriter $this) {
        return $this.heightMaps;
    }

    public static final /* synthetic */ MutableNBTCompound access$getCarvingMasks$p(ChunkWriter $this) {
        return $this.carvingMasks;
    }

    public static final /* synthetic */ MutableNBTCompound access$getNbt$p(ChunkWriter $this) {
        return $this.nbt;
    }
}

