/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca.writer;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.mca.BiomePalette;
import org.jglrxavpok.hephaistos.mca.BlockPalette;
import org.jglrxavpok.hephaistos.mca.BlockState;
import org.jglrxavpok.hephaistos.mca.ChunkSection;
import org.jglrxavpok.hephaistos.mca.Palette;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.nbt.CompoundBuilder;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\fJ\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\bJ\u0016\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\bJ\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\fJ\u0006\u0010+\u001a\u00020,R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/jglrxavpok/hephaistos/mca/writer/ChunkSectionWriter;", "", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "y", "", "(Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;B)V", "biomeIndices", "", "biomePalette", "Lorg/jglrxavpok/hephaistos/mca/BiomePalette;", "blockLights", "", "blockStateIndices", "blockStatePalette", "Lorg/jglrxavpok/hephaistos/mca/BlockPalette;", "empty", "", "getEmpty", "()Z", "skyLights", "getVersion", "()Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "getY", "()B", "setAllBiomes", "", "biomes", "", "", "([Ljava/lang/String;)V", "setAllBlockStates", "blockStates", "Lorg/jglrxavpok/hephaistos/mca/BlockState;", "([Lorg/jglrxavpok/hephaistos/mca/BlockState;)V", "setBlockLights", "lights", "setPalettedBiomes", "palettedBiomes", "setPalettedBlockStates", "blockPalette", "palettedBlockStates", "setSkyLights", "toNBT", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "common"})
public final class ChunkSectionWriter {
    @NotNull
    private final SupportedVersion version;
    private final byte y;
    @NotNull
    private byte[] blockLights;
    @NotNull
    private byte[] skyLights;
    @Nullable
    private BiomePalette biomePalette;
    @Nullable
    private int[] biomeIndices;
    @Nullable
    private BlockPalette blockStatePalette;
    @Nullable
    private int[] blockStateIndices;

    public ChunkSectionWriter(@NotNull SupportedVersion version2, byte y) {
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        this.version = version2;
        this.y = y;
        this.blockLights = new byte[0];
        this.skyLights = new byte[0];
    }

    @NotNull
    public final SupportedVersion getVersion() {
        return this.version;
    }

    public final byte getY() {
        return this.y;
    }

    private final boolean getEmpty() {
        return this.blockStatePalette == null;
    }

    public final void setBlockLights(@NotNull byte[] lights) {
        Intrinsics.checkNotNullParameter(lights, "lights");
        this.blockLights = lights;
    }

    public final void setSkyLights(@NotNull byte[] lights) {
        Intrinsics.checkNotNullParameter(lights, "lights");
        this.skyLights = lights;
    }

    public final void setAllBiomes(@NotNull String[] biomes) {
        Intrinsics.checkNotNullParameter(biomes, "biomes");
        boolean bl = biomes.length == ChunkSection.Companion.getBiomeArraySize();
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "biomes.size (" + biomes.length + ") != ChunkSection.BiomeArraySize (" + ChunkSection.Companion.getBiomeArraySize() + ')';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BiomePalette biomePalette = new BiomePalette();
        for (String b : biomes) {
            biomePalette.increaseReference(b);
        }
        int n2 = 0;
        n = ChunkSection.Companion.getBiomeArraySize();
        int[] nArray = new int[n];
        BiomePalette biomePalette2 = biomePalette;
        ChunkSectionWriter chunkSectionWriter = this;
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = biomePalette.getElements().indexOf(biomes[n3]);
        }
        chunkSectionWriter.setPalettedBiomes(biomePalette2, nArray);
    }

    public final void setAllBlockStates(@NotNull BlockState[] blockStates) {
        Intrinsics.checkNotNullParameter(blockStates, "blockStates");
        boolean bl = blockStates.length == 4096;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "blockStates.size (" + blockStates.length + ") != 16x16x16 (4096)";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BlockPalette blockPalette = new BlockPalette();
        for (BlockState b : blockStates) {
            blockPalette.increaseReference(b);
        }
        int n2 = 0;
        int[] nArray = new int[4096];
        BlockPalette blockPalette2 = blockPalette;
        ChunkSectionWriter chunkSectionWriter = this;
        while (n2 < 4096) {
            int n3 = n2++;
            nArray[n3] = blockPalette.getElements().indexOf(blockStates[n3]);
        }
        chunkSectionWriter.setPalettedBlockStates(blockPalette2, nArray);
    }

    public final void setPalettedBiomes(@NotNull BiomePalette biomePalette, @NotNull int[] palettedBiomes) {
        Intrinsics.checkNotNullParameter(biomePalette, "biomePalette");
        Intrinsics.checkNotNullParameter(palettedBiomes, "palettedBiomes");
        this.biomePalette = biomePalette;
        this.biomeIndices = palettedBiomes;
    }

    public final void setPalettedBlockStates(@NotNull BlockPalette blockPalette, @NotNull int[] palettedBlockStates) {
        Intrinsics.checkNotNullParameter(blockPalette, "blockPalette");
        Intrinsics.checkNotNullParameter(palettedBlockStates, "palettedBlockStates");
        this.blockStatePalette = blockPalette;
        this.blockStateIndices = palettedBlockStates;
    }

    @NotNull
    public final NBTCompound toNBT() {
        NBT.Companion this_$iv = NBT.Companion;
        boolean $i$f$Kompound = false;
        return this_$iv.Compound(new CompoundBuilder(this){
            final /* synthetic */ ChunkSectionWriter this$0;
            {
                this.this$0 = chunkSectionWriter;
            }

            public final void run(@NotNull MutableNBTCompound it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MutableNBTCompound $this$toNBT_u24lambda_u2d4 = it;
                boolean bl = false;
                $this$toNBT_u24lambda_u2d4.set("Y", NBT.Companion.Byte(this.this$0.getY()));
                Object object = ChunkSectionWriter.access$getBlockLights$p(this.this$0);
                boolean bl2 = false;
                byte[] byArray = object;
                boolean bl3 = false;
                if (!(byArray.length == 0)) {
                    object = ChunkSectionWriter.access$getBlockLights$p(this.this$0);
                    $this$toNBT_u24lambda_u2d4.set("BlockLight", NBT.Companion.ByteArray(Arrays.copyOf(object, ((byte[])object).length)));
                }
                object = ChunkSectionWriter.access$getSkyLights$p(this.this$0);
                bl2 = false;
                byArray = object;
                bl3 = false;
                if (!(byArray.length == 0)) {
                    object = ChunkSectionWriter.access$getSkyLights$p(this.this$0);
                    $this$toNBT_u24lambda_u2d4.set("SkyLight", NBT.Companion.ByteArray(Arrays.copyOf(object, ((byte[])object).length)));
                }
                if (!ChunkSectionWriter.access$getEmpty(this.this$0)) {
                    if (this.this$0.getVersion().compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
                        object = ChunkSectionWriter.access$getBlockStatePalette$p(this.this$0);
                        Intrinsics.checkNotNull(object);
                        $this$toNBT_u24lambda_u2d4.set("Palette", object.toNBT());
                        object = ChunkSectionWriter.access$getBlockStatePalette$p(this.this$0);
                        Intrinsics.checkNotNull(object);
                        byte[] byArray2 = object;
                        object = ChunkSectionWriter.access$getBlockStateIndices$p(this.this$0);
                        Intrinsics.checkNotNull(object);
                        $this$toNBT_u24lambda_u2d4.set("BlockStates", NBT.Companion.LongArray(byArray2.compactPreProcessedIDs((int[])object, this.this$0.getVersion(), 4)));
                    } else {
                        NBT.Companion this_$iv = NBT.Companion;
                        boolean $i$f$Kompound = false;
                        $this$toNBT_u24lambda_u2d4.set("block_states", this_$iv.Compound(new CompoundBuilder(this.this$0){
                            final /* synthetic */ ChunkSectionWriter this$0;
                            {
                                this.this$0 = chunkSectionWriter;
                            }

                            public final void run(@NotNull MutableNBTCompound it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                MutableNBTCompound $this$toNBT_u24lambda_u2d4_u24lambda_u2d2 = it;
                                boolean bl = false;
                                Object object = ChunkSectionWriter.access$getBlockStatePalette$p(this.this$0);
                                Intrinsics.checkNotNull(object);
                                $this$toNBT_u24lambda_u2d4_u24lambda_u2d2.set("palette", ((Palette)object).toNBT());
                                object = ChunkSectionWriter.access$getBlockStatePalette$p(this.this$0);
                                Intrinsics.checkNotNull(object);
                                BlockPalette blockPalette = object;
                                object = ChunkSectionWriter.access$getBlockStateIndices$p(this.this$0);
                                Intrinsics.checkNotNull(object);
                                $this$toNBT_u24lambda_u2d4_u24lambda_u2d2.set("data", NBT.Companion.LongArray(blockPalette.compactPreProcessedIDs((int[])object, this.this$0.getVersion(), 4)));
                            }
                        }));
                        if (ChunkSectionWriter.access$getBiomePalette$p(this.this$0) != null) {
                            this_$iv = NBT.Companion;
                            $i$f$Kompound = false;
                            $this$toNBT_u24lambda_u2d4.set("biomes", this_$iv.Compound(new CompoundBuilder(this.this$0){
                                final /* synthetic */ ChunkSectionWriter this$0;
                                {
                                    this.this$0 = chunkSectionWriter;
                                }

                                public final void run(@NotNull MutableNBTCompound it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    MutableNBTCompound $this$toNBT_u24lambda_u2d4_u24lambda_u2d3 = it;
                                    boolean bl = false;
                                    Object object = ChunkSectionWriter.access$getBiomePalette$p(this.this$0);
                                    Intrinsics.checkNotNull(object);
                                    $this$toNBT_u24lambda_u2d4_u24lambda_u2d3.set("palette", ((Palette)object).toNBT());
                                    object = ChunkSectionWriter.access$getBiomePalette$p(this.this$0);
                                    Intrinsics.checkNotNull(object);
                                    Palette palette = (Palette)object;
                                    object = ChunkSectionWriter.access$getBiomeIndices$p(this.this$0);
                                    Intrinsics.checkNotNull(object);
                                    $this$toNBT_u24lambda_u2d4_u24lambda_u2d3.set("data", NBT.Companion.LongArray(Palette.compactPreProcessedIDs$default(palette, (int[])object, this.this$0.getVersion(), 0, 4, null)));
                                }
                            }));
                        }
                    }
                }
            }
        });
    }

    public static final /* synthetic */ BlockPalette access$getBlockStatePalette$p(ChunkSectionWriter $this) {
        return $this.blockStatePalette;
    }

    public static final /* synthetic */ int[] access$getBlockStateIndices$p(ChunkSectionWriter $this) {
        return $this.blockStateIndices;
    }

    public static final /* synthetic */ BiomePalette access$getBiomePalette$p(ChunkSectionWriter $this) {
        return $this.biomePalette;
    }

    public static final /* synthetic */ int[] access$getBiomeIndices$p(ChunkSectionWriter $this) {
        return $this.biomeIndices;
    }

    public static final /* synthetic */ byte[] access$getBlockLights$p(ChunkSectionWriter $this) {
        return $this.blockLights;
    }

    public static final /* synthetic */ byte[] access$getSkyLights$p(ChunkSectionWriter $this) {
        return $this.skyLights;
    }

    public static final /* synthetic */ boolean access$getEmpty(ChunkSectionWriter $this) {
        return $this.getEmpty();
    }
}

