/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca.readers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.BiomePalette;
import org.jglrxavpok.hephaistos.mca.ChunkSection;
import org.jglrxavpok.hephaistos.mca.LongCompactorKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.SectionBiomeInformation;
import org.jglrxavpok.hephaistos.mcdata.Biome;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTString;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jglrxavpok/hephaistos/mca/readers/ChunkSectionReader;", "", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "nbt", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "(Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;)V", "getNbt", "()Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "getVersion", "()Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "y", "", "getY", "()B", "getBiomeInformation", "Lorg/jglrxavpok/hephaistos/mca/readers/SectionBiomeInformation;", "getBiomes", "getBlockLight", "Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "getBlockPalette", "Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "getCompactedBlockStates", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "getSkyLight", "getUncompressedBiomeIndices", "", "getUncompressedBlockStateIDs", "hasBiomes", "", "hasBlockStates", "isSectionEmpty", "Companion", "common"})
public final class ChunkSectionReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SupportedVersion version;
    @NotNull
    private final NBTCompound nbt;
    private final byte y;

    public ChunkSectionReader(@NotNull SupportedVersion version2, @NotNull NBTCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this.version = version2;
        this.nbt = nbt;
        this.y = Companion.getY(this.nbt);
    }

    @NotNull
    public final SupportedVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final NBTCompound getNbt() {
        return this.nbt;
    }

    public final byte getY() {
        return this.y;
    }

    public final boolean isSectionEmpty() {
        return this.getBlockPalette() == null;
    }

    @Nullable
    public final NBTList<NBTCompound> getBlockPalette() {
        NBTCompound nBTCompound;
        return this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0 ? this.nbt.getList("Palette") : ((nBTCompound = this.nbt.getCompound("block_states")) == null ? null : nBTCompound.getList("palette"));
    }

    @NotNull
    public final ImmutableLongArray getCompactedBlockStates() {
        ImmutableLongArray immutableLongArray;
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            ImmutableLongArray immutableLongArray2 = this.nbt.getLongArray("BlockStates");
            if (immutableLongArray2 == null) {
                AnvilException.Companion.missing("BlockStates");
                throw new KotlinNothingValueException();
            }
            immutableLongArray = immutableLongArray2;
        } else {
            NBTCompound nBTCompound = this.nbt.getCompound("block_states");
            if (nBTCompound == null) {
                AnvilException.Companion.missing("block_states");
                throw new KotlinNothingValueException();
            }
            ImmutableLongArray immutableLongArray3 = nBTCompound.getLongArray("data");
            immutableLongArray = immutableLongArray3 == null ? new ImmutableLongArray(new long[0]) : immutableLongArray3;
        }
        return immutableLongArray;
    }

    public final boolean hasBlockStates() {
        boolean bl;
        NBTCompound nBTCompound;
        return this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0 ? this.nbt.containsKey("BlockStates") : ((nBTCompound = this.nbt.getCompound("block_states")) == null ? false : (bl = nBTCompound.containsKey("data")));
    }

    @Nullable
    public final ImmutableByteArray getBlockLight() {
        return this.nbt.getByteArray("BlockLight");
    }

    @Nullable
    public final ImmutableByteArray getSkyLight() {
        return this.nbt.getByteArray("SkyLight");
    }

    public final boolean hasBiomes() {
        return this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) >= 0 && this.nbt.contains("biomes");
    }

    @Nullable
    public final NBTCompound getBiomes() {
        return this.nbt.getCompound("biomes");
    }

    @NotNull
    public final int[] getUncompressedBlockStateIDs() {
        ImmutableLongArray compactedBlockStates = this.getCompactedBlockStates();
        int sizeInBits = compactedBlockStates.getSize() * 64 / 4096;
        if (this.version == SupportedVersion.MC_1_15) {
            int[] ids = LongCompactorKt.decompress(compactedBlockStates, sizeInBits);
            if (ids.length != 4096) {
                throw new AnvilException("Invalid decompressed BlockStates length (" + ids.length + "). Must be 4096 (16x16x16)");
            }
            return ids;
        }
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_16) >= 0) {
            int[] nArray;
            int n;
            int n2;
            if (compactedBlockStates.getSize() == 0) {
                n2 = -1;
            } else {
                int intPerLong = 64 / sizeInBits;
                double d = 4096.0 / (double)intPerLong;
                n = 0;
                n2 = (int)Math.ceil(d);
            }
            int expectedCompressedLength = n2;
            boolean unpack = true;
            if (compactedBlockStates.getSize() != expectedCompressedLength) {
                if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) >= 0 && compactedBlockStates.getSize() == 0) {
                    unpack = false;
                } else {
                    throw new AnvilException("Invalid compressed BlockStates length (" + compactedBlockStates.getSize() + "). At " + sizeInBits + " bit per value, expected " + expectedCompressedLength + " bytes. Note that 0 length is not allowed with pre 1.18 formats.");
                }
            }
            if (unpack) {
                nArray = ArraysKt.sliceArray(LongCompactorKt.unpack(compactedBlockStates, sizeInBits), RangesKt.until(0, 4096));
            } else {
                int n3 = 0;
                int[] nArray2 = new int[4096];
                while (n3 < 4096) {
                    n = n3++;
                    nArray2[n] = 0;
                }
                nArray = nArray2;
            }
            return nArray;
        }
        throw new AnvilException(Intrinsics.stringPlus("Unsupported version for compressed block states: ", (Object)this.version));
    }

    @NotNull
    public final int[] getUncompressedBiomeIndices() {
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            throw new AnvilException("No biomes inside sections before 1.18");
        }
        NBTCompound nBTCompound = this.getBiomes();
        Intrinsics.checkNotNull(nBTCompound);
        NBTCompound biomesNBT = nBTCompound;
        NBTList nBTList = biomesNBT.getList("palette");
        Intrinsics.checkNotNull(nBTList);
        NBTList biomePalette = nBTList;
        if (biomePalette.getSize() == 1) {
            int n = 0;
            int n2 = ChunkSection.Companion.getBiomeArraySize();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = 0;
            }
            return nArray;
        }
        ImmutableLongArray immutableLongArray = biomesNBT.getLongArray("data");
        Intrinsics.checkNotNull(immutableLongArray);
        ImmutableLongArray compressedBiomes = immutableLongArray;
        double d = MathKt.log2((double)biomePalette.getSize());
        boolean bl = false;
        int sizeInBits = (int)Math.ceil(d);
        int intPerLong = 64 / sizeInBits;
        double d2 = (double)ChunkSection.Companion.getBiomeArraySize() / (double)intPerLong;
        boolean bl2 = false;
        int expectedCompressedLength = (int)Math.ceil(d2);
        if (compressedBiomes.getSize() != expectedCompressedLength) {
            throw new AnvilException("Invalid compressed biomes length (" + compressedBiomes.getSize() + "). At " + sizeInBits + " bit per value, expected " + expectedCompressedLength + " bytes");
        }
        return ArraysKt.sliceArray(LongCompactorKt.unpack(compressedBiomes, sizeInBits), RangesKt.until(0, ChunkSection.Companion.getBiomeArraySize()));
    }

    @NotNull
    public final SectionBiomeInformation getBiomeInformation() {
        int[] ids;
        int n;
        if (!this.hasBiomes()) {
            return new SectionBiomeInformation();
        }
        String[] biomes = null;
        NBTCompound nBTCompound = this.getBiomes();
        Intrinsics.checkNotNull(nBTCompound);
        NBTCompound biomesNBT = nBTCompound;
        NBTList<NBTString> nBTList = biomesNBT.getList("palette");
        if (nBTList == null) {
            AnvilException.Companion.missing("biomes.palette");
            throw new KotlinNothingValueException();
        }
        NBTList<NBTString> paletteNBT = nBTList;
        BiomePalette biomePalette = new BiomePalette(paletteNBT);
        if (!biomesNBT.contains("data")) {
            if (biomePalette.getElements().size() > 0) {
                return new SectionBiomeInformation(null, (String)biomePalette.getElements().get(0));
            }
            return new SectionBiomeInformation();
        }
        int n2 = 0;
        int n3 = ChunkSection.Companion.getBiomeArraySize();
        String[] stringArray = new String[n3];
        while (n2 < n3) {
            n = n2++;
            stringArray[n] = Biome.Companion.getUnknownBiome();
        }
        biomes = stringArray;
        int[] nArray = ids = this.getUncompressedBiomeIndices();
        n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            int id2 = nArray[i];
            Object ElementType2 = biomePalette.getElements().get(id2);
            Intrinsics.checkNotNullExpressionValue(ElementType2, "biomePalette.elements[id]");
            biomes[index] = (String)ElementType2;
        }
        return new SectionBiomeInformation(biomes, null);
    }

    @JvmStatic
    public static final byte getY(@NotNull NBTCompound nbt) throws AnvilException {
        return Companion.getY(nbt);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jglrxavpok/hephaistos/mca/readers/ChunkSectionReader$Companion;", "", "()V", "getY", "", "nbt", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final byte getY(@NotNull NBTCompound nbt) throws AnvilException {
            Intrinsics.checkNotNullParameter(nbt, "nbt");
            Byte by = nbt.getByte("Y");
            if (by == null) {
                AnvilException.Companion.missing("Y");
                throw new KotlinNothingValueException();
            }
            return by;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

