/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca.readers;

import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.collections.ImmutableIntArray;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.ChunkColumn;
import org.jglrxavpok.hephaistos.mca.ChunkSection;
import org.jglrxavpok.hephaistos.mca.CoordinatesKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.ChunkSectionReader;
import org.jglrxavpok.hephaistos.mca.readers.ChunkVersionedFieldsKt;
import org.jglrxavpok.hephaistos.mca.readers.SectionBiomeInformation;
import org.jglrxavpok.hephaistos.mcdata.Biome;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTShort;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0014\u0010\u001b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0010\u0018\u00010\u0010J\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0006\u0010\u001f\u001a\u00020\fJ\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010\"\u001a\u0004\u0018\u00010!J\b\u0010#\u001a\u0004\u0018\u00010!J\b\u0010$\u001a\u0004\u0018\u00010!J\b\u0010%\u001a\u0004\u0018\u00010&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0014\u0010(\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0010\u0018\u00010\u0010J\u0014\u0010)\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0010\u0018\u00010\u0010J\u0014\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u0010\u0018\u00010\u0010J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\b\u0010,\u001a\u0004\u0018\u00010\u0003J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0007J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\b\u0010/\u001a\u0004\u0018\u00010!J\b\u00100\u001a\u0004\u0018\u00010!J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204J\u0010\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jglrxavpok/hephaistos/mca/readers/ChunkReader;", "", "chunkData", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "(Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;)V", "getChunkData", "()Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "dataVersion", "", "levelData", "getLevelData", "minecraftVersion", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "getAirCarvingMask", "Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "getBlockEntities", "Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "getCarvingMasks", "getChunkX", "getChunkZ", "getDataVersion", "getGenerationStatus", "Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "getHeightmaps", "getInhabitedTime", "", "getLastUpdate", "getLights", "Lorg/jglrxavpok/hephaistos/nbt/NBTShort;", "getLiquidCarvingMask", "getLiquidTicks", "getMinecraftVersion", "getMotionBlockingHeightmap", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "getMotionBlockingNoLeavesHeightmap", "getOceanFloorHeightmap", "getOceanFloorWorldGenHeightmap", "getOldBiomes", "Lorg/jglrxavpok/hephaistos/collections/ImmutableIntArray;", "getOldEntities", "getOldLiquidsToBeTicked", "getOldToBeTicked", "getPostProcessing", "getSections", "getStructures", "getTileEntities", "getTileTicks", "getWorldSurfaceHeightmap", "getWorldSurfaceWorldGenHeightmap", "getYRange", "Lkotlin/ranges/IntRange;", "hasHeightmaps", "", "isLightOn", "readSectionBiomes", "Lorg/jglrxavpok/hephaistos/mca/readers/SectionBiomeInformation;", "chunkSectionReader", "Lorg/jglrxavpok/hephaistos/mca/readers/ChunkSectionReader;", "common"})
public final class ChunkReader {
    @NotNull
    private final NBTCompound chunkData;
    private final int dataVersion;
    @NotNull
    private final SupportedVersion minecraftVersion;

    public ChunkReader(@NotNull NBTCompound chunkData) throws AnvilException {
        Intrinsics.checkNotNullParameter(chunkData, "chunkData");
        this.chunkData = chunkData;
        Integer n = this.chunkData.getInt("DataVersion");
        if (n == null) {
            AnvilException.Companion.missing("DataVersion");
            throw new KotlinNothingValueException();
        }
        this.dataVersion = n;
        this.minecraftVersion = SupportedVersion.Companion.closest(this.dataVersion);
    }

    @NotNull
    public final NBTCompound getChunkData() {
        return this.chunkData;
    }

    private final NBTCompound getLevelData() {
        NBTCompound nBTCompound;
        if (this.minecraftVersion.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            NBTCompound nBTCompound2 = this.chunkData.getCompound("Level");
            if (nBTCompound2 == null) {
                AnvilException.Companion.missing("Level");
                throw new KotlinNothingValueException();
            }
            nBTCompound = nBTCompound2;
        } else {
            nBTCompound = this.chunkData;
        }
        return nBTCompound;
    }

    public final int getDataVersion() {
        return this.dataVersion;
    }

    @NotNull
    public final SupportedVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public final int getChunkX() {
        Integer n = this.getLevelData().getInt("xPos");
        if (n == null) {
            AnvilException.Companion.missing("xPos");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    public final int getChunkZ() {
        Integer n = this.getLevelData().getInt("zPos");
        if (n == null) {
            AnvilException.Companion.missing("zPos");
            throw new KotlinNothingValueException();
        }
        return n;
    }

    @NotNull
    public final NBTList<NBTCompound> getSections() {
        NBTList<NBTCompound> nBTList = this.getLevelData().getList(ChunkVersionedFieldsKt.SectionName(this.minecraftVersion));
        if (nBTList == null) {
            AnvilException.Companion.missing(ChunkVersionedFieldsKt.SectionName(this.minecraftVersion));
            throw new KotlinNothingValueException();
        }
        return nBTList;
    }

    public final long getLastUpdate() {
        Long l = this.getLevelData().getLong("LastUpdate");
        return l == null ? 0L : l;
    }

    public final long getInhabitedTime() {
        Long l = this.getLevelData().getLong("InhabitedTime");
        return l == null ? 0L : l;
    }

    @NotNull
    public final ChunkColumn.GenerationStatus getGenerationStatus() {
        String string = this.getLevelData().getString("Status");
        if (string == null) {
            AnvilException.Companion.missing("Status");
            throw new KotlinNothingValueException();
        }
        return ChunkColumn.GenerationStatus.Companion.fromID(string);
    }

    @NotNull
    public final IntRange getYRange() {
        int minY = 0;
        int maxY = 0;
        if (this.minecraftVersion.compareTo((Enum)SupportedVersion.MC_1_17_0) < 0) {
            minY = 0;
            maxY = 255;
        } else if (this.minecraftVersion.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            int minSectionY = 127;
            for (NBTCompound nBTCompound : this.getSections()) {
                Byte bl = nBTCompound.getByte("Y");
                if (bl == null) {
                    AnvilException.Companion.missing("Y");
                    throw new KotlinNothingValueException();
                }
                byte sectionY = bl;
                boolean by = false;
                minSectionY = (byte)Math.min(minSectionY, sectionY);
            }
            ImmutableIntArray immutableIntArray = this.getLevelData().getIntArray("Biomes");
            if (immutableIntArray == null) {
                throw new AnvilException("Cannot guess minY-maxY of chunk without biome information for 1.17 worlds");
            }
            ImmutableIntArray biomes = immutableIntArray;
            minY = CoordinatesKt.sectionToBlock(minSectionY + 1);
            maxY = CoordinatesKt.sectionToBlock(biomes.getSize() / ChunkSection.Companion.getBiomeArraySize()) + minY - 1;
        } else {
            Integer n = this.getLevelData().getInt("yPos");
            if (n == null) {
                AnvilException.Companion.missing("yPos");
                throw new KotlinNothingValueException();
            }
            maxY = minY = CoordinatesKt.sectionToBlock(n);
            for (NBTCompound nbt : this.getSections()) {
                Byte by = nbt.getByte("Y");
                if (by == null) {
                    AnvilException.Companion.missing("Y");
                    throw new KotlinNothingValueException();
                }
                byte by2 = by;
                int by3 = CoordinatesKt.sectionToBlock(by2) + 15;
                boolean bl = false;
                maxY = Math.max(maxY, by3);
            }
        }
        return new IntRange(minY, maxY);
    }

    @NotNull
    public final NBTList<NBTCompound> getOldEntities() {
        NBTList nBTList = this.getLevelData().getList(ChunkVersionedFieldsKt.EntitiesName(this.minecraftVersion));
        return nBTList == null ? NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null) : nBTList;
    }

    @NotNull
    public final NBTList<NBTCompound> getBlockEntities() {
        NBTList nBTList = this.getLevelData().getList(ChunkVersionedFieldsKt.BlockEntitiesName(this.minecraftVersion));
        return nBTList == null ? NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null) : nBTList;
    }

    @Deprecated(message="Tile entities is the old name", replaceWith=@ReplaceWith(expression="ChunkReader#getBlockEntities()", imports={}))
    @NotNull
    public final NBTList<NBTCompound> getTileEntities() {
        return this.getBlockEntities();
    }

    @NotNull
    public final NBTList<NBTCompound> getTileTicks() {
        NBTList nBTList = this.getLevelData().getList(ChunkVersionedFieldsKt.BlockTicksName(this.minecraftVersion));
        return nBTList == null ? NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null) : nBTList;
    }

    @NotNull
    public final NBTList<NBTCompound> getLiquidTicks() {
        NBTList nBTList = this.getLevelData().getList(ChunkVersionedFieldsKt.FluidTicksName(this.minecraftVersion));
        return nBTList == null ? NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null) : nBTList;
    }

    @Nullable
    public final NBTCompound getStructures() {
        return this.getLevelData().getCompound(ChunkVersionedFieldsKt.StructuresName(this.minecraftVersion));
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getLights() {
        return this.getLevelData().getList("Lights");
    }

    public final boolean isLightOn() {
        Boolean bl = this.getLevelData().getBoolean("isLightOn");
        return bl == null ? true : bl;
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getPostProcessing() {
        return this.getLevelData().getList("PostProcessing");
    }

    @Nullable
    public final ImmutableIntArray getOldBiomes() {
        return this.getLevelData().getIntArray("Biomes");
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getOldLiquidsToBeTicked() {
        return this.getLevelData().getList("LiquidsToBeTicked");
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getOldToBeTicked() {
        return this.getLevelData().getList("ToBeTicked");
    }

    @Nullable
    public final NBTCompound getCarvingMasks() {
        return this.getLevelData().getCompound("CarvingMasks");
    }

    @Nullable
    public final ImmutableByteArray getAirCarvingMask() {
        NBTCompound nBTCompound = this.getCarvingMasks();
        return nBTCompound == null ? null : nBTCompound.getByteArray("AIR");
    }

    @Nullable
    public final ImmutableByteArray getLiquidCarvingMask() {
        NBTCompound nBTCompound = this.getCarvingMasks();
        return nBTCompound == null ? null : nBTCompound.getByteArray("LIQUID");
    }

    public final boolean hasHeightmaps() {
        return this.getLevelData().contains("Heightmaps");
    }

    @Nullable
    public final NBTCompound getHeightmaps() {
        return this.getLevelData().getCompound("Heightmaps");
    }

    @Nullable
    public final ImmutableLongArray getMotionBlockingHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("MOTION_BLOCKING");
    }

    @Nullable
    public final ImmutableLongArray getWorldSurfaceHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("WORLD_SURFACE");
    }

    @Nullable
    public final ImmutableLongArray getMotionBlockingNoLeavesHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("MOTION_BLOCKING_NO_LEAVES");
    }

    @Nullable
    public final ImmutableLongArray getWorldSurfaceWorldGenHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("WORLD_SURFACE_WG");
    }

    @Nullable
    public final ImmutableLongArray getOceanFloorHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("OCEAN_FLOOR");
    }

    @Nullable
    public final ImmutableLongArray getOceanFloorWorldGenHeightmap() {
        NBTCompound nBTCompound = this.getHeightmaps();
        return nBTCompound == null ? null : nBTCompound.getLongArray("OCEAN_FLOOR_WG");
    }

    @Nullable
    public final SectionBiomeInformation readSectionBiomes(@NotNull ChunkSectionReader chunkSectionReader) {
        Intrinsics.checkNotNullParameter(chunkSectionReader, "chunkSectionReader");
        IntRange yRange = this.getYRange();
        byte sectionY = chunkSectionReader.getY();
        int n = yRange.getFirst();
        int n2 = yRange.getLast();
        int n3 = sectionY * 16;
        if (!(n <= n3 ? n3 <= n2 : false)) {
            throw new AnvilException("Accessing a section outside of the chunk! (SectionY=" + sectionY + " Y=" + sectionY * 16 + " but minY..maxY is " + yRange.getFirst() + ".." + yRange.getLast() + ')');
        }
        if (this.getGenerationStatus().compareTo((Enum)ChunkColumn.GenerationStatus.Biomes) < 0) {
            return null;
        }
        if (this.minecraftVersion.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            ImmutableIntArray biomes = this.getOldBiomes();
            if (biomes != null) {
                int offset = sectionY * 4 * 4 * 4;
                int n4 = 0;
                String[] stringArray = new String[64];
                while (n4 < 64) {
                    int n5 = n4++;
                    stringArray[n5] = Biome.Companion.getUnknownBiome();
                }
                String[] biomeNames = stringArray;
                n4 = offset;
                int n6 = offset + 64;
                if (n4 < n6) {
                    do {
                        int index = n4++;
                        biomeNames[index - offset] = Biome.Companion.numericalIDToNamespaceID(biomes.get(index));
                    } while (n4 < n6);
                }
                return new SectionBiomeInformation(biomeNames, null);
            }
            return null;
        }
        return chunkSectionReader.getBiomeInformation();
    }
}

