/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.data.DataSource;
import org.jglrxavpok.hephaistos.data.RandomAccessFileSource;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.BlockState;
import org.jglrxavpok.hephaistos.mca.ChunkColumn;
import org.jglrxavpok.hephaistos.mca.CoordinatesKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mcdata.SizesKt;
import org.jglrxavpok.hephaistos.nbt.CompressedProcesser;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 Z2\u00020\u0001:\u0001ZB3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB3\b\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020 H\u0002J\u0019\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0082\bJ\b\u0010$\u001a\u00020 H\u0016J\u0019\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0082\bJ\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0006\u0010*\u001a\u00020 J\u000e\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u000fJ\u001e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u001e\u00102\u001a\u0002032\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0018\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0016\u00107\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0016\u00108\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0016\u00109\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0019\u0010:\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0082\bJ\u0019\u0010;\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0082\bJ\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J\u0018\u0010D\u001a\u0002062\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u0010E\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?H\u0002J\u0011\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0082\bJ&\u0010H\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u0010I\u001a\u00020.J&\u0010J\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u0010K\u001a\u000203J\u0011\u0010L\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0082\bJ\u0018\u0010M\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010N\u001a\u00020=H\u0002J\u0018\u0010O\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010P\u001a\u00020BH\u0002J\u001a\u0010Q\u001a\u00020 2\u0006\u0010,\u001a\u00020\u000f2\b\b\u0002\u0010R\u001a\u00020SH\u0007J\u001e\u0010T\u001a\u00020 2\u0006\u0010U\u001a\u0002062\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J\u0018\u0010V\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010W\u001a\u00020\u0005H\u0002J\u0018\u0010X\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J\u0018\u0010Y\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lorg/jglrxavpok/hephaistos/mca/RegionFile;", "Ljava/io/Closeable;", "file", "Ljava/io/RandomAccessFile;", "regionX", "", "regionZ", "minY", "maxY", "(Ljava/io/RandomAccessFile;IIII)V", "dataSource", "Lorg/jglrxavpok/hephaistos/data/DataSource;", "(Lorg/jglrxavpok/hephaistos/data/DataSource;IIII)V", "columnCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jglrxavpok/hephaistos/mca/ChunkColumn;", "getDataSource", "()Lorg/jglrxavpok/hephaistos/data/DataSource;", "freeSectors", "", "", "locations", "", "logicalHeight", "getLogicalHeight", "()I", "getMaxY", "getMinY", "getRegionX", "getRegionZ", "timestamps", "addPadding", "", "buildLocation", "start", "length", "close", "fileOffset", "chunkX", "chunkZ", "findAvailableSectors", "sectorCount", "flushCachedChunks", "forget", "column", "getBiome", "", "x", "y", "z", "getBlockState", "Lorg/jglrxavpok/hephaistos/mca/BlockState;", "getChunk", "getChunkData", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "getOrCreateChunk", "hasChunk", "hasLoadedChunk", "index", "out", "readByte", "", "pos", "", "readBytes", "destination", "", "readColumn", "readColumnData", "readInt", "sectorOffset", "location", "setBiome", "biomeID", "setBlockState", "blockState", "sizeInSectors", "writeByte", "b", "writeBytes", "bytes", "writeColumn", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "writeColumnData", "data", "writeInt", "int", "writeLocation", "writeTimestamp", "Companion", "common"})
public final class RegionFile
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSource dataSource;
    private final int regionX;
    private final int regionZ;
    private final int minY;
    private final int maxY;
    @NotNull
    private final int[] locations;
    @NotNull
    private final int[] timestamps;
    @NotNull
    private final List<Boolean> freeSectors;
    @NotNull
    private final ConcurrentHashMap<Integer, ChunkColumn> columnCache;
    private final int logicalHeight;
    private static final byte GZipCompression = 1;
    private static final byte ZlibCompression = 2;
    private static final byte NoCompression = 3;
    private static final int MaxEntryCount = 1024;
    private static final int SectorSize = 4096;
    private static final int Sector1MB = 256;
    private static final int HeaderLength = 8192;
    private static final int ChunkHeaderLength = 5;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public RegionFile(@NotNull DataSource dataSource, int regionX, int regionZ, int minY, int maxY) throws AnvilException, IOException {
        int i;
        void it;
        Object object;
        boolean $i$a$-repeat-RegionFile$22;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(dataSource, "dataSource");
        this.dataSource = dataSource;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.minY = minY;
        this.maxY = maxY;
        this.locations = new int[1024];
        this.timestamps = new int[1024];
        this.columnCache = new ConcurrentHashMap();
        this.logicalHeight = this.maxY - this.minY + 1;
        if (this.minY > this.maxY) {
            throw new AnvilException("minY must be <= maxY");
        }
        this.dataSource.seek(0L);
        if (this.dataSource.length() < 8192L) {
            int n3 = 8192;
            boolean bl = false;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int it22 = n2++;
                $i$a$-repeat-RegionFile$22 = false;
                this.getDataSource().writeByte(0);
            }
        }
        this.addPadding();
        long availableSectors = this.dataSource.length() / (long)4096;
        n2 = (int)availableSectors;
        RegionFile regionFile = this;
        n = 0;
        ArrayList<Boolean> it22 = new ArrayList<Boolean>(n2);
        $i$a$-repeat-RegionFile$22 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n2;
        while (n4 < n5) {
            int n6 = n4++;
            boolean bl = false;
            int n7 = n6;
            object = it22;
            boolean bl2 = false;
            Boolean bl3 = true;
            ((ArrayList)object).add(bl3);
        }
        object = it22;
        ArrayList<Boolean> arrayList = object;
        n = 0;
        boolean it22 = false;
        ArrayList<Boolean> $i$a$-repeat-RegionFile$22 = arrayList;
        boolean bl = false;
        it.set(0, false);
        it.set(1, false);
        object = Unit.INSTANCE;
        regionFile.freeSectors = arrayList;
        this.dataSource.seek(0L);
        int n8 = 0;
        do {
            int location;
            i = n8++;
            this.locations[i] = location = this.dataSource.readInt();
            if (location == 0) continue;
            RegionFile this_$iv = this;
            boolean $i$f$sectorOffset = false;
            this_$iv = this;
            boolean $i$f$sizeInSectors = false;
            if ((location >>> 8) + (location & 0xFF) > this.freeSectors.size()) continue;
            int n9 = 0;
            RegionFile this_$iv2 = this;
            boolean $i$f$sizeInSectors2 = false;
            n4 = location & 0xFF;
            if (n9 >= n4) continue;
            do {
                int sectorIndex = n9++;
                RegionFile this_$iv3 = this;
                boolean $i$f$sectorOffset2 = false;
                this.freeSectors.set(sectorIndex + (location >>> 8), false);
            } while (n9 < n4);
        } while (n8 < 1024);
        n8 = 0;
        do {
            i = n8++;
            this.timestamps[i] = this.dataSource.readInt();
        } while (n8 < 1024);
    }

    public /* synthetic */ RegionFile(DataSource dataSource, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) throws AnvilException, IOException {
        if ((n5 & 8) != 0) {
            n3 = SizesKt.getVanillaMinY();
        }
        if ((n5 & 0x10) != 0) {
            n4 = SizesKt.getVanillaMaxY();
        }
        this(dataSource, n, n2, n3, n4);
    }

    @NotNull
    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final int getRegionX() {
        return this.regionX;
    }

    public final int getRegionZ() {
        return this.regionZ;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final int getLogicalHeight() {
        return this.logicalHeight;
    }

    @JvmOverloads
    public RegionFile(@NotNull RandomAccessFile file, int regionX, int regionZ, int minY, int maxY) throws AnvilException, IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        this(new RandomAccessFileSource(file), regionX, regionZ, minY, maxY);
    }

    public /* synthetic */ RegionFile(RandomAccessFile randomAccessFile, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) throws AnvilException, IOException {
        if ((n5 & 8) != 0) {
            n3 = SizesKt.getVanillaMinY();
        }
        if ((n5 & 0x10) != 0) {
            n4 = SizesKt.getVanillaMaxY();
        }
        this(randomAccessFile, n, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ChunkColumn getChunk(int x, int z) throws AnvilException, IOException {
        void chunkX$iv;
        RegionFile this_$iv = this;
        int $i$f$out = 0;
        if (CoordinatesKt.chunkToRegion(x) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z) != this_$iv.getRegionZ()) {
            throw new AnvilException("Out of RegionFile: " + x + ',' + z + " (chunk)");
        }
        if (!this.hasLoadedChunk(x, z)) {
            return null;
        }
        this_$iv = this;
        $i$f$out = CoordinatesKt.chunkInsideRegion(x);
        int chunkZ$iv = CoordinatesKt.chunkInsideRegion(z);
        boolean $i$f$index = false;
        return this.columnCache.computeIfAbsent((CoordinatesKt.chunkInsideRegion((int)chunkX$iv) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ$iv) & 0x1F) * 32, arg_0 -> RegionFile.getChunk$lambda-3(this, x, z, arg_0));
    }

    @Nullable
    public final NBTCompound getChunkData(int x, int z) throws AnvilException, IOException {
        RegionFile this_$iv = this;
        boolean $i$f$out = false;
        if (CoordinatesKt.chunkToRegion(x) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z) != this_$iv.getRegionZ()) {
            throw new AnvilException("Out of RegionFile: " + x + ',' + z + " (chunk)");
        }
        if (!this.hasLoadedChunk(x, z)) {
            return null;
        }
        return this.readColumnData(CoordinatesKt.chunkInsideRegion(x), CoordinatesKt.chunkInsideRegion(z));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChunkColumn getOrCreateChunk(int x, int z) throws AnvilException, IOException {
        void chunkX$iv;
        Object this_$iv = this;
        boolean $i$f$out22 = false;
        if (CoordinatesKt.chunkToRegion(x) != ((RegionFile)this_$iv).getRegionX() || CoordinatesKt.chunkToRegion(z) != ((RegionFile)this_$iv).getRegionZ()) {
            throw new AnvilException("Out of RegionFile: " + x + ',' + z + " (chunk)");
        }
        if (this.hasChunk(x, z)) {
            this_$iv = this.getChunk(x, z);
            Intrinsics.checkNotNull(this_$iv);
            return this_$iv;
        }
        RegionFile $i$f$out22 = this;
        int n = CoordinatesKt.chunkInsideRegion(x);
        int chunkZ$iv = CoordinatesKt.chunkInsideRegion(z);
        boolean $i$f$index = false;
        int index = (CoordinatesKt.chunkInsideRegion((int)chunkX$iv) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ$iv) & 0x1F) * 32;
        if (this.columnCache.containsKey(index)) {
            ChunkColumn chunkColumn = this.columnCache.get(index);
            Intrinsics.checkNotNull(chunkColumn);
            ChunkColumn this_$iv2 = chunkColumn;
            return this_$iv2;
        }
        ChunkColumn column = new ChunkColumn(x, z, this.minY, this.maxY);
        Map map2 = this.columnCache;
        Integer n2 = index;
        boolean bl = false;
        map2.put(n2, column);
        return column;
    }

    /*
     * WARNING - void declaration
     */
    private final NBTCompound readColumnData(int x, int z) throws AnvilException, IOException {
        CompressedProcesser<InputStream, OutputStream> compressedProcesser;
        void location$iv$iv;
        RegionFile this_$iv = this;
        boolean $i$f$fileOffset = false;
        RegionFile regionFile = this_$iv;
        RegionFile this_$iv$iv22 = this_$iv;
        boolean $i$f$index = false;
        int this_$iv$iv22 = this_$iv.locations[(CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32];
        byte $i$f$sectorOffset = 0;
        void offset = (location$iv$iv >>> 8) * 4096;
        int length = this.readInt((long)offset);
        byte compressionType = this.readByte((long)offset + 4L);
        byte[] rawData = new byte[length - 1];
        this.readBytes((long)offset + 5L, rawData);
        $i$f$sectorOffset = compressionType;
        if ($i$f$sectorOffset == 1) {
            compressedProcesser = CompressedProcesser.GZIP;
        } else if ($i$f$sectorOffset == 2) {
            compressedProcesser = CompressedProcesser.ZLIB;
        } else if ($i$f$sectorOffset == 3) {
            compressedProcesser = CompressedProcesser.NONE;
        } else {
            throw new AnvilException("Invalid compression type: " + compressionType + " (only 1 and 2 known)");
        }
        NBTReader reader = new NBTReader(rawData, compressedProcesser);
        NBT chunkData = reader.read();
        reader.close();
        if (!(chunkData instanceof NBTCompound)) {
            throw new AnvilException("Chunk root tag must be TAG_Compound");
        }
        return (NBTCompound)chunkData;
    }

    private final ChunkColumn readColumn(int x, int z) throws AnvilException, IOException {
        return new ChunkColumn(this.readColumnData(x, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void writeColumnData(@NotNull NBTCompound data2, int x, int z) throws IOException {
        void location$iv;
        void location$iv22;
        boolean bl;
        Intrinsics.checkNotNullParameter(data2, "data");
        RegionFile this_$iv = this;
        boolean $i$f$out22 = false;
        if (CoordinatesKt.chunkToRegion(x) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z) != this_$iv.getRegionZ()) {
            throw new AnvilException("Out of RegionFile: " + x + ',' + z + " (chunk)");
        }
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        Closeable $i$f$out22 = new NBTWriter(dataOut, (CompressedProcesser)CompressedProcesser.ZLIB);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            Object it = (NBTWriter)$i$f$out22;
            bl = false;
            ((NBTWriter)it).writeNamed("", data2);
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally($i$f$out22, throwable);
        }
        int dataSize = dataOut.size();
        double d = (double)(dataSize + 5) / (double)4096;
        bl = false;
        int sectorCount = (int)Math.ceil(d);
        if (sectorCount >= 256) {
            throw new AnvilException("Sorry, but your ChunkColumn totals over 1MB of data, impossible to save it inside a RegionFile.");
        }
        RegionFile this_$iv2 = this;
        boolean $i$f$index22 = false;
        int location = (CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32;
        RegionFile $i$f$index22 = this;
        RegionFile this_$iv222 = this;
        boolean $i$f$index = false;
        int this_$iv222 = this.locations[(CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32];
        boolean $i$f$sizeInSectors = false;
        int previousSectorCount = location$iv22 & 0xFF;
        RegionFile location$iv22 = this;
        RegionFile this_$iv32 = this;
        boolean $i$f$index3 = false;
        int this_$iv32 = this.locations[(CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32];
        boolean $i$f$sectorOffset = false;
        void previousSectorStart = location$iv >>> 8;
        boolean appendToEnd = false;
        long position = 0L;
        int sectorStart = 0;
        DataSource dataSource = this.dataSource;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (dataSource) {
            int i;
            int n;
            Object object;
            boolean bl6 = false;
            sectorStart = this.findAvailableSectors(sectorCount);
            if (sectorStart == -1) {
                long eof;
                position = eof = this.getDataSource().length();
                sectorStart = (int)(eof / (long)4096);
                int n2 = 0;
                if (n2 < sectorCount) {
                    do {
                        int i2 = n2++;
                        int n3 = 0;
                        object = new byte[4096];
                        long l = eof + (long)(i2 * 4096);
                        RegionFile regionFile = this;
                        while (n3 < 4096) {
                            n = n3++;
                            object[n] = false;
                        }
                        regionFile.writeBytes(l, (byte[])object);
                    } while (n2 < sectorCount);
                }
                appendToEnd = true;
            } else {
                position = sectorStart * 4096;
            }
            int n4 = sectorStart;
            int n5 = sectorStart + sectorCount;
            if (n4 < n5) {
                do {
                    if ((i = n4++) < this.freeSectors.size()) {
                        this.freeSectors.set(i, false);
                        continue;
                    }
                    RegionFile regionFile = this;
                    Collection collection = regionFile.freeSectors;
                    object = false;
                    n = 0;
                    collection.add(object);
                } while (n4 < n5);
            }
            this.writeInt(position, dataSize);
            this.writeByte(position + (long)4, (byte)2);
            long l = position + (long)5;
            Object object2 = dataOut.toByteArray();
            Intrinsics.checkNotNullExpressionValue(object2, "dataOut.toByteArray()");
            this.writeBytes(l, (byte[])object2);
            if (appendToEnd) {
                this.addPadding();
            }
            object2 = this;
            int start$iv = sectorStart;
            boolean $i$f$buildLocation = false;
            this.locations[location] = (start$iv << 8 | sectorCount & 0xFF) & 0xFFFFFFFF;
            this.writeLocation(x, z);
            this.timestamps[location] = (int)System.currentTimeMillis();
            this.writeTimestamp(x, z);
            void var27_47 = previousSectorStart;
            n5 = previousSectorStart + previousSectorCount;
            if (var27_47 < n5) {
                do {
                    i = var27_47++;
                    this.freeSectors.set(i, true);
                } while (var27_47 < n5);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmOverloads
    public final void writeColumn(@NotNull ChunkColumn column, @NotNull SupportedVersion version2) throws IOException {
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        if (column.getMinY() < this.minY) {
            throw new AnvilException("ChunkColumn minY must be >= to RegionFile minY");
        }
        if (column.getMaxY() > this.maxY) {
            throw new AnvilException("ChunkColumn maxY must be <= to RegionFile maxY");
        }
        NBTCompound nbt = column.toNBT(version2);
        this.writeColumnData(nbt, column.getX(), column.getZ());
    }

    public static /* synthetic */ void writeColumn$default(RegionFile regionFile, ChunkColumn chunkColumn, SupportedVersion supportedVersion, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        regionFile.writeColumn(chunkColumn, supportedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addPadding() {
        DataSource dataSource = this.dataSource;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (dataSource) {
            boolean bl3 = false;
            long missingPadding = this.getDataSource().length() % (long)4096;
            if (missingPadding > 0L) {
                this.getDataSource().setLength(this.getDataSource().length() + ((long)4096 - missingPadding));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void writeLocation(int x, int z) {
        RegionFile this_$iv = this;
        boolean $i$f$index = false;
        this_$iv = this;
        $i$f$index = false;
        this.writeInt((long)((CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32) * 4L, this.locations[(CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32]);
    }

    private final void writeByte(long pos, byte b) {
        this.dataSource.writeByte(pos, b);
    }

    private final void writeBytes(long pos, byte[] bytes) {
        this.dataSource.writeBytes(pos, bytes);
    }

    private final void writeInt(long pos, int n) {
        this.dataSource.writeInt(pos, n);
    }

    private final void readBytes(long pos, byte[] destination) {
        this.dataSource.readBytes(pos, destination);
    }

    private final byte readByte(long pos) {
        return this.dataSource.readByte(pos);
    }

    private final int readInt(long pos) {
        return this.dataSource.readInt(pos);
    }

    private final void writeTimestamp(int x, int z) {
        RegionFile this_$iv = this;
        boolean $i$f$index = false;
        this_$iv = this;
        $i$f$index = false;
        this.writeInt((long)((CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32) * 4L + (long)4096, this.timestamps[(CoordinatesKt.chunkInsideRegion(x) & 0x1F) + (CoordinatesKt.chunkInsideRegion(z) & 0x1F) * 32]);
    }

    private final int findAvailableSectors(int sectorCount) {
        int n = 0;
        int n2 = this.freeSectors.size() - sectorCount;
        if (n < n2) {
            do {
                int start = n++;
                boolean found = true;
                int n3 = 0;
                if (n3 < sectorCount) {
                    do {
                        int i;
                        if (this.freeSectors.get((i = n3++) + start).booleanValue()) continue;
                        found = false;
                        break;
                    } while (n3 < sectorCount);
                }
                if (!found) continue;
                return start;
            } while (n < n2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasChunk(int x, int z) throws AnvilException {
        void chunkX$iv;
        RegionFile this_$iv = this;
        int $i$f$out = 0;
        if (CoordinatesKt.chunkToRegion(x) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z) != this_$iv.getRegionZ()) {
            throw new AnvilException("Out of RegionFile: " + x + ',' + z + " (chunk)");
        }
        this_$iv = this;
        $i$f$out = CoordinatesKt.chunkInsideRegion(x);
        int chunkZ$iv = CoordinatesKt.chunkInsideRegion(z);
        boolean $i$f$index = false;
        return this.locations[(CoordinatesKt.chunkInsideRegion((int)chunkX$iv) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ$iv) & 0x1F) * 32] != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasLoadedChunk(int x, int z) throws AnvilException {
        void chunkX$iv;
        if (this.hasChunk(x, z)) {
            return true;
        }
        RegionFile regionFile = this;
        int n = CoordinatesKt.chunkInsideRegion(x);
        int chunkZ$iv = CoordinatesKt.chunkInsideRegion(z);
        boolean $i$f$index = false;
        return this.columnCache.containsKey((CoordinatesKt.chunkInsideRegion((int)chunkX$iv) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ$iv) & 0x1F) * 32);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBlockState(int x, int y, int z, @NotNull BlockState blockState) throws AnvilException, IllegalArgumentException {
        void this_$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        RegionFile regionFile = this;
        int n = CoordinatesKt.blockToChunk(x);
        int z$iv = CoordinatesKt.blockToChunk(z);
        boolean $i$f$out = false;
        if (CoordinatesKt.chunkToRegion((int)x$iv) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z$iv) != this_$iv.getRegionZ()) {
            throw new IllegalArgumentException("Out of region " + x + ';' + z + " (block)");
        }
        if (!(0 <= y ? y <= 255 : false)) {
            throw new IllegalArgumentException("y (" + y + ") must be in 0..255");
        }
        ChunkColumn chunk = this.getOrCreateChunk(CoordinatesKt.blockToChunk(x), CoordinatesKt.blockToChunk(z));
        chunk.setBlockState(CoordinatesKt.blockInsideChunk(x), y, CoordinatesKt.blockInsideChunk(z), blockState);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BlockState getBlockState(int x, int y, int z) throws AnvilException, IllegalArgumentException {
        void this_$iv;
        void x$iv;
        RegionFile regionFile = this;
        int n = CoordinatesKt.blockToChunk(x);
        int z$iv = CoordinatesKt.blockToChunk(z);
        boolean $i$f$out = false;
        if (CoordinatesKt.chunkToRegion((int)x$iv) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z$iv) != this_$iv.getRegionZ()) {
            throw new IllegalArgumentException("Out of region " + x + ';' + z + " (block)");
        }
        if (!(0 <= y ? y <= 255 : false)) {
            throw new IllegalArgumentException("y (" + y + ") must be in 0..255");
        }
        ChunkColumn chunkColumn = this.getChunk(CoordinatesKt.blockToChunk(x), CoordinatesKt.blockToChunk(z));
        if (chunkColumn == null) {
            throw new AnvilException("No chunk at " + x + ',' + y + ',' + z);
        }
        ChunkColumn chunk = chunkColumn;
        return chunk.getBlockState(CoordinatesKt.blockInsideChunk(x), y, CoordinatesKt.blockInsideChunk(z));
    }

    /*
     * WARNING - void declaration
     */
    public final void setBiome(int x, int y, int z, @NotNull String biomeID) throws AnvilException, IllegalArgumentException {
        void this_$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter(biomeID, "biomeID");
        RegionFile regionFile = this;
        int n = CoordinatesKt.blockToChunk(x);
        int z$iv = CoordinatesKt.blockToChunk(z);
        boolean $i$f$out = false;
        if (CoordinatesKt.chunkToRegion((int)x$iv) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z$iv) != this_$iv.getRegionZ()) {
            throw new IllegalArgumentException("Out of region " + x + ';' + z + " (block)");
        }
        if (!(0 <= y ? y <= 255 : false)) {
            throw new IllegalArgumentException("y (" + y + ") must be in 0..255");
        }
        ChunkColumn chunk = this.getOrCreateChunk(CoordinatesKt.blockToChunk(x), CoordinatesKt.blockToChunk(z));
        chunk.setBiome(CoordinatesKt.blockInsideChunk(x), y, CoordinatesKt.blockInsideChunk(z), biomeID);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getBiome(int x, int y, int z) throws AnvilException, IllegalArgumentException {
        void this_$iv;
        void x$iv;
        RegionFile regionFile = this;
        int n = CoordinatesKt.blockToChunk(x);
        int z$iv = CoordinatesKt.blockToChunk(z);
        boolean $i$f$out = false;
        if (CoordinatesKt.chunkToRegion((int)x$iv) != this_$iv.getRegionX() || CoordinatesKt.chunkToRegion(z$iv) != this_$iv.getRegionZ()) {
            throw new IllegalArgumentException("Out of region " + x + ';' + z + " (block)");
        }
        if (!(0 <= y ? y <= 255 : false)) {
            throw new IllegalArgumentException("y (" + y + ") must be in 0..255");
        }
        ChunkColumn chunkColumn = this.getChunk(CoordinatesKt.blockToChunk(x), CoordinatesKt.blockToChunk(z));
        if (chunkColumn == null) {
            throw new AnvilException("No chunk at " + x + ',' + y + ',' + z);
        }
        ChunkColumn chunk = chunkColumn;
        return chunk.getBiome(CoordinatesKt.blockInsideChunk(x), y, CoordinatesKt.blockInsideChunk(z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushCachedChunks() throws IOException {
        ConcurrentHashMap<Integer, ChunkColumn> concurrentHashMap = this.columnCache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashMap) {
            boolean bl3 = false;
            this.columnCache.values().parallelStream().forEach(arg_0 -> RegionFile.flushCachedChunks$lambda-8$lambda-7(this, arg_0));
            this.columnCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean out(int x, int z) {
        boolean $i$f$out = false;
        return CoordinatesKt.chunkToRegion(x) != this.getRegionX() || CoordinatesKt.chunkToRegion(z) != this.getRegionZ();
    }

    private final int sizeInSectors(int location) {
        boolean $i$f$sizeInSectors = false;
        return location & 0xFF;
    }

    private final int sectorOffset(int location) {
        boolean $i$f$sectorOffset = false;
        return location >>> 8;
    }

    private final int index(int chunkX, int chunkZ) {
        boolean $i$f$index = false;
        return (CoordinatesKt.chunkInsideRegion(chunkX) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ) & 0x1F) * 32;
    }

    /*
     * WARNING - void declaration
     */
    private final int fileOffset(int chunkX, int chunkZ) {
        void location$iv;
        boolean $i$f$fileOffset = false;
        RegionFile regionFile = this;
        RegionFile this_$iv22 = this;
        boolean $i$f$index = false;
        int this_$iv22 = this.locations[(CoordinatesKt.chunkInsideRegion(chunkX) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ) & 0x1F) * 32];
        boolean $i$f$sectorOffset = false;
        return (int)((location$iv >>> 8) * 4096);
    }

    private final int buildLocation(int start, int length) {
        boolean $i$f$buildLocation = false;
        return (start << 8 | length & 0xFF) & 0xFFFFFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ConcurrentHashMap<Integer, ChunkColumn> concurrentHashMap = this.columnCache;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashMap) {
            boolean bl3 = false;
            this.columnCache.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.dataSource.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void forget(@NotNull ChunkColumn column) {
        void chunkX$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        RegionFile regionFile = this;
        int n = column.getX();
        int chunkZ$iv = column.getZ();
        boolean $i$f$index = false;
        int index = (CoordinatesKt.chunkInsideRegion((int)chunkX$iv) & 0x1F) + (CoordinatesKt.chunkInsideRegion(chunkZ$iv) & 0x1F) * 32;
        if (!Intrinsics.areEqual(this.columnCache.get(index), column)) {
            throw new IllegalArgumentException("Tried to remove column that is not inside the region");
        }
        this.columnCache.remove(index);
    }

    @JvmOverloads
    public RegionFile(@NotNull DataSource dataSource, int regionX, int regionZ, int minY) throws AnvilException, IOException {
        Intrinsics.checkNotNullParameter(dataSource, "dataSource");
        this(dataSource, regionX, regionZ, minY, 0, 16, null);
    }

    @JvmOverloads
    public RegionFile(@NotNull DataSource dataSource, int regionX, int regionZ) throws AnvilException, IOException {
        Intrinsics.checkNotNullParameter(dataSource, "dataSource");
        this(dataSource, regionX, regionZ, 0, 0, 24, null);
    }

    @JvmOverloads
    public RegionFile(@NotNull RandomAccessFile file, int regionX, int regionZ, int minY) throws AnvilException, IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        this(file, regionX, regionZ, minY, 0, 16, null);
    }

    @JvmOverloads
    public RegionFile(@NotNull RandomAccessFile file, int regionX, int regionZ) throws AnvilException, IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        this(file, regionX, regionZ, 0, 0, 24, null);
    }

    @JvmOverloads
    public final void writeColumn(@NotNull ChunkColumn column) throws IOException {
        Intrinsics.checkNotNullParameter(column, "column");
        RegionFile.writeColumn$default(this, column, null, 2, null);
    }

    private static final ChunkColumn getChunk$lambda-3(RegionFile this$0, int $x, int $z, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.readColumn(CoordinatesKt.chunkInsideRegion($x), CoordinatesKt.chunkInsideRegion($z));
    }

    private static final void flushCachedChunks$lambda-8$lambda-7(RegionFile this$0, ChunkColumn it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(it, "it");
        RegionFile.writeColumn$default(this$0, it, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jglrxavpok/hephaistos/mca/RegionFile$Companion;", "", "()V", "ChunkHeaderLength", "", "GZipCompression", "", "HeaderLength", "MaxEntryCount", "NoCompression", "Sector1MB", "SectorSize", "ZlibCompression", "createFileName", "", "regionX", "regionZ", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createFileName(int regionX, int regionZ) {
            return "r." + regionX + '.' + regionZ + ".mca";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

