/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.LongCompactorKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B3\b\u0004\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\tJ/\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J\u0013\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u0010#J\u0006\u0010(\u001a\u00020)J\u001d\u0010*\u001a\u00020!2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0000\u00a2\u0006\u0004\b+\u0010,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.R\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\fj\b\u0012\u0004\u0012\u00028\u0000`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002/0\u00a8\u00061"}, d2={"Lorg/jglrxavpok/hephaistos/mca/Palette;", "ElementType", "", "nbtType", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "defaultValue", "writer", "Lkotlin/Function1;", "(Lorg/jglrxavpok/hephaistos/nbt/NBTType;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Object;", "elements", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getElements", "()Ljava/util/ArrayList;", "referenceCounts", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "getReferenceCounts$common", "()Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "compactIDs", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "states", "", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "minimumBitSize", "", "([Ljava/lang/Object;Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;I)Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "compactPreProcessedIDs", "indices", "", "decreaseReference", "", "block", "(Ljava/lang/Object;)V", "getPaletteIndex", "obj", "(Ljava/lang/Object;)I", "increaseReference", "isEmpty", "", "loadReferences", "loadReferences$common", "([Ljava/lang/Object;)V", "toNBT", "Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "Lorg/jglrxavpok/hephaistos/mca/BlockPalette;", "Lorg/jglrxavpok/hephaistos/mca/BiomePalette;", "common"})
public abstract class Palette<ElementType> {
    @NotNull
    private final NBTType<? extends NBT> nbtType;
    private final ElementType defaultValue;
    @NotNull
    private final Function1<ElementType, NBT> writer;
    @NotNull
    private final ArrayList<ElementType> elements;
    @NotNull
    private final Object2IntOpenHashMap<ElementType> referenceCounts;

    private Palette(NBTType<? extends NBT> nbtType, ElementType defaultValue, Function1<? super ElementType, ? extends NBT> writer) {
        this.nbtType = nbtType;
        this.defaultValue = defaultValue;
        this.writer = writer;
        boolean bl = false;
        this.elements = new ArrayList();
        this.referenceCounts = new Object2IntOpenHashMap();
    }

    @NotNull
    public final ArrayList<ElementType> getElements() {
        return this.elements;
    }

    @NotNull
    public final Object2IntOpenHashMap<ElementType> getReferenceCounts$common() {
        return this.referenceCounts;
    }

    public final void loadReferences$common(@NotNull ElementType[] states) {
        Intrinsics.checkNotNullParameter(states, "states");
        boolean bl = false;
        Set visited = new LinkedHashSet();
        for (ElementType element : states) {
            if (visited.contains(element)) continue;
            if (!this.elements.contains(element)) {
                throw new IllegalArgumentException("Tried to add a reference counter to " + element + " which is not in this palette");
            }
            visited.add(element);
        }
        for (ElementType state : states) {
            this.referenceCounts.addTo(state, 1);
        }
    }

    public final void increaseReference(ElementType block) {
        if (this.referenceCounts.addTo(block, 1) == 0) {
            this.elements.add(block);
        }
    }

    public final void decreaseReference(ElementType block) {
        if (!this.referenceCounts.containsKey(block)) {
            throw new IllegalArgumentException("Tried to remove a reference counter to " + block + " which is not in this palette");
        }
        int old = this.referenceCounts.addTo(block, -1);
        if (old - 1 <= 0) {
            this.elements.remove(block);
            this.referenceCounts.removeInt(block);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NBTList<NBT> toNBT() {
        Collection<NBT> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.elements;
        NBTType<? extends NBT> nBTType = this.nbtType;
        NBT.Companion companion = NBT.Companion;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            NBT nBT = this.writer.invoke(it);
            collection.add(nBT);
        }
        collection = (List)destination$iv$iv;
        return companion.List(nBTType, collection);
    }

    public final int getPaletteIndex(ElementType obj) {
        return this.elements.indexOf(obj);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactPreProcessedIDs(@NotNull int[] indices, @NotNull SupportedVersion version2, int minimumBitSize) {
        ImmutableLongArray immutableLongArray;
        Intrinsics.checkNotNullParameter(indices, "indices");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        boolean bl = minimumBitSize > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Minimum bit size cannot be 0 or negative";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        float f = MathKt.log2(this.elements.size());
        bl3 = false;
        int bitLength = RangesKt.coerceAtLeast((int)Math.ceil(f), minimumBitSize);
        if (version2 == SupportedVersion.MC_1_15) {
            immutableLongArray = LongCompactorKt.compress(indices, bitLength);
        } else if (version2.compareTo((Enum)SupportedVersion.MC_1_16) >= 0) {
            immutableLongArray = LongCompactorKt.pack(indices, bitLength);
        } else {
            throw new AnvilException(Intrinsics.stringPlus("Unsupported version for compacting palette: ", (Object)version2));
        }
        return immutableLongArray;
    }

    public static /* synthetic */ ImmutableLongArray compactPreProcessedIDs$default(Palette palette, int[] nArray, SupportedVersion supportedVersion, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compactPreProcessedIDs");
        }
        if ((n2 & 2) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return palette.compactPreProcessedIDs(nArray, supportedVersion, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactIDs(@NotNull ElementType[] states, @NotNull SupportedVersion version2, int minimumBitSize) {
        ImmutableLongArray immutableLongArray;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(states, "states");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        boolean bl = minimumBitSize > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Minimum bit size cannot be 0 or negative";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ElementType[] ElementTypeArray = states;
        ArrayList<ElementType> arrayList = this.elements;
        boolean $i$f$map = false;
        void var8_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var11_18 = $this$mapTo$iv$iv;
        int n = ((void)var11_18).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var15_22 = item$iv$iv = var11_18[i];
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Integer n2 = arrayList.indexOf(p0);
            collection.add(n2);
        }
        int[] indices = CollectionsKt.toIntArray((List)destination$iv$iv);
        float f = MathKt.log2(this.elements.size());
        boolean bl6 = false;
        int bitLength = RangesKt.coerceAtLeast((int)Math.ceil(f), minimumBitSize);
        if (version2 == SupportedVersion.MC_1_15) {
            immutableLongArray = LongCompactorKt.compress(indices, bitLength);
        } else if (version2.compareTo((Enum)SupportedVersion.MC_1_16) >= 0) {
            immutableLongArray = LongCompactorKt.pack(indices, bitLength);
        } else {
            throw new AnvilException(Intrinsics.stringPlus("Unsupported version for compacting palette: ", (Object)version2));
        }
        return immutableLongArray;
    }

    public static /* synthetic */ ImmutableLongArray compactIDs$default(Palette palette, Object[] objectArray, SupportedVersion supportedVersion, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compactIDs");
        }
        if ((n2 & 2) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return palette.compactIDs(objectArray, supportedVersion, n);
    }

    public final boolean isEmpty() {
        return this.elements.size() == 1 && Intrinsics.areEqual(this.elements.get(0), this.defaultValue);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactPreProcessedIDs(@NotNull int[] indices, @NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        return Palette.compactPreProcessedIDs$default(this, indices, version2, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactPreProcessedIDs(@NotNull int[] indices) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        return Palette.compactPreProcessedIDs$default(this, indices, null, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactIDs(@NotNull ElementType[] states, @NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter(states, "states");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        return Palette.compactIDs$default(this, states, version2, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compactIDs(@NotNull ElementType[] states) {
        Intrinsics.checkNotNullParameter(states, "states");
        return Palette.compactIDs$default(this, states, null, 0, 6, null);
    }

    public /* synthetic */ Palette(NBTType nbtType, Object defaultValue, Function1 writer, DefaultConstructorMarker $constructor_marker) {
        this(nbtType, defaultValue, writer);
    }
}

