/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"compress", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "data", "", "lengthInBits", "", "decompress", "pack", "ints", "unpack", "longs", "common"})
public final class LongCompactorKt {
    @NotNull
    public static final ImmutableLongArray compress(@NotNull int[] data2, int lengthInBits) {
        Intrinsics.checkNotNullParameter(data2, "data");
        double d = (double)(data2.length * lengthInBits) / 64.0;
        boolean bl = false;
        long[] compacted = new long[(int)Math.ceil(d)];
        int bitIndex = 0;
        long maxMask = (1L << lengthInBits) - 1L;
        int n = 0;
        int n2 = data2.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                int value = data2[i] & 0x1FF;
                int beginLongIndex = bitIndex / 64;
                int endLongIndex = (bitIndex + lengthInBits - 1) / 64;
                if (beginLongIndex != endLongIndex) {
                    int overshoot = (bitIndex + lengthInBits) % 64;
                    int highMask = (1 << overshoot) - 1;
                    long mask = (1 << lengthInBits - overshoot) - 1;
                    compacted[beginLongIndex] = compacted[beginLongIndex] & (maxMask << bitIndex % 64 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << bitIndex % 64;
                    compacted[endLongIndex] = compacted[endLongIndex] | ((long)value & maxMask) >> 64 - bitIndex % 64 & (long)highMask;
                } else {
                    compacted[beginLongIndex] = compacted[beginLongIndex] & (maxMask << bitIndex % 64 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & maxMask) << bitIndex % 64;
                }
                bitIndex += lengthInBits;
            } while (n <= n2);
        }
        return new ImmutableLongArray(Arrays.copyOf(compacted, compacted.length));
    }

    @NotNull
    public static final int[] decompress(@NotNull ImmutableLongArray data2, int lengthInBits) {
        Intrinsics.checkNotNullParameter(data2, "data");
        int bitIndex = 0;
        int count2 = (int)((long)data2.getSize() * (long)64 / (long)lengthInBits);
        int[] result2 = new int[count2];
        long maxMask = (1L << lengthInBits) - 1L;
        int n = 0;
        int n2 = result2.length + -1;
        if (n <= n2) {
            do {
                int value;
                int n3;
                int i = n++;
                int beginLongIndex = bitIndex / 64;
                int endLongIndex = (bitIndex + lengthInBits - 1) / 64;
                if (beginLongIndex != endLongIndex) {
                    int overshoot = (bitIndex + lengthInBits) % 64;
                    long lowMask = (1L << lengthInBits - overshoot) - 1L;
                    long highMask = (1L << overshoot) - 1L;
                    long low = data2.get(beginLongIndex) >> bitIndex % 64 & lowMask;
                    long high = data2.get(endLongIndex) & highMask;
                    n3 = (int)(low | high << lengthInBits - overshoot);
                } else {
                    n3 = (int)(data2.get(beginLongIndex) >> bitIndex % 64 & maxMask);
                }
                result2[bitIndex / lengthInBits] = value = n3;
                bitIndex += lengthInBits;
            } while (n <= n2);
        }
        return result2;
    }

    @NotNull
    public static final int[] unpack(@NotNull ImmutableLongArray longs, int lengthInBits) {
        Intrinsics.checkNotNullParameter(longs, "longs");
        double d = 64.0 / (double)lengthInBits;
        boolean bl = false;
        double intPerLong = Math.floor(d);
        double d2 = (double)longs.getSize() * intPerLong;
        boolean bl2 = false;
        int intCount = (int)Math.ceil(d2);
        int[] ints = new int[intCount];
        bl2 = false;
        int intPerLongCeil = (int)Math.ceil(intPerLong);
        long mask = (long)(1 << lengthInBits) - 1L;
        int n = 0;
        int n2 = ints.length + -1;
        if (n <= n2) {
            do {
                int value;
                int i = n++;
                int longIndex = i / intPerLongCeil;
                int subIndex = i % intPerLongCeil;
                ints[i] = value = (int)(longs.get(longIndex) >> subIndex * lengthInBits & mask);
            } while (n <= n2);
        }
        return ints;
    }

    @NotNull
    public static final ImmutableLongArray pack(@NotNull int[] ints, int lengthInBits) {
        Intrinsics.checkNotNullParameter(ints, "ints");
        double d = 64.0 / (double)lengthInBits;
        boolean bl = false;
        int intPerLong = (int)Math.floor(d);
        double d2 = (double)ints.length / (double)intPerLong;
        boolean bl2 = false;
        int longCount = (int)Math.ceil(d2);
        long[] longs = new long[longCount];
        long mask = (long)(1 << lengthInBits) - 1L;
        int n = 0;
        int n2 = longs.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                long l = 0L;
                int n3 = 0;
                if (n3 < intPerLong) {
                    do {
                        int intIndex = n3++;
                        int bitIndex = intIndex * lengthInBits;
                        int intActualIndex = intIndex + i * intPerLong;
                        if (intActualIndex >= ints.length) continue;
                        long value = ((long)ints[intActualIndex] & mask) << bitIndex;
                        l |= value;
                    } while (n3 < intPerLong);
                }
                longs[i] = l;
            } while (n <= n2);
        }
        return new ImmutableLongArray(Arrays.copyOf(longs, longs.length));
    }
}

