/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.LongCompactorKt;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0012\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007J\u0019\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0086\u0002J!\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0086\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jglrxavpok/hephaistos/mca/Heightmap;", "", "compactVersion", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "(Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;)V", "()V", "heights", "", "checkBounds", "", "x", "", "z", "compact", "get", "set", "height", "common"})
public final class Heightmap {
    @NotNull
    private int[] heights;

    public Heightmap() {
        this.heights = new int[256];
    }

    @JvmOverloads
    public Heightmap(@NotNull ImmutableLongArray compactVersion, @NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter(compactVersion, "compactVersion");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        this();
        if (version2 == SupportedVersion.MC_1_15) {
            if (compactVersion.getSize() != 36) {
                throw new AnvilException("Wrong length for 1.15 compacted heightmap (found " + compactVersion.getSize() + ", expected 36)");
            }
            this.heights = LongCompactorKt.decompress(compactVersion, 9);
        } else if (version2.compareTo((Enum)SupportedVersion.MC_1_16) >= 0) {
            if (compactVersion.getSize() != 37) {
                throw new AnvilException("Wrong length for 1.16 compacted heightmap (found " + compactVersion.getSize() + ", expected 37)");
            }
            this.heights = LongCompactorKt.unpack(compactVersion, 9);
        }
    }

    public /* synthetic */ Heightmap(ImmutableLongArray immutableLongArray, SupportedVersion supportedVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        this(immutableLongArray, supportedVersion);
    }

    public final int get(int x, int z) {
        this.checkBounds(x, z);
        return this.heights[z * 16 + x];
    }

    public final void set(int x, int z, int height) {
        this.checkBounds(x, z);
        this.heights[z * 16 + x] = height;
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compact(@NotNull SupportedVersion version2) {
        ImmutableLongArray immutableLongArray;
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        if (version2 == SupportedVersion.MC_1_15) {
            immutableLongArray = LongCompactorKt.compress(this.heights, 9);
        } else if (version2.compareTo((Enum)SupportedVersion.MC_1_16) >= 0) {
            immutableLongArray = LongCompactorKt.pack(this.heights, 9);
        } else {
            throw new AnvilException(Intrinsics.stringPlus("Unsupported data version for heightmap: ", (Object)version2));
        }
        return immutableLongArray;
    }

    public static /* synthetic */ ImmutableLongArray compact$default(Heightmap heightmap, SupportedVersion supportedVersion, int n, Object object) {
        if ((n & 1) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        return heightmap.compact(supportedVersion);
    }

    private final void checkBounds(int x, int z) {
        if (!(0 <= x ? x <= 15 : false)) {
            throw new IllegalArgumentException("x must be in 0..15");
        }
        if (!(0 <= z ? z <= 15 : false)) {
            throw new IllegalArgumentException("z must be in 0..15");
        }
    }

    @JvmOverloads
    public Heightmap(@NotNull ImmutableLongArray compactVersion) {
        Intrinsics.checkNotNullParameter(compactVersion, "compactVersion");
        this(compactVersion, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ImmutableLongArray compact() {
        return Heightmap.compact$default(this, null, 1, null);
    }
}

