/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.Options;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.BlockPalette;
import org.jglrxavpok.hephaistos.mca.BlockState;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.ChunkSectionReader;
import org.jglrxavpok.hephaistos.mca.readers.SectionBiomeInformation;
import org.jglrxavpok.hephaistos.mca.writer.ChunkSectionWriter;
import org.jglrxavpok.hephaistos.mcdata.Biome;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\u0018\u0000 >2\u00020\u0001:\u0001>B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020(H\u0002J!\u0010-\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0086\u0002J\u001e\u0010.\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u001e\u0010/\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u001e\u00100\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u0006\u00101\u001a\u00020\u001fJ \u00102\u001a\u00020*2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0018\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001fH\u0002J)\u00106\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u00107\u001a\u00020\u001cH\u0086\u0002J&\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u00109\u001a\u00020\u000bJ&\u0010:\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010;\u001a\u00020\bJ&\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010;\u001a\u00020\bJ\u0012\u0010=\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006?"}, d2={"Lorg/jglrxavpok/hephaistos/mca/ChunkSection;", "", "nbt", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "(Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;)V", "y", "", "(B)V", "baseBiome", "", "biomes", "", "getBiomes", "()[Ljava/lang/String;", "setBiomes", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "blockLights", "", "getBlockLights", "()[B", "setBlockLights", "([B)V", "blockPalette", "Lorg/jglrxavpok/hephaistos/mca/BlockPalette;", "blockStates", "Lorg/jglrxavpok/hephaistos/mca/BlockState;", "[Lorg/jglrxavpok/hephaistos/mca/BlockState;", "empty", "", "getEmpty", "()Z", "skyLights", "getSkyLights", "setSkyLights", "getY", "()B", "checkBounds", "", "x", "", "z", "fillInIfEmpty", "get", "getBiome", "getBlockLight", "getSkyLight", "hasBiomeData", "index", "initializePalette", "palette", "isAir", "set", "block", "setBiome", "biomeID", "setBlockLight", "light", "setSkyLight", "toNBT", "Companion", "common"})
public final class ChunkSection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte y;
    @Nullable
    private BlockPalette blockPalette;
    @NotNull
    private final BlockState[] blockStates;
    @NotNull
    private byte[] blockLights;
    @NotNull
    private byte[] skyLights;
    @Nullable
    private String[] biomes;
    @NotNull
    private String baseBiome;
    private static final int BlockStateSize = 4096;
    private static final int BiomeArraySize = 64;

    public ChunkSection(byte y) {
        this.y = y;
        int n = 0;
        BlockState[] blockStateArray = new BlockState[4096];
        ChunkSection chunkSection = this;
        while (n < 4096) {
            int n2 = n++;
            blockStateArray[n2] = BlockState.AIR;
        }
        chunkSection.blockStates = blockStateArray;
        this.blockLights = new byte[0];
        this.skyLights = new byte[0];
        this.baseBiome = Biome.Companion.getUnknownBiome();
    }

    public final byte getY() {
        return this.y;
    }

    public final boolean getEmpty() {
        return this.blockPalette == null;
    }

    @NotNull
    public final byte[] getBlockLights() {
        return this.blockLights;
    }

    public final void setBlockLights(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.blockLights = byArray;
    }

    @NotNull
    public final byte[] getSkyLights() {
        return this.skyLights;
    }

    public final void setSkyLights(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.skyLights = byArray;
    }

    @Nullable
    public final String[] getBiomes() {
        return this.biomes;
    }

    public final void setBiomes(@Nullable String[] stringArray) {
        this.biomes = stringArray;
    }

    @JvmOverloads
    public ChunkSection(@NotNull NBTCompound nbt, @NotNull SupportedVersion version2) throws AnvilException {
        KMappedMarker nonAir2;
        KMappedMarker it2;
        int n;
        boolean bl;
        BlockPalette blockPalette;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        this(ChunkSectionReader.Companion.getY(nbt));
        if (version2.compareTo((Enum)SupportedVersion.MC_1_17_0) < 0) {
            byte by = this.y;
            if (!(0 <= by ? by <= 15 : false)) {
                throw new AnvilException("Invalid section Y: " + this.y + ". Must be in 0..15 for pre-1.17 sections");
            }
        }
        ChunkSectionReader reader = new ChunkSectionReader(version2, nbt);
        NBTList<NBTCompound> blockPaletteNBT = reader.getBlockPalette();
        ChunkSection chunkSection = this;
        NBTList<NBTCompound> nBTList = blockPaletteNBT;
        if (nBTList == null) {
            blockPalette = null;
        } else {
            NBTList<NBTCompound> nBTList2 = nBTList;
            bl = false;
            n = 0;
            NBTList<NBTCompound> nBTList3 = nBTList2;
            ChunkSection chunkSection2 = chunkSection;
            boolean bl2 = false;
            BlockPalette blockPalette2 = new BlockPalette((NBTList<NBTCompound>)it2);
            chunkSection = chunkSection2;
            blockPalette = blockPalette2;
        }
        chunkSection.blockPalette = blockPalette;
        if (Options.WarnWhenLoadingSectionWithNoPaletteButWithBlocks.getActive() && this.blockPalette == null && reader.hasBlockStates()) {
            System.err.println("[Hephaistos] Attempted to load a ChunkSection with no palette but with block states. Because Hephaistos cannot interpret global IDs, block states will be skipped");
        }
        if (this.blockPalette != null) {
            int[] ids = reader.getUncompressedBlockStateIDs();
            boolean nonAir2 = false;
            Object object = ids;
            int it2 = ((int[])object).length;
            for (n = 0; n < it2; ++n) {
                BlockState state;
                int index = n;
                int id2 = object[n];
                BlockPalette blockPalette3 = this.blockPalette;
                Intrinsics.checkNotNull(blockPalette3);
                Object ElementType2 = blockPalette3.getElements().get(id2);
                Intrinsics.checkNotNullExpressionValue(ElementType2, "blockPalette!!.elements[id]");
                this.blockStates[index] = state = (BlockState)ElementType2;
                if (Intrinsics.areEqual(state, BlockState.AIR)) continue;
                nonAir2 = true;
            }
            object = this.blockPalette;
            Intrinsics.checkNotNull(object);
            this.initializePalette((BlockPalette)object, !nonAir2);
        }
        if ((nBTList = reader.getBlockLight()) != null) {
            nonAir2 = nBTList;
            bl = false;
            n = 0;
            it2 = nonAir2;
            boolean bl3 = false;
            this.setBlockLights(new byte[((ImmutableByteArray)it2).getSize()]);
            ImmutableByteArray.copyInto$default((ImmutableByteArray)it2, this.getBlockLights(), 0, 0, 0, 14, null);
        }
        nBTList = reader.getSkyLight();
        if (nBTList != null) {
            nonAir2 = nBTList;
            bl = false;
            n = 0;
            it2 = nonAir2;
            boolean bl4 = false;
            this.setSkyLights(new byte[((ImmutableByteArray)it2).getSize()]);
            ImmutableByteArray.copyInto$default((ImmutableByteArray)it2, this.getSkyLights(), 0, 0, 0, 14, null);
        }
        nBTList = reader.getBiomeInformation();
        String[] biomesArray = ((SectionBiomeInformation)((Object)nBTList)).component1();
        String baseBiomeValue = ((SectionBiomeInformation)((Object)nBTList)).component2();
        this.biomes = biomesArray;
        String string = baseBiomeValue;
        this.baseBiome = string == null ? Biome.Companion.getUnknownBiome() : string;
    }

    public /* synthetic */ ChunkSection(NBTCompound nBTCompound, SupportedVersion supportedVersion, int n, DefaultConstructorMarker defaultConstructorMarker) throws AnvilException {
        if ((n & 2) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        this(nBTCompound, supportedVersion);
    }

    public final void set(int x, int y, int z, @NotNull BlockState block) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.checkBounds(x, y, z);
        if (this.blockPalette == null) {
            this.blockPalette = new BlockPalette();
            Object object = this.blockPalette;
            Intrinsics.checkNotNull(object);
            BlockPalette blockPalette = object;
            object = blockPalette.getElements();
            BlockState blockState = BlockState.AIR;
            boolean bl = false;
            object.add(blockState);
            blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            this.initializePalette(blockPalette, true);
            blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            blockPalette.increaseReference(block);
            blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            blockPalette.decreaseReference(BlockState.AIR);
            this.blockStates[this.index((int)x, (int)y, (int)z)] = block;
        } else {
            BlockState previous = this.get(x, y, z);
            BlockPalette blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            blockPalette.increaseReference(block);
            blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            blockPalette.decreaseReference(previous);
            this.blockStates[this.index((int)x, (int)y, (int)z)] = block;
        }
    }

    private final void checkBounds(int x, int y, int z) {
        if (!(0 <= x ? x <= 15 : false)) {
            throw new IllegalArgumentException("x (" + x + ") is not in 0..15");
        }
        if (!(0 <= y ? y <= 15 : false)) {
            throw new IllegalArgumentException("y (" + y + ") is not in 0..15");
        }
        if (!(0 <= z ? z <= 15 : false)) {
            throw new IllegalArgumentException("z (" + z + ") is not in 0..15");
        }
    }

    private final void initializePalette(BlockPalette palette, boolean isAir) {
        if (this.getEmpty() || isAir) {
            palette.getReferenceCounts$common().clear();
            Map map2 = palette.getReferenceCounts$common();
            BlockState blockState = BlockState.AIR;
            Integer n = 4096;
            boolean bl = false;
            map2.put(blockState, n);
        } else {
            palette.loadReferences$common(this.blockStates);
        }
    }

    public final byte getBlockLight(int x, int y, int z) throws AnvilException {
        byte by;
        if (this.getEmpty()) {
            throw new AnvilException("Trying to access empty section!");
        }
        this.checkBounds(x, y, z);
        int index = this.index(x, y, z);
        if (index % 2 == 0) {
            byte by2 = this.blockLights[index / 2];
            int n = 15;
            boolean bl = false;
            by = (byte)(by2 & n);
        } else {
            by = (byte)(this.blockLights[index / 2] >> 4 & 0xF);
        }
        return by;
    }

    public final byte getSkyLight(int x, int y, int z) throws AnvilException {
        byte by;
        if (this.getEmpty()) {
            throw new AnvilException("Trying to access empty section!");
        }
        this.checkBounds(x, y, z);
        int index = this.index(x, y, z);
        if (index % 2 == 0) {
            byte by2 = this.skyLights[index / 2];
            int n = 15;
            boolean bl = false;
            by = (byte)(by2 & n);
        } else {
            by = (byte)(this.skyLights[index / 2] >> 4 & 0xF);
        }
        return by;
    }

    public final void setSkyLight(int x, int y, int z, byte light) {
        int index;
        this.checkBounds(x, y, z);
        this.fillInIfEmpty();
        byte[] byArray = this.skyLights;
        byte by = 0;
        if (byArray.length == 0) {
            this.skyLights = new byte[2048];
        }
        if ((index = this.index(x, y, z)) % 2 == 0) {
            by = this.skyLights[index / 2];
            int n = -16;
            int n2 = 0;
            by = (byte)(by & n);
            n = light;
            n2 = 15;
            boolean bl = false;
            n = (byte)(n & n2);
            n2 = 0;
            this.skyLights[index / 2] = (byte)(by | n);
        } else {
            by = this.skyLights[index / 2];
            int n = 15;
            boolean bl = false;
            by = (byte)(by & n);
            n = (byte)(light << 4 & 0xF);
            bl = false;
            this.skyLights[index / 2] = (byte)(by | n);
        }
    }

    public final void setBlockLight(int x, int y, int z, byte light) {
        int index;
        this.checkBounds(x, y, z);
        this.fillInIfEmpty();
        byte[] byArray = this.blockLights;
        byte by = 0;
        if (byArray.length == 0) {
            this.blockLights = new byte[2048];
        }
        if ((index = this.index(x, y, z)) % 2 == 0) {
            by = this.blockLights[index / 2];
            int n = -16;
            int n2 = 0;
            by = (byte)(by & n);
            n = light;
            n2 = 15;
            boolean bl = false;
            n = (byte)(n & n2);
            n2 = 0;
            this.blockLights[index / 2] = (byte)(by | n);
        } else {
            by = this.blockLights[index / 2];
            int n = 15;
            boolean bl = false;
            by = (byte)(by & n);
            n = (byte)(light << 4 & 0xF);
            bl = false;
            this.blockLights[index / 2] = (byte)(by | n);
        }
    }

    private final void fillInIfEmpty() {
        if (this.getEmpty()) {
            this.blockPalette = new BlockPalette();
            Object object = this.blockPalette;
            Intrinsics.checkNotNull(object);
            BlockPalette blockPalette = object;
            object = blockPalette.getElements();
            BlockState blockState = BlockState.AIR;
            boolean bl = false;
            object.add(blockState);
            blockPalette = this.blockPalette;
            Intrinsics.checkNotNull(blockPalette);
            this.initializePalette(blockPalette, true);
        }
    }

    @NotNull
    public final BlockState get(int x, int y, int z) throws AnvilException {
        this.checkBounds(x, y, z);
        if (this.getEmpty()) {
            throw new AnvilException("Trying to access empty section!");
        }
        return this.blockStates[this.index(x, y, z)];
    }

    @NotNull
    public final String getBiome(int x, int y, int z) {
        this.checkBounds(x, y, z);
        if (this.biomes == null) {
            return this.baseBiome;
        }
        int index = x / 4 + z / 4 * 4 + y / 4 * 16;
        String[] stringArray = this.biomes;
        Intrinsics.checkNotNull(stringArray);
        return stringArray[index];
    }

    public final void setBiome(int x, int y, int z, @NotNull String biomeID) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter(biomeID, "biomeID");
        this.checkBounds(x, y, z);
        this.fillInIfEmpty();
        if (this.biomes == null) {
            int n = 0;
            int n2 = BiomeArraySize;
            String[] stringArray2 = new String[n2];
            ChunkSection chunkSection = this;
            while (n < n2) {
                int n3 = n++;
                stringArray2[n3] = Biome.Companion.getUnknownBiome();
            }
            chunkSection.biomes = stringArray2;
        }
        if ((stringArray = this.biomes) != null) {
            stringArray[x / 4 + z / 4 * 4 + y / 4 * 16] = biomeID;
        }
    }

    public final boolean hasBiomeData() {
        return this.biomes != null;
    }

    private final int index(int x, int y, int z) {
        return y * 16 * 16 + z * 16 + x;
    }

    @JvmOverloads
    @NotNull
    public final NBTCompound toNBT(@NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        ChunkSectionWriter chunkSectionWriter = new ChunkSectionWriter(version2, this.y);
        boolean bl = false;
        boolean bl2 = false;
        ChunkSectionWriter $this$toNBT_u24lambda_u2d3 = chunkSectionWriter;
        boolean bl3 = false;
        if (this.getBiomes() != null) {
            String[] stringArray = this.getBiomes();
            Intrinsics.checkNotNull(stringArray);
            $this$toNBT_u24lambda_u2d3.setAllBiomes(stringArray);
        }
        $this$toNBT_u24lambda_u2d3.setBlockLights(this.getBlockLights());
        $this$toNBT_u24lambda_u2d3.setSkyLights(this.getSkyLights());
        $this$toNBT_u24lambda_u2d3.setAllBlockStates(this.blockStates);
        return chunkSectionWriter.toNBT();
    }

    public static /* synthetic */ NBTCompound toNBT$default(ChunkSection chunkSection, SupportedVersion supportedVersion, int n, Object object) {
        if ((n & 1) != 0) {
            supportedVersion = SupportedVersion.Companion.getLatest();
        }
        return chunkSection.toNBT(supportedVersion);
    }

    @JvmOverloads
    public ChunkSection(@NotNull NBTCompound nbt) throws AnvilException {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this(nbt, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final NBTCompound toNBT() {
        return ChunkSection.toNBT$default(this, null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jglrxavpok/hephaistos/mca/ChunkSection$Companion;", "", "()V", "BiomeArraySize", "", "getBiomeArraySize", "()I", "BlockStateSize", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getBiomeArraySize() {
            return BiomeArraySize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

