/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.mca;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.collections.ImmutableIntArray;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.BlockState;
import org.jglrxavpok.hephaistos.mca.ChunkColumn;
import org.jglrxavpok.hephaistos.mca.ChunkSection;
import org.jglrxavpok.hephaistos.mca.CoordinatesKt;
import org.jglrxavpok.hephaistos.mca.Heightmap;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.ChunkReader;
import org.jglrxavpok.hephaistos.mca.writer.ChunkWriter;
import org.jglrxavpok.hephaistos.mcdata.Biome;
import org.jglrxavpok.hephaistos.mcdata.SizesKt;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTShort;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u008e\u0001B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B#\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010}\u001a\u00020~2\u0006\u0010o\u001a\u00020pJ!\u0010\u007f\u001a\u00020~2\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J!\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J!\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0011\u0010\u0085\u0001\u001a\u00020^2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J*\u0010\u0088\u0001\u001a\u00020~2\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0089\u0001\u001a\u00030\u0082\u0001J*\u0010\u008a\u0001\u001a\u00020~2\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0080\u0001\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u008b\u0001\u001a\u00030\u0084\u0001J\u0017\u0010\u008c\u0001\u001a\u00020~2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u0013\u0010\u008d\u0001\u001a\u00020\t2\b\b\u0002\u0010o\u001a\u00020pH\u0007R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0016\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R(\u00106\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001c\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001e\"\u0004\b9\u0010 R\u001c\u0010:\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0011\"\u0004\b<\u0010\u0013R \u0010=\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001e\"\u0004\b?\u0010 R2\u0010@\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001c\u0018\u00010\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bA\u0010B\u001a\u0004\bC\u0010\u001e\"\u0004\bD\u0010 R\u0011\u0010E\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0016R\u001e\u0010\u0006\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0016R\u001e\u0010\u0005\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0016R\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010M\"\u0004\bR\u0010OR\u001c\u0010S\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010M\"\u0004\bU\u0010OR\u001c\u0010V\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010M\"\u0004\bX\u0010OR(\u0010Y\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001c\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u001e\"\u0004\b[\u0010 R\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u001c\u0010a\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010\rR \u0010e\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010\u001e\"\u0004\bg\u0010 R \u0010h\u001a\b\u0012\u0004\u0012\u00020\t0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010\u001e\"\u0004\bj\u0010 R2\u0010k\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u001c\u0018\u00010\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bl\u0010B\u001a\u0004\bm\u0010\u001e\"\u0004\bn\u0010 R\u001a\u0010o\u001a\u00020pX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR\u001a\u0010u\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010M\"\u0004\bw\u0010OR\u001c\u0010x\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010M\"\u0004\bz\u0010OR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\u0016R\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010G\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\u0016\u00a8\u0006\u008f\u0001"}, d2={"Lorg/jglrxavpok/hephaistos/mca/ChunkColumn;", "", "x", "", "z", "minY", "maxY", "(IIII)V", "chunkData", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "__minY", "__maxY", "(Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;II)V", "(Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;)V", "airCarvingMask", "Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "getAirCarvingMask", "()Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "setAirCarvingMask", "(Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;)V", "biomeArraySize", "getBiomeArraySize", "()I", "dataVersion", "getDataVersion", "setDataVersion", "(I)V", "entities", "Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "getEntities", "()Lorg/jglrxavpok/hephaistos/nbt/NBTList;", "setEntities", "(Lorg/jglrxavpok/hephaistos/nbt/NBTList;)V", "generationStatus", "Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "getGenerationStatus", "()Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "setGenerationStatus", "(Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;)V", "inhabitedTime", "", "getInhabitedTime", "()J", "setInhabitedTime", "(J)V", "lastUpdate", "getLastUpdate", "setLastUpdate", "lightOn", "", "getLightOn", "()Z", "setLightOn", "(Z)V", "lights", "Lorg/jglrxavpok/hephaistos/nbt/NBTShort;", "getLights", "setLights", "liquidCarvingMask", "getLiquidCarvingMask", "setLiquidCarvingMask", "liquidTicks", "getLiquidTicks", "setLiquidTicks", "liquidsToBeTicked", "getLiquidsToBeTicked$annotations", "()V", "getLiquidsToBeTicked", "setLiquidsToBeTicked", "logicalHeight", "getLogicalHeight", "<set-?>", "getMaxY", "getMinY", "motionBlockingHeightMap", "Lorg/jglrxavpok/hephaistos/mca/Heightmap;", "getMotionBlockingHeightMap", "()Lorg/jglrxavpok/hephaistos/mca/Heightmap;", "setMotionBlockingHeightMap", "(Lorg/jglrxavpok/hephaistos/mca/Heightmap;)V", "motionBlockingNoLeavesHeightMap", "getMotionBlockingNoLeavesHeightMap", "setMotionBlockingNoLeavesHeightMap", "oceanFloorHeightMap", "getOceanFloorHeightMap", "setOceanFloorHeightMap", "oceanFloorWorldGenHeightMap", "getOceanFloorWorldGenHeightMap", "setOceanFloorWorldGenHeightMap", "postProcessing", "getPostProcessing", "setPostProcessing", "sections", "Lit/unimi/dsi/fastutil/bytes/Byte2ObjectOpenHashMap;", "Lorg/jglrxavpok/hephaistos/mca/ChunkSection;", "getSections", "()Lit/unimi/dsi/fastutil/bytes/Byte2ObjectOpenHashMap;", "structures", "getStructures", "()Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "setStructures", "tileEntities", "getTileEntities", "setTileEntities", "tileTicks", "getTileTicks", "setTileTicks", "toBeTicked", "getToBeTicked$annotations", "getToBeTicked", "setToBeTicked", "version", "Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "getVersion", "()Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;", "setVersion", "(Lorg/jglrxavpok/hephaistos/mca/SupportedVersion;)V", "worldSurfaceHeightMap", "getWorldSurfaceHeightMap", "setWorldSurfaceHeightMap", "worldSurfaceWorldGenHeightMap", "getWorldSurfaceWorldGenHeightMap", "setWorldSurfaceWorldGenHeightMap", "getX", "getZ", "changeVersion", "", "checkBounds", "y", "getBiome", "", "getBlockState", "Lorg/jglrxavpok/hephaistos/mca/BlockState;", "getSection", "sectionY", "", "setBiome", "biomeID", "setBlockState", "state", "setYRange", "toNBT", "GenerationStatus", "common"})
public final class ChunkColumn {
    private int x;
    private int z;
    private int minY;
    private int maxY;
    @NotNull
    private SupportedVersion version;
    private int dataVersion;
    @NotNull
    private GenerationStatus generationStatus;
    private long lastUpdate;
    private long inhabitedTime;
    @NotNull
    private Heightmap motionBlockingHeightMap;
    @NotNull
    private Heightmap worldSurfaceHeightMap;
    @Nullable
    private Heightmap motionBlockingNoLeavesHeightMap;
    @Nullable
    private Heightmap worldSurfaceWorldGenHeightMap;
    @Nullable
    private Heightmap oceanFloorHeightMap;
    @Nullable
    private Heightmap oceanFloorWorldGenHeightMap;
    @NotNull
    private NBTList<NBTCompound> entities;
    @NotNull
    private NBTList<NBTCompound> tileEntities;
    @NotNull
    private NBTList<NBTCompound> tileTicks;
    @NotNull
    private NBTList<NBTCompound> liquidTicks;
    @Nullable
    private NBTCompound structures;
    @Nullable
    private NBTList<NBTList<NBTShort>> lights;
    @Nullable
    private NBTList<NBTList<NBTShort>> liquidsToBeTicked;
    @Nullable
    private NBTList<NBTList<NBTShort>> toBeTicked;
    @Nullable
    private NBTList<NBTList<NBTShort>> postProcessing;
    @NotNull
    private final Byte2ObjectOpenHashMap<ChunkSection> sections;
    @Nullable
    private ImmutableByteArray airCarvingMask;
    @Nullable
    private ImmutableByteArray liquidCarvingMask;
    private boolean lightOn;

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    @NotNull
    public final SupportedVersion getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull SupportedVersion supportedVersion) {
        Intrinsics.checkNotNullParameter((Object)supportedVersion, "<set-?>");
        this.version = supportedVersion;
    }

    public final int getDataVersion() {
        return this.dataVersion;
    }

    public final void setDataVersion(int n) {
        this.dataVersion = n;
    }

    @NotNull
    public final GenerationStatus getGenerationStatus() {
        return this.generationStatus;
    }

    public final void setGenerationStatus(@NotNull GenerationStatus generationStatus) {
        Intrinsics.checkNotNullParameter((Object)generationStatus, "<set-?>");
        this.generationStatus = generationStatus;
    }

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    public final void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public final long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public final void setInhabitedTime(long l) {
        this.inhabitedTime = l;
    }

    @NotNull
    public final Heightmap getMotionBlockingHeightMap() {
        return this.motionBlockingHeightMap;
    }

    public final void setMotionBlockingHeightMap(@NotNull Heightmap heightmap) {
        Intrinsics.checkNotNullParameter(heightmap, "<set-?>");
        this.motionBlockingHeightMap = heightmap;
    }

    @NotNull
    public final Heightmap getWorldSurfaceHeightMap() {
        return this.worldSurfaceHeightMap;
    }

    public final void setWorldSurfaceHeightMap(@NotNull Heightmap heightmap) {
        Intrinsics.checkNotNullParameter(heightmap, "<set-?>");
        this.worldSurfaceHeightMap = heightmap;
    }

    @Nullable
    public final Heightmap getMotionBlockingNoLeavesHeightMap() {
        return this.motionBlockingNoLeavesHeightMap;
    }

    public final void setMotionBlockingNoLeavesHeightMap(@Nullable Heightmap heightmap) {
        this.motionBlockingNoLeavesHeightMap = heightmap;
    }

    @Nullable
    public final Heightmap getWorldSurfaceWorldGenHeightMap() {
        return this.worldSurfaceWorldGenHeightMap;
    }

    public final void setWorldSurfaceWorldGenHeightMap(@Nullable Heightmap heightmap) {
        this.worldSurfaceWorldGenHeightMap = heightmap;
    }

    @Nullable
    public final Heightmap getOceanFloorHeightMap() {
        return this.oceanFloorHeightMap;
    }

    public final void setOceanFloorHeightMap(@Nullable Heightmap heightmap) {
        this.oceanFloorHeightMap = heightmap;
    }

    @Nullable
    public final Heightmap getOceanFloorWorldGenHeightMap() {
        return this.oceanFloorWorldGenHeightMap;
    }

    public final void setOceanFloorWorldGenHeightMap(@Nullable Heightmap heightmap) {
        this.oceanFloorWorldGenHeightMap = heightmap;
    }

    @NotNull
    public final NBTList<NBTCompound> getEntities() {
        return this.entities;
    }

    public final void setEntities(@NotNull NBTList<NBTCompound> nBTList) {
        Intrinsics.checkNotNullParameter(nBTList, "<set-?>");
        this.entities = nBTList;
    }

    @NotNull
    public final NBTList<NBTCompound> getTileEntities() {
        return this.tileEntities;
    }

    public final void setTileEntities(@NotNull NBTList<NBTCompound> nBTList) {
        Intrinsics.checkNotNullParameter(nBTList, "<set-?>");
        this.tileEntities = nBTList;
    }

    @NotNull
    public final NBTList<NBTCompound> getTileTicks() {
        return this.tileTicks;
    }

    public final void setTileTicks(@NotNull NBTList<NBTCompound> nBTList) {
        Intrinsics.checkNotNullParameter(nBTList, "<set-?>");
        this.tileTicks = nBTList;
    }

    @NotNull
    public final NBTList<NBTCompound> getLiquidTicks() {
        return this.liquidTicks;
    }

    public final void setLiquidTicks(@NotNull NBTList<NBTCompound> nBTList) {
        Intrinsics.checkNotNullParameter(nBTList, "<set-?>");
        this.liquidTicks = nBTList;
    }

    @Nullable
    public final NBTCompound getStructures() {
        return this.structures;
    }

    public final void setStructures(@Nullable NBTCompound nBTCompound) {
        this.structures = nBTCompound;
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getLights() {
        return this.lights;
    }

    public final void setLights(@Nullable NBTList<NBTList<NBTShort>> nBTList) {
        this.lights = nBTList;
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getLiquidsToBeTicked() {
        return this.liquidsToBeTicked;
    }

    public final void setLiquidsToBeTicked(@Nullable NBTList<NBTList<NBTShort>> nBTList) {
        this.liquidsToBeTicked = nBTList;
    }

    @Deprecated(message="liquidsToBeTicked no longer exists in 1.18+ worlds", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getLiquidsToBeTicked$annotations() {
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getToBeTicked() {
        return this.toBeTicked;
    }

    public final void setToBeTicked(@Nullable NBTList<NBTList<NBTShort>> nBTList) {
        this.toBeTicked = nBTList;
    }

    @Deprecated(message="toBeTicked no longer exists in 1.18+ worlds", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getToBeTicked$annotations() {
    }

    @Nullable
    public final NBTList<NBTList<NBTShort>> getPostProcessing() {
        return this.postProcessing;
    }

    public final void setPostProcessing(@Nullable NBTList<NBTList<NBTShort>> nBTList) {
        this.postProcessing = nBTList;
    }

    @NotNull
    public final Byte2ObjectOpenHashMap<ChunkSection> getSections() {
        return this.sections;
    }

    @Nullable
    public final ImmutableByteArray getAirCarvingMask() {
        return this.airCarvingMask;
    }

    public final void setAirCarvingMask(@Nullable ImmutableByteArray immutableByteArray) {
        this.airCarvingMask = immutableByteArray;
    }

    @Nullable
    public final ImmutableByteArray getLiquidCarvingMask() {
        return this.liquidCarvingMask;
    }

    public final void setLiquidCarvingMask(@Nullable ImmutableByteArray immutableByteArray) {
        this.liquidCarvingMask = immutableByteArray;
    }

    public final boolean getLightOn() {
        return this.lightOn;
    }

    public final void setLightOn(boolean bl) {
        this.lightOn = bl;
    }

    public final int getLogicalHeight() {
        return this.maxY - this.minY + 1;
    }

    private final int getBiomeArraySize() {
        return this.getLogicalHeight() * 4;
    }

    @JvmOverloads
    public ChunkColumn(int x, int z, int minY, int maxY) {
        this.minY = SizesKt.getVanillaMinY();
        this.maxY = SizesKt.getVanillaMaxY();
        this.version = SupportedVersion.Companion.getLatest();
        this.dataVersion = this.version.getLowestDataVersion();
        this.generationStatus = GenerationStatus.Empty;
        this.motionBlockingHeightMap = new Heightmap();
        this.worldSurfaceHeightMap = new Heightmap();
        this.entities = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.tileEntities = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.tileTicks = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.liquidTicks = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.sections = new Byte2ObjectOpenHashMap();
        this.lightOn = true;
        this.x = x;
        this.z = z;
        this.minY = minY;
        this.maxY = maxY;
    }

    public /* synthetic */ ChunkColumn(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = SizesKt.getVanillaMinY();
        }
        if ((n5 & 8) != 0) {
            n4 = SizesKt.getVanillaMaxY();
        }
        this(n, n2, n3, n4);
    }

    @Deprecated(message="MinY / MaxY is now auto-detected when loading chunks", replaceWith=@ReplaceWith(expression="Remove the MinY/MaxY arguments", imports={}))
    public ChunkColumn(@NotNull NBTCompound chunkData, int __minY, int __maxY) throws AnvilException {
        Intrinsics.checkNotNullParameter(chunkData, "chunkData");
        this(chunkData);
    }

    public /* synthetic */ ChunkColumn(NBTCompound nBTCompound, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) throws AnvilException {
        if ((n3 & 2) != 0) {
            n = SizesKt.getVanillaMinY();
        }
        if ((n3 & 4) != 0) {
            n2 = SizesKt.getVanillaMaxY();
        }
        this(nBTCompound, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public ChunkColumn(@NotNull NBTCompound chunkData) throws AnvilException {
        ImmutableIntArray biomes;
        Object object;
        Object it;
        Object object2;
        Intrinsics.checkNotNullParameter(chunkData, "chunkData");
        this.minY = SizesKt.getVanillaMinY();
        this.maxY = SizesKt.getVanillaMaxY();
        this.version = SupportedVersion.Companion.getLatest();
        this.dataVersion = this.version.getLowestDataVersion();
        this.generationStatus = GenerationStatus.Empty;
        this.motionBlockingHeightMap = new Heightmap();
        this.worldSurfaceHeightMap = new Heightmap();
        this.entities = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.tileEntities = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.tileTicks = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.liquidTicks = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_Compound, null, 2, null);
        this.sections = new Byte2ObjectOpenHashMap();
        this.lightOn = true;
        ChunkReader chunkReader = new ChunkReader(chunkData);
        this.dataVersion = chunkReader.getDataVersion();
        this.version = chunkReader.getMinecraftVersion();
        this.x = chunkReader.getChunkX();
        this.z = chunkReader.getChunkZ();
        NBTList<NBTCompound> sectionsNBT = chunkReader.getSections();
        IntRange yRange = chunkReader.getYRange();
        this.minY = yRange.getFirst();
        this.maxY = yRange.getLast();
        if (this.minY > this.maxY) {
            throw new AnvilException("minY must be <= maxY");
        }
        this.lastUpdate = chunkReader.getLastUpdate();
        this.inhabitedTime = chunkReader.getInhabitedTime();
        this.generationStatus = chunkReader.getGenerationStatus();
        if (this.generationStatus.ordinal() >= GenerationStatus.Heightmaps.ordinal()) {
            if (chunkReader.hasHeightmaps()) {
                Heightmap heightmap;
                Heightmap heightmap2;
                Heightmap heightmap3;
                boolean bl;
                boolean bl2;
                Object object3;
                Heightmap heightmap4;
                Object object4 = chunkReader.getMotionBlockingHeightmap();
                if (object4 == null) {
                    AnvilException.Companion.missing("HeightMaps/MOTION_BLOCKING");
                    throw new KotlinNothingValueException();
                }
                this.motionBlockingHeightMap = new Heightmap((ImmutableLongArray)object4, this.version);
                object4 = chunkReader.getWorldSurfaceHeightmap();
                if (object4 == null) {
                    AnvilException.Companion.missing("HeightMaps/WORLD_SURFACE");
                    throw new KotlinNothingValueException();
                }
                this.worldSurfaceHeightMap = new Heightmap((ImmutableLongArray)object4, this.version);
                ChunkColumn chunkColumn = this;
                object4 = chunkReader.getMotionBlockingNoLeavesHeightmap();
                if (object4 == null) {
                    heightmap4 = null;
                } else {
                    object3 = object4;
                    bl2 = false;
                    bl = false;
                    ImmutableLongArray immutableLongArray = object3;
                    object2 = chunkColumn;
                    boolean bl3 = false;
                    object = new Heightmap((ImmutableLongArray)it, this.getVersion());
                    chunkColumn = object2;
                    heightmap4 = object;
                }
                chunkColumn.motionBlockingNoLeavesHeightMap = heightmap4;
                ChunkColumn chunkColumn2 = this;
                object4 = chunkReader.getWorldSurfaceWorldGenHeightmap();
                if (object4 == null) {
                    heightmap3 = null;
                } else {
                    object3 = object4;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    object2 = chunkColumn2;
                    boolean bl4 = false;
                    object = new Heightmap((ImmutableLongArray)it, this.getVersion());
                    chunkColumn2 = object2;
                    heightmap3 = object;
                }
                chunkColumn2.worldSurfaceWorldGenHeightMap = heightmap3;
                ChunkColumn chunkColumn3 = this;
                object4 = chunkReader.getOceanFloorHeightmap();
                if (object4 == null) {
                    heightmap2 = null;
                } else {
                    object3 = object4;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    object2 = chunkColumn3;
                    boolean bl5 = false;
                    object = new Heightmap((ImmutableLongArray)it, this.getVersion());
                    chunkColumn3 = object2;
                    heightmap2 = object;
                }
                chunkColumn3.oceanFloorHeightMap = heightmap2;
                ChunkColumn chunkColumn4 = this;
                object4 = chunkReader.getOceanFloorWorldGenHeightmap();
                if (object4 == null) {
                    heightmap = null;
                } else {
                    object3 = object4;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    object2 = chunkColumn4;
                    boolean bl6 = false;
                    object = new Heightmap((ImmutableLongArray)it, this.getVersion());
                    chunkColumn4 = object2;
                    heightmap = object;
                }
                chunkColumn4.oceanFloorWorldGenHeightMap = heightmap;
            }
        } else {
            this.motionBlockingHeightMap = new Heightmap();
            this.worldSurfaceHeightMap = new Heightmap();
        }
        this.entities = chunkReader.getOldEntities();
        this.tileEntities = chunkReader.getTileEntities();
        this.tileTicks = chunkReader.getTileTicks();
        this.liquidTicks = chunkReader.getLiquidTicks();
        this.structures = chunkReader.getStructures();
        this.airCarvingMask = chunkReader.getAirCarvingMask();
        this.liquidCarvingMask = chunkReader.getLiquidCarvingMask();
        this.lights = chunkReader.getLights();
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            this.liquidsToBeTicked = chunkReader.getOldLiquidsToBeTicked();
            this.toBeTicked = chunkReader.getOldToBeTicked();
        }
        this.lightOn = chunkReader.isLightOn();
        this.postProcessing = chunkReader.getPostProcessing();
        for (NBTCompound nbt : sectionsNBT) {
            Byte by = nbt.getByte("Y");
            if (by == null) {
                AnvilException.Companion.missing("Y");
                throw new KotlinNothingValueException();
            }
            byte sectionY = by;
            if (this.version.compareTo((Enum)SupportedVersion.MC_1_17_0) < 0) {
                byte by2 = sectionY;
                boolean bl = 0 <= by2 ? by2 <= 15 : false;
                if (!bl) continue;
            }
            Map map2 = this.sections;
            it = sectionY;
            ChunkSection bl6 = new ChunkSection(nbt, this.version);
            boolean bl = false;
            map2.put(it, bl6);
        }
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0 && (biomes = chunkReader.getOldBiomes()) != null) {
            byte by;
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Iterable sectionY = biomes;
            Biome.Companion companion = Biome.Companion;
            boolean $i$f$map = false;
            void bl6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                int n = ((Number)item$iv$iv).intValue();
                object2 = destination$iv$iv;
                boolean bl = false;
                object = companion.numericalIDToNamespaceID((int)p0);
                object2.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] biomeNamespaces = objectArray;
            int n = CoordinatesKt.blockToSection(this.minY);
            if (n <= (by = CoordinatesKt.blockToSection(this.maxY))) {
                int sectionY2;
                do {
                    sectionY2 = n++;
                    int offset = (sectionY2 - CoordinatesKt.blockToSection(this.minY)) * 4 * 4 * 4;
                    ChunkSection section = this.getSection((byte)sectionY2);
                    int n2 = 0;
                    String[] stringArray = new String[64];
                    object2 = section;
                    while (n2 < 64) {
                        int n3 = n2++;
                        stringArray[n3] = Biome.Companion.getUnknownBiome();
                    }
                    ((ChunkSection)object2).setBiomes(stringArray);
                    Object[] objectArray2 = section.getBiomes();
                    Intrinsics.checkNotNull(objectArray2);
                    ArraysKt.copyInto$default(biomeNamespaces, objectArray2, 0, offset, offset + 64, 2, null);
                } while (sectionY2 != by);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChunkSection getSection(byte sectionY) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.sections;
        Byte key$iv = sectionY;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ChunkSection answer$iv = new ChunkSection(sectionY);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        return (ChunkSection)v;
    }

    public final void setBlockState(int x, int y, int z, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.checkBounds(x, y, z);
        byte sectionY = CoordinatesKt.blockToSection(y);
        ChunkSection section = this.getSection(sectionY);
        section.set(CoordinatesKt.blockInsideSection(x), CoordinatesKt.blockInsideSection(y), CoordinatesKt.blockInsideSection(z), state);
    }

    @NotNull
    public final BlockState getBlockState(int x, int y, int z) {
        this.checkBounds(x, y, z);
        byte sectionY = CoordinatesKt.blockToSection(y);
        ChunkSection section = this.getSection(sectionY);
        if (section.getEmpty()) {
            return BlockState.AIR;
        }
        return section.get(CoordinatesKt.blockInsideSection(x), CoordinatesKt.blockInsideSection(y), CoordinatesKt.blockInsideSection(z));
    }

    private final void checkBounds(int x, int y, int z) {
        if (!(0 <= x ? x <= 15 : false)) {
            throw new IllegalArgumentException("x (" + x + ") is not in 0..15");
        }
        if (!(0 <= z ? z <= 15 : false)) {
            throw new IllegalArgumentException("z (" + z + ") is not in 0..15");
        }
        int n = this.minY;
        if (!(y <= this.maxY ? n <= y : false)) {
            throw new IllegalArgumentException("y (" + y + ") is not in " + this.minY + ".." + this.maxY);
        }
    }

    public final void setBiome(int x, int y, int z, @NotNull String biomeID) {
        Intrinsics.checkNotNullParameter(biomeID, "biomeID");
        this.checkBounds(x, y, z);
        ChunkSection section = this.getSection(CoordinatesKt.blockToSection(y));
        section.setBiome(CoordinatesKt.blockInsideSection(x), CoordinatesKt.blockInsideSection(y), CoordinatesKt.blockInsideSection(z), biomeID);
    }

    @NotNull
    public final String getBiome(int x, int y, int z) {
        this.checkBounds(x, y, z);
        ChunkSection section = this.getSection(CoordinatesKt.blockToSection(y));
        return section.getBiome(CoordinatesKt.blockInsideSection(x), CoordinatesKt.blockInsideSection(y), CoordinatesKt.blockInsideSection(z));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final NBTCompound toNBT(@NotNull SupportedVersion version2) throws IllegalArgumentException {
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Heightmap it;
        boolean section2;
        int offset2;
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        ChunkWriter chunkWriter = new ChunkWriter(version2);
        boolean bl = false;
        boolean bl2 = false;
        ChunkWriter $this$toNBT_u24lambda_u2d12 = chunkWriter;
        boolean bl3 = false;
        if (version2.compareTo((Enum)SupportedVersion.MC_1_17_0) < 0 && (this.getMinY() != 0 || this.getMaxY() != 255)) {
            throw new IllegalArgumentException("Versions prior to 1.17 do not support chunks with Y outside of 0-255 range. Current is " + this.getMinY() + " - " + this.getMaxY());
        }
        $this$toNBT_u24lambda_u2d12.setCoordinates(this.getX(), this.getZ());
        $this$toNBT_u24lambda_u2d12.setLastUpdate(this.getLastUpdate());
        $this$toNBT_u24lambda_u2d12.setInhabitedTime(this.getInhabitedTime());
        $this$toNBT_u24lambda_u2d12.setStatus(this.getGenerationStatus());
        if (version2.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) >= 0) {
            $this$toNBT_u24lambda_u2d12.setYPos(this.getMinY());
            int n = CoordinatesKt.blockToSection(this.getMinY());
            byte by = CoordinatesKt.blockToSection(this.getMaxY());
            if (n <= by) {
                int sectionY;
                do {
                    sectionY = n++;
                    this.getSection((byte)sectionY);
                } while (sectionY != by);
            }
        } else {
            int[] biomes = null;
            for (ChunkSection section2 : (ObjectCollection)this.getSections().values()) {
                if (!section2.hasBiomeData()) continue;
                if (biomes == null) {
                    biomes = new int[this.getBiomeArraySize()];
                }
                offset2 = (section2.getY() - CoordinatesKt.blockToSection(this.getMinY())) * 4 * 4 * 4;
                String[] stringArray = section2.getBiomes();
                Intrinsics.checkNotNull(stringArray);
                String[] $this$forEachIndexed$iv = stringArray;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    void id2;
                    int n = index$iv++;
                    String string = item$iv;
                    int index = n;
                    boolean bl4 = false;
                    Biome oldBiome = Biome.Companion.fromNamespaceID((String)id2);
                    biomes[offset2 + index] = oldBiome.getNumericalID();
                }
            }
            if (biomes != null) {
                $this$toNBT_u24lambda_u2d12.setOldBiomes(new ImmutableIntArray(Arrays.copyOf(biomes, biomes.length)));
            } else {
                $this$toNBT_u24lambda_u2d12.setOldBiomes(new ImmutableIntArray(this.getBiomeArraySize(), toNBT.1.2.INSTANCE));
            }
        }
        $this$toNBT_u24lambda_u2d12.setMotionBlockingHeightMap(NBT.Companion.LongArray(this.getMotionBlockingHeightMap().compact(version2)));
        Heightmap biomes = this.getMotionBlockingNoLeavesHeightMap();
        if (biomes != null) {
            Heightmap heightmap = biomes;
            section2 = false;
            offset2 = 0;
            it = heightmap;
            boolean bl5 = false;
            $this$toNBT_u24lambda_u2d12.setMotionBlockingNoLeavesHeightMap(NBT.Companion.LongArray(it.compact(version2)));
        }
        biomes = this.getOceanFloorHeightMap();
        if (biomes != null) {
            Heightmap heightmap = biomes;
            section2 = false;
            offset2 = 0;
            it = heightmap;
            boolean bl6 = false;
            $this$toNBT_u24lambda_u2d12.setOceanFloorHeightMap(NBT.Companion.LongArray(it.compact(version2)));
        }
        biomes = this.getOceanFloorWorldGenHeightMap();
        if (biomes != null) {
            Heightmap heightmap = biomes;
            section2 = false;
            offset2 = 0;
            it = heightmap;
            boolean bl7 = false;
            $this$toNBT_u24lambda_u2d12.setOceanFloorWorldGenHeightMap(NBT.Companion.LongArray(it.compact(version2)));
        }
        $this$toNBT_u24lambda_u2d12.setWorldSurfaceHeightMap(NBT.Companion.LongArray(this.getWorldSurfaceHeightMap().compact(version2)));
        biomes = this.getWorldSurfaceWorldGenHeightMap();
        if (biomes != null) {
            Heightmap heightmap = biomes;
            section2 = false;
            offset2 = 0;
            it = heightmap;
            boolean bl8 = false;
            $this$toNBT_u24lambda_u2d12.setWorldSurfaceWorldGenHeightMap(NBT.Companion.LongArray(it.compact(version2)));
        }
        Iterable iterable = this.getSections().values();
        Intrinsics.checkNotNullExpressionValue(iterable, "this@ChunkColumn.sections.values");
        iterable = iterable;
        boolean $i$f$filter = false;
        void offset2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChunkSection it2 = (ChunkSection)element$iv$iv;
            boolean bl9 = false;
            if (!(version2.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) >= 0 || !it2.getEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChunkSection it2 = (ChunkSection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl10 = false;
            NBTCompound nBTCompound = it2.toNBT(version2);
            collection.add(nBTCompound);
        }
        List allSections = CollectionsKt.toMutableList((List)destination$iv$iv);
        if (version2.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            $this$map$iv = allSections;
            NBTCompound nBTCompound = new ChunkSection((byte)(CoordinatesKt.blockToSection(this.getMinY()) - 1)).toNBT(version2);
            boolean bl11 = false;
            $this$map$iv.add(nBTCompound);
        }
        NBTList<NBTCompound> sections = NBT.Companion.List(NBTType.TAG_Compound, allSections);
        $this$toNBT_u24lambda_u2d12.setSectionsData(sections);
        $this$toNBT_u24lambda_u2d12.setOldEntityData(this.getEntities());
        $this$toNBT_u24lambda_u2d12.setBlockEntityData(this.getTileEntities());
        $this$toNBT_u24lambda_u2d12.setBlockTicks(this.getTileTicks());
        $this$toNBT_u24lambda_u2d12.setFluidTicks(this.getLiquidTicks());
        if (this.getStructures() != null) {
            NBTCompound nBTCompound = this.getStructures();
            Intrinsics.checkNotNull(nBTCompound);
            $this$toNBT_u24lambda_u2d12.setStructures(nBTCompound);
        }
        if (this.getAirCarvingMask() != null) {
            ImmutableByteArray immutableByteArray = this.getAirCarvingMask();
            Intrinsics.checkNotNull(immutableByteArray);
            $this$toNBT_u24lambda_u2d12.setAirCarvingMask(immutableByteArray);
        }
        if (this.getLiquidCarvingMask() != null) {
            ImmutableByteArray immutableByteArray = this.getLiquidCarvingMask();
            Intrinsics.checkNotNull(immutableByteArray);
            $this$toNBT_u24lambda_u2d12.setLiquidCarvingMask(immutableByteArray);
        }
        if (this.getLights() != null) {
            NBTList<NBTList<NBTShort>> nBTList = this.getLights();
            Intrinsics.checkNotNull(nBTList);
            $this$toNBT_u24lambda_u2d12.setLights(nBTList);
        }
        if (version2.compareTo((Enum)SupportedVersion.MC_1_18_PRE_4) < 0) {
            if (this.getLiquidsToBeTicked() != null) {
                NBTList<NBTList<NBTShort>> nBTList = this.getLiquidsToBeTicked();
                Intrinsics.checkNotNull(nBTList);
                $this$toNBT_u24lambda_u2d12.setOldLiquidsToBeTicked(nBTList);
            }
            if (this.getToBeTicked() != null) {
                NBTList<NBTList<NBTShort>> nBTList = this.getToBeTicked();
                Intrinsics.checkNotNull(nBTList);
                $this$toNBT_u24lambda_u2d12.setOldToBeTicked(nBTList);
            }
        } else {
            $this$toNBT_u24lambda_u2d12.setLightOn(this.getLightOn());
        }
        if (this.getPostProcessing() != null) {
            NBTList<NBTList<NBTShort>> nBTList = this.getPostProcessing();
            Intrinsics.checkNotNull(nBTList);
            $this$toNBT_u24lambda_u2d12.setPostProcessing(nBTList);
        }
        return chunkWriter.toNBT();
    }

    public static /* synthetic */ NBTCompound toNBT$default(ChunkColumn chunkColumn, SupportedVersion supportedVersion, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            supportedVersion = chunkColumn.version;
        }
        return chunkColumn.toNBT(supportedVersion);
    }

    public final void changeVersion(@NotNull SupportedVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        this.version = version2;
        this.dataVersion = version2.getLowestDataVersion();
    }

    public final void setYRange(int minY, int maxY) {
        byte by;
        if (this.version.compareTo((Enum)SupportedVersion.MC_1_17_0) < 0) {
            throw new IllegalArgumentException("Versions prior to 1.17 do not support chunks with Y outside of 0-255 range.");
        }
        if (minY >= maxY) {
            throw new IllegalArgumentException("minY (" + minY + ") must be < maxY (" + maxY + ')');
        }
        this.minY = minY;
        this.maxY = maxY;
        int n = CoordinatesKt.blockToSection(minY);
        if (n <= (by = CoordinatesKt.blockToSection(maxY))) {
            int sectionY;
            do {
                sectionY = n++;
                this.getSection((byte)sectionY);
            } while (sectionY != by);
        }
    }

    @JvmOverloads
    public ChunkColumn(int x, int z, int minY) {
        this(x, z, minY, 0, 8, null);
    }

    @JvmOverloads
    public ChunkColumn(int x, int z) {
        this(x, z, 0, 0, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final NBTCompound toNBT() throws IllegalArgumentException {
        return ChunkColumn.toNBT$default(this, null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0001\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "", "id", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "Empty", "StructureStarts", "StructureReferences", "Biomes", "Noise", "Surface", "Carvers", "LiquidCarvers", "Features", "Light", "Spawn", "Heightmaps", "Full", "Companion", "common"})
    public static final class GenerationStatus
    extends Enum<GenerationStatus> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        public static final /* enum */ GenerationStatus Empty;
        public static final /* enum */ GenerationStatus StructureStarts;
        public static final /* enum */ GenerationStatus StructureReferences;
        public static final /* enum */ GenerationStatus Biomes;
        public static final /* enum */ GenerationStatus Noise;
        public static final /* enum */ GenerationStatus Surface;
        public static final /* enum */ GenerationStatus Carvers;
        public static final /* enum */ GenerationStatus LiquidCarvers;
        public static final /* enum */ GenerationStatus Features;
        public static final /* enum */ GenerationStatus Light;
        public static final /* enum */ GenerationStatus Spawn;
        public static final /* enum */ GenerationStatus Heightmaps;
        public static final /* enum */ GenerationStatus Full;
        private static final /* synthetic */ GenerationStatus[] $VALUES;

        private GenerationStatus(String id2) {
            this.id = id2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public static GenerationStatus[] values() {
            GenerationStatus[] generationStatusArray = $VALUES;
            return Arrays.copyOf(generationStatusArray, generationStatusArray.length);
        }

        public static GenerationStatus valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(GenerationStatus.class, value);
        }

        @JvmStatic
        @NotNull
        public static final GenerationStatus fromID(@NotNull String id2) {
            return Companion.fromID(id2);
        }

        static {
            Empty = new GenerationStatus("empty");
            StructureStarts = new GenerationStatus("structure_starts");
            StructureReferences = new GenerationStatus("structure_references");
            Biomes = new GenerationStatus("biomes");
            Noise = new GenerationStatus("noise");
            Surface = new GenerationStatus("surface");
            Carvers = new GenerationStatus("carvers");
            LiquidCarvers = new GenerationStatus("liquid_carvers");
            Features = new GenerationStatus("features");
            Light = new GenerationStatus("light");
            Spawn = new GenerationStatus("spawn");
            Heightmaps = new GenerationStatus("heightmaps");
            Full = new GenerationStatus("full");
            $VALUES = generationStatusArray = new GenerationStatus[]{GenerationStatus.Empty, GenerationStatus.StructureStarts, GenerationStatus.StructureReferences, GenerationStatus.Biomes, GenerationStatus.Noise, GenerationStatus.Surface, GenerationStatus.Carvers, GenerationStatus.LiquidCarvers, GenerationStatus.Features, GenerationStatus.Light, GenerationStatus.Spawn, GenerationStatus.Heightmaps, GenerationStatus.Full};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus$Companion;", "", "()V", "fromID", "Lorg/jglrxavpok/hephaistos/mca/ChunkColumn$GenerationStatus;", "id", "", "common"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final GenerationStatus fromID(@NotNull String id2) {
                GenerationStatus generationStatus;
                block2: {
                    GenerationStatus generationStatus2;
                    Intrinsics.checkNotNullParameter(id2, "id");
                    GenerationStatus[] $this$firstOrNull$iv = GenerationStatus.values();
                    boolean $i$f$firstOrNull = false;
                    GenerationStatus[] generationStatusArray = $this$firstOrNull$iv;
                    int n = generationStatusArray.length;
                    for (int i = 0; i < n; ++i) {
                        GenerationStatus element$iv;
                        GenerationStatus it = element$iv = generationStatusArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getId(), id2)) continue;
                        generationStatus2 = element$iv;
                        break block2;
                    }
                    generationStatus2 = generationStatus = null;
                }
                if (generationStatus == null) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid id: ", id2));
                }
                return generationStatus;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

