/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.CompoundBuilder;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTString;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0002H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ#\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\b\u001a\u00020\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010J\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonReader;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "close", "", "read", "Tag", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "()Lorg/jglrxavpok/hephaistos/nbt/NBT;", "nbtClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jglrxavpok/hephaistos/nbt/NBT;", "nbtType", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "readWithGuess", "Companion", "gson"})
public final class NBTGsonReader
implements AutoCloseable,
Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Reader reader;
    @Deprecated
    @NotNull
    private static final Gson GsonInstance = new Gson();

    public NBTGsonReader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.reader = reader;
    }

    public final /* synthetic */ <Tag extends NBT> Tag read() {
        boolean $i$f$read = false;
        NBTType.Companion this_$iv = NBTType.Companion;
        boolean $i$f$byClass = false;
        Intrinsics.reifiedOperationMarker(4, "Tag");
        NBTType nBTType = this_$iv.byClass(Reflection.getOrCreateKotlinClass(NBT.class));
        if (nBTType == null) {
            Intrinsics.reifiedOperationMarker(4, "Tag");
            String string = Intrinsics.stringPlus("Invalid NBTType: ", Reflection.getOrCreateKotlinClass(NBT.class).getQualifiedName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NBT nBT = this.read(nBTType);
        Intrinsics.reifiedOperationMarker(1, "Tag");
        return (Tag)nBT;
    }

    @NotNull
    public final <Tag extends NBT> Tag read(@NotNull Class<Tag> nbtClass) {
        Intrinsics.checkNotNullParameter(nbtClass, "nbtClass");
        NBTType<Tag> nBTType = NBTType.Companion.byClass(nbtClass);
        if (nBTType == null) {
            String string = Intrinsics.stringPlus("Invalid NBTType: ", nbtClass.getCanonicalName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (Tag)this.read(nBTType);
    }

    @NotNull
    public final NBT read(@NotNull NBTType<? extends NBT> nbtType) {
        Intrinsics.checkNotNullParameter(nbtType, "nbtType");
        JsonElement jsonElement = GsonInstance.fromJson(this.reader, JsonElement.class);
        Intrinsics.checkNotNullExpressionValue(jsonElement, "GsonInstance.fromJson(reader, JsonElement::class.java)");
        return Companion.parse(nbtType, jsonElement);
    }

    @NotNull
    public final NBT readWithGuess() {
        JsonElement element = GsonInstance.fromJson(this.reader, JsonElement.class);
        Intrinsics.checkNotNullExpressionValue(element, "element");
        return Companion.parse(NBTGsonReader.Companion.guessType(element), element);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @JvmStatic
    @NotNull
    public static final <Tag extends NBT> Tag parse(@NotNull NBTType<? extends NBT> nbtType, @NotNull JsonElement element) {
        return Companion.parse(nbtType, element);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0003J/\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jglrxavpok/hephaistos/json/NBTGsonReader$Companion;", "", "()V", "GsonInstance", "Lcom/google/gson/Gson;", "getGsonInstance", "()Lcom/google/gson/Gson;", "guessType", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "element", "Lcom/google/gson/JsonElement;", "parse", "Tag", "nbtType", "(Lorg/jglrxavpok/hephaistos/nbt/NBTType;Lcom/google/gson/JsonElement;)Lorg/jglrxavpok/hephaistos/nbt/NBT;", "toCompound", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "jsonObject", "Lcom/google/gson/JsonObject;", "gson"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGsonInstance() {
            return GsonInstance;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <Tag extends NBT> Tag parse(@NotNull NBTType<? extends NBT> nbtType, @NotNull JsonElement element) {
            Intrinsics.checkNotNullParameter(nbtType, "nbtType");
            Intrinsics.checkNotNullParameter(element, "element");
            try {
                Object object;
                Object object2;
                JsonElement it;
                Object object3;
                Iterable<JsonElement> $this$mapTo$iv$iv;
                Iterable<JsonElement> $this$map$iv;
                NBT.Companion companion;
                NBT nBT;
                NBTType<? extends NBT> nBTType = nbtType;
                if (Intrinsics.areEqual(nBTType, NBTType.TAG_End)) {
                    nBT = NBTEnd.INSTANCE;
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Byte)) {
                    nBT = NBT.Companion.Byte(element.getAsByte());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Short)) {
                    nBT = NBT.Companion.Short(element.getAsShort());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Int)) {
                    nBT = NBT.Companion.Int(element.getAsInt());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Long)) {
                    nBT = NBT.Companion.Long(element.getAsLong());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Float)) {
                    nBT = NBT.Companion.Float(element.getAsFloat());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Double)) {
                    nBT = NBT.Companion.Double(element.getAsDouble());
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Byte_Array)) {
                    Iterable<JsonElement> iterable = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue(iterable, "element.asJsonArray");
                    iterable = iterable;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    void var8_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object t2 : $this$mapTo$iv$iv) {
                        JsonElement jsonElement = (JsonElement)t2;
                        object3 = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsByte();
                        object3.add(object2);
                    }
                    object3 = (List)destination$iv$iv;
                    object = CollectionsKt.toByteArray((Collection)object3);
                    nBT = companion.ByteArray(Arrays.copyOf((byte[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_String)) {
                    NBTString nBTString;
                    if (element.isJsonNull()) {
                        nBTString = NBT.Companion.String("");
                    } else {
                        object = element.getAsString();
                        Intrinsics.checkNotNullExpressionValue(object, "element.asString");
                        nBTString = NBT.Companion.String((String)object);
                    }
                    nBT = nBTString;
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Compound)) {
                    object = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue(object, "element.asJsonObject");
                    nBT = this.toCompound((JsonObject)object);
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Int_Array)) {
                    $this$map$iv = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue($this$map$iv, "element.asJsonArray");
                    $this$map$iv = $this$map$iv;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object object4 : $this$mapTo$iv$iv) {
                        it = (JsonElement)object4;
                        object3 = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsInt();
                        object3.add((Integer)object2);
                    }
                    object3 = (List)destination$iv$iv;
                    object = CollectionsKt.toIntArray(object3);
                    nBT = companion.IntArray(Arrays.copyOf((int[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_Long_Array)) {
                    $this$map$iv = element.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue($this$map$iv, "element.asJsonArray");
                    $this$map$iv = $this$map$iv;
                    companion = NBT.Companion;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object object5 : $this$mapTo$iv$iv) {
                        it = (JsonElement)object5;
                        object3 = destination$iv$iv;
                        boolean bl = false;
                        object2 = it.getAsLong();
                        object3.add(object2);
                    }
                    object3 = (List)destination$iv$iv;
                    object = CollectionsKt.toLongArray(object3);
                    nBT = companion.LongArray(Arrays.copyOf((long[])object, ((Object)object).length));
                } else if (Intrinsics.areEqual(nBTType, NBTType.TAG_List)) {
                    NBTList nBTList;
                    if (!element.isJsonArray()) {
                        throw new NBTException(Intrinsics.stringPlus("Expected a list, but was: ", element), null, 2, null);
                    }
                    JsonArray elements = element.getAsJsonArray();
                    if (elements.size() == 0) {
                        nBTList = NBT.Companion.List$default(NBT.Companion, NBTType.TAG_String, null, 2, null);
                    } else {
                        NBTList list2;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        JsonElement $i$f$map = elements.get(0);
                        Intrinsics.checkNotNullExpressionValue($i$f$map, "elements[0]");
                        NBTType<? extends NBT> nBTType2 = this.guessType($i$f$map);
                        $i$f$map = elements.get(0);
                        Intrinsics.checkNotNullExpressionValue($i$f$map, "elements[0]");
                        Tag firstElement = this.parse(nBTType2, $i$f$map);
                        NBTType<? extends NBT> nBTType3 = firstElement.getID();
                        Intrinsics.checkNotNullExpressionValue(elements, "elements");
                        $this$mapTo$iv$iv = elements;
                        object3 = nBTType3;
                        companion = NBT.Companion;
                        boolean $i$f$map2 = false;
                        void $i$f$mapTo = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean bl = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it2;
                            JsonElement jsonElement = (JsonElement)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl2 = false;
                            Companion companion2 = Companion;
                            NBTType<? extends NBT> nBTType4 = firstElement.getID();
                            Intrinsics.checkNotNullExpressionValue(it2, "it");
                            Tag Tag2 = companion2.parse(nBTType4, (JsonElement)it2);
                            object2.add(Tag2);
                        }
                        object2 = (List)destination$iv$iv;
                        nBTList = list2 = companion.List(object3, object2);
                    }
                    nBT = nBTList;
                } else {
                    throw new IllegalArgumentException(nbtType + " is not a valid/supported NBT type");
                }
                NBT result2 = nBT;
                return (Tag)result2;
            }
            catch (IllegalStateException e) {
                throw new NBTException("Failed to load NBT from json", e);
            }
        }

        @JvmStatic
        private final NBTCompound toCompound(JsonObject jsonObject) {
            NBT.Companion this_$iv = NBT.Companion;
            boolean $i$f$Kompound = false;
            return this_$iv.Compound(new CompoundBuilder(jsonObject){
                final /* synthetic */ JsonObject $jsonObject$inlined;
                {
                    this.$jsonObject$inlined = jsonObject;
                }

                public final void run(@NotNull MutableNBTCompound it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    MutableNBTCompound $this$toCompound_u24lambda_u2d4 = it;
                    boolean bl = false;
                    for (Map.Entry<String, JsonElement> entry2 : this.$jsonObject$inlined.entrySet()) {
                        Intrinsics.checkNotNullExpressionValue(entry2, "jsonObject.entrySet()");
                        Map.Entry<String, JsonElement> entry3 = entry2;
                        boolean bl2 = false;
                        String key = entry3.getKey();
                        Map.Entry<String, JsonElement> entry4 = entry2;
                        boolean bl3 = false;
                        JsonElement value = entry4.getValue();
                        Companion companion = NBTGsonReader.access$getCompanion$p();
                        Companion companion2 = NBTGsonReader.access$getCompanion$p();
                        Intrinsics.checkNotNullExpressionValue(value, "value");
                        Tag nbt = companion.parse(org.jglrxavpok.hephaistos.json.NBTGsonReader$Companion.access$guessType(companion2, value), value);
                        Intrinsics.checkNotNullExpressionValue(key, "key");
                        $this$toCompound_u24lambda_u2d4.set(key, (NBT)nbt);
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        private final NBTType<? extends NBT> guessType(JsonElement element) {
            NBTType<? extends NBT> guessedType;
            NBTType<NBT> nBTType;
            if (element.isJsonObject()) {
                nBTType = NBTType.TAG_Compound;
                return nBTType;
            }
            if (element.isJsonNull()) {
                nBTType = NBTType.TAG_String;
                return nBTType;
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    nBTType = NBTType.TAG_Byte;
                    return nBTType;
                }
                if (primitive.isString()) {
                    nBTType = NBTType.TAG_String;
                    return nBTType;
                }
                if (!primitive.isNumber()) {
                    String string = "Primitive that is neither a boolean, a string, nor a number?";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (!((double)primitive.getAsLong() == primitive.getAsDouble())) {
                    nBTType = NBTType.TAG_Double;
                    return nBTType;
                }
                String string = primitive.getAsString();
                Intrinsics.checkNotNullExpressionValue(string, "primitive.asString");
                if (StringsKt.contains$default((CharSequence)string, '.', false, 2, null)) {
                    nBTType = NBTType.TAG_Double;
                    return nBTType;
                }
                nBTType = NBTType.TAG_Long;
                return nBTType;
            }
            if (!element.isJsonArray()) {
                String string = Intrinsics.stringPlus("Unknown json element type ", element);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            JsonArray array = element.getAsJsonArray();
            if (array.size() == 0) {
                nBTType = NBTType.TAG_List;
                return nBTType;
            }
            JsonElement firstElement = element.getAsJsonArray().get(0);
            Intrinsics.checkNotNullExpressionValue(firstElement, "firstElement");
            NBTType<? extends NBT> nBTType2 = guessedType = this.guessType(firstElement);
            if (Intrinsics.areEqual(nBTType2, NBTType.TAG_Long)) {
                nBTType = NBTType.TAG_Long_Array;
                return nBTType;
            }
            if (Intrinsics.areEqual(nBTType2, NBTType.TAG_Byte)) {
                nBTType = NBTType.TAG_Byte_Array;
                return nBTType;
            }
            if (Intrinsics.areEqual(nBTType2, NBTType.TAG_Int)) {
                nBTType = NBTType.TAG_Int_Array;
                return nBTType;
            }
            nBTType = NBTType.TAG_List;
            return nBTType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

