/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.data;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.data.DataSource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0018\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0096\u0001J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\u0019\u0010\u001c\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J)\u0010\u001c\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0096\u0001J\t\u0010\"\u001a\u00020 H\u0096\u0001J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0011\u0010#\u001a\n \u001e*\u0004\u0018\u00010$0$H\u0096\u0001J\t\u0010%\u001a\u00020\rH\u0096\u0001J\t\u0010&\u001a\u00020'H\u0096\u0001J\u0011\u0010(\u001a\n \u001e*\u0004\u0018\u00010$0$H\u0096\u0001J\t\u0010)\u001a\u00020 H\u0096\u0001J\t\u0010*\u001a\u00020 H\u0096\u0001J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\rH\u0016J\u0011\u0010/\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0019\u00100\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J)\u00100\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0096\u0001J\u0011\u00100\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0011\u00101\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0096\u0001J\u0011\u00102\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0018\u00102\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0011H\u0016J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0015H\u0016J\u0019\u00104\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010$0$H\u0096\u0001J\u0011\u00106\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0019\u00107\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010$0$H\u0096\u0001J\u0011\u00108\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0096\u0001J\u0011\u00109\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0096\u0001J\u0011\u0010:\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0018\u0010:\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010;\u001a\u00020 H\u0016J\u0011\u0010<\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\rH\u0096\u0001J\u0011\u0010=\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020 H\u0096\u0001J\u0019\u0010>\u001a\u00020\u000b2\u000e\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010$0$H\u0096\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006?"}, d2={"Lorg/jglrxavpok/hephaistos/data/RandomAccessFileSource;", "Lorg/jglrxavpok/hephaistos/data/DataSource;", "Ljava/io/DataInput;", "Ljava/io/DataOutput;", "Ljava/io/Closeable;", "file", "Ljava/io/RandomAccessFile;", "(Ljava/io/RandomAccessFile;)V", "getFile", "()Ljava/io/RandomAccessFile;", "close", "", "length", "", "readBoolean", "", "readByte", "", "pos", "readBytes", "destination", "", "readChar", "", "readDouble", "", "readFloat", "", "readFully", "p0", "kotlin.jvm.PlatformType", "p1", "", "p2", "readInt", "readLine", "", "readLong", "readShort", "", "readUTF", "readUnsignedByte", "readUnsignedShort", "seek", "position", "setLength", "newLength", "skipBytes", "write", "writeBoolean", "writeByte", "b", "writeBytes", "bytes", "writeChar", "writeChars", "writeDouble", "writeFloat", "writeInt", "int", "writeLong", "writeShort", "writeUTF", "common"})
public final class RandomAccessFileSource
implements DataSource,
DataInput,
DataOutput,
Closeable {
    @NotNull
    private final RandomAccessFile file;

    public RandomAccessFileSource(@NotNull RandomAccessFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
    }

    @NotNull
    public final RandomAccessFile getFile() {
        return this.file;
    }

    @Override
    public boolean readBoolean() {
        return this.file.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.file.readByte();
    }

    @Override
    public char readChar() {
        return this.file.readChar();
    }

    @Override
    public double readDouble() {
        return this.file.readDouble();
    }

    @Override
    public float readFloat() {
        return this.file.readFloat();
    }

    @Override
    public void readFully(byte[] p0) {
        this.file.readFully(p0);
    }

    @Override
    public void readFully(byte[] p0, int p1, int p2) {
        this.file.readFully(p0, p1, p2);
    }

    @Override
    public int readInt() {
        return this.file.readInt();
    }

    @Override
    public String readLine() {
        return this.file.readLine();
    }

    @Override
    public long readLong() {
        return this.file.readLong();
    }

    @Override
    public short readShort() {
        return this.file.readShort();
    }

    @Override
    public String readUTF() {
        return this.file.readUTF();
    }

    @Override
    public int readUnsignedByte() {
        return this.file.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() {
        return this.file.readUnsignedShort();
    }

    @Override
    public int skipBytes(int p0) {
        return this.file.skipBytes(p0);
    }

    @Override
    public void write(byte[] p0) {
        this.file.write(p0);
    }

    @Override
    public void write(byte[] p0, int p1, int p2) {
        this.file.write(p0, p1, p2);
    }

    @Override
    public void write(int p0) {
        this.file.write(p0);
    }

    @Override
    public void writeBoolean(boolean p0) {
        this.file.writeBoolean(p0);
    }

    @Override
    public void writeByte(int p0) {
        this.file.writeByte(p0);
    }

    @Override
    public void writeBytes(String p0) {
        this.file.writeBytes(p0);
    }

    @Override
    public void writeChar(int p0) {
        this.file.writeChar(p0);
    }

    @Override
    public void writeChars(String p0) {
        this.file.writeChars(p0);
    }

    @Override
    public void writeDouble(double p0) {
        this.file.writeDouble(p0);
    }

    @Override
    public void writeFloat(float p0) {
        this.file.writeFloat(p0);
    }

    @Override
    public void writeInt(int p0) {
        this.file.writeInt(p0);
    }

    @Override
    public void writeLong(long p0) {
        this.file.writeLong(p0);
    }

    @Override
    public void writeShort(int p0) {
        this.file.writeShort(p0);
    }

    @Override
    public void writeUTF(String p0) {
        this.file.writeUTF(p0);
    }

    @Override
    public void close() {
        this.file.close();
    }

    @Override
    public void seek(long position) {
        this.file.seek(position);
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public void setLength(long newLength) {
        this.file.setLength(newLength);
    }

    @Override
    public void writeByte(long pos, byte b) {
        this.file.getChannel().write(ByteBuffer.allocate(1).put(0, b), pos);
    }

    @Override
    public void writeBytes(long pos, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.file.getChannel().write(ByteBuffer.wrap(bytes), pos);
    }

    @Override
    public void writeInt(long pos, int n) {
        this.file.getChannel().write(ByteBuffer.allocate(4).putInt(0, n), pos);
    }

    @Override
    public void readBytes(long pos, @NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        ByteBuffer buf = ByteBuffer.allocateDirect(destination.length);
        this.file.getChannel().read(buf, pos);
        int n = 0;
        int n2 = destination.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                destination[i] = buf.get(i);
            } while (n <= n2);
        }
    }

    @Override
    public byte readByte(long pos) {
        ByteBuffer buf = ByteBuffer.allocate(1);
        this.file.getChannel().read(buf, pos);
        return buf.get(0);
    }

    @Override
    public int readInt(long pos) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.file.getChannel().read(buf, pos);
        return buf.getInt(0);
    }
}

