/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.data;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.data.DataSource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u001f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0004H\u0016J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u0004H\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001eH\u0016J\u0010\u00102\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J \u00102\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u00102\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001eH\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0018\u00105\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0012H\u0002J\u0018\u00108\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0006H\u0016J\u0010\u00108\u001a\u00020\t2\u0006\u0010:\u001a\u00020\"H\u0016J\u0010\u0010;\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0010\u0010<\u001a\u00020\t2\u0006\u0010:\u001a\u00020\"H\u0016J\u0010\u0010=\u001a\u00020\t2\u0006\u00104\u001a\u00020\u0018H\u0016J\u0010\u0010>\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001aH\u0016J\u0010\u0010?\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0018\u0010?\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u001eH\u0016J\u0010\u0010A\u001a\u00020\t2\u0006\u00104\u001a\u00020\u0004H\u0016J\u0010\u0010B\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0010\u0010C\u001a\u00020\t2\u0006\u0010:\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jglrxavpok/hephaistos/data/GrowableSource;", "Lorg/jglrxavpok/hephaistos/data/DataSource;", "()V", "cursor", "", "internalBuffer", "", "size", "close", "", "length", "readBoolean", "", "readByte", "", "pos", "readByteBuffer", "buf", "Ljava/nio/ByteBuffer;", "readBytes", "destination", "readChar", "", "readDouble", "", "readFloat", "", "readFully", "b", "off", "", "len", "readInt", "readLine", "", "readLong", "readShort", "", "readUTF", "readUnsignedByte", "readUnsignedShort", "realloc", "resizeIfNeeded", "targetCursor", "seek", "position", "setLength", "newLength", "skipBytes", "n", "write", "writeBoolean", "v", "writeByte", "writeByteBuffer", "byteBuffer", "writeBytes", "bytes", "s", "writeChar", "writeChars", "writeDouble", "writeFloat", "writeInt", "int", "writeLong", "writeShort", "writeUTF", "common"})
public final class GrowableSource
implements DataSource {
    private long cursor;
    private long size;
    @NotNull
    private byte[] internalBuffer = new byte[0];

    @Override
    public void seek(long position) {
        this.cursor = position;
    }

    @Override
    public long length() {
        return this.size;
    }

    private final void realloc(long length) {
        byte[] oldBuffer = this.internalBuffer;
        this.internalBuffer = new byte[(int)length];
        long l = this.size;
        boolean bl = false;
        long l2 = Math.min(l, length);
        ArraysKt.copyInto(oldBuffer, this.internalBuffer, 0, 0, (int)l2);
        this.size = length;
    }

    private final void resizeIfNeeded(long targetCursor) {
        if (targetCursor > this.size) {
            this.setLength(targetCursor);
        }
    }

    @Override
    public void setLength(long newLength) {
        this.realloc(newLength);
    }

    @Override
    public void writeByte(long pos, byte b) {
        this.internalBuffer[(int)pos] = b;
    }

    @Override
    public void writeByte(int v) {
        this.resizeIfNeeded(this.cursor + 1L);
        GrowableSource growableSource = this;
        long l = growableSource.cursor;
        growableSource.cursor = l + 1L;
        this.internalBuffer[(int)l] = (byte)v;
    }

    @Override
    public void writeBytes(long pos, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.resizeIfNeeded(pos + (long)bytes.length);
        ArraysKt.copyInto(bytes, this.internalBuffer, (int)pos, 0, bytes.length);
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.resizeIfNeeded(this.cursor + (long)b.length);
        this.writeBytes(this.cursor, b);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)b.length;
    }

    @Override
    public void writeBytes(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        String string = s2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        this.write(byArray);
    }

    @Override
    public void writeInt(long pos, int n) {
        byte[] byArray = ByteBuffer.allocate(4).putInt(0, n).array();
        Intrinsics.checkNotNullExpressionValue(byArray, "allocate(4).putInt(0, int).array()");
        this.writeBytes(pos, byArray);
    }

    @Override
    public void writeInt(int v) {
        this.resizeIfNeeded(this.cursor + (long)4);
        this.writeInt(this.cursor, v);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)4;
    }

    @Override
    public void readBytes(long pos, @NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.resizeIfNeeded(pos + (long)destination.length);
        ArraysKt.copyInto(this.internalBuffer, destination, 0, (int)pos, (int)pos + destination.length);
    }

    @Override
    public byte readByte(long pos) {
        return this.internalBuffer[(int)pos];
    }

    @Override
    public byte readByte() {
        GrowableSource growableSource = this;
        long l = growableSource.cursor;
        growableSource.cursor = l + 1L;
        return this.internalBuffer[(int)l];
    }

    private final void readByteBuffer(ByteBuffer buf, long pos) {
        if (pos + (long)buf.remaining() > this.size) {
            throw new EOFException();
        }
        buf.put(this.internalBuffer, (int)pos, buf.remaining());
    }

    @Override
    public int readInt(long pos) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, pos);
        return buf.getInt(0);
    }

    @Override
    public int readInt() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)4;
        return buf.getInt(0);
    }

    @Override
    public void readFully(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter(b, "b");
        ArraysKt.copyInto(this.internalBuffer, b, off, (int)this.cursor, (int)(this.cursor + (long)len));
        GrowableSource growableSource = this;
        growableSource.cursor += (long)len;
    }

    @Override
    public int skipBytes(int n) {
        long startCursor = this.cursor;
        GrowableSource growableSource = this;
        growableSource.cursor += (long)n;
        this.cursor = RangesKt.coerceAtMost(this.cursor, this.size);
        return (int)(this.size - startCursor);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() {
        ByteBuffer buf = ByteBuffer.allocate(2);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)2;
        return buf.getShort(0);
    }

    @Override
    public int readUnsignedShort() {
        ByteBuffer buf = ByteBuffer.allocate(2);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)2;
        return buf.getShort(0) & 0xFFFF;
    }

    @Override
    public char readChar() {
        ByteBuffer buf = ByteBuffer.allocate(2);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)2;
        return buf.getChar(0);
    }

    @Override
    public long readLong() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)8;
        return buf.getLong(0);
    }

    @Override
    public float readFloat() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)4;
        return buf.getFloat(0);
    }

    @Override
    public double readDouble() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        Intrinsics.checkNotNullExpressionValue(buf, "buf");
        this.readByteBuffer(buf, this.cursor);
        GrowableSource growableSource = this;
        growableSource.cursor += (long)8;
        return buf.getDouble(0);
    }

    @Override
    @NotNull
    public String readLine() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public String readUTF() {
        short length = this.readShort();
        long start = this.cursor;
        Object object = this;
        ((GrowableSource)object).cursor += (long)length;
        if (this.cursor > this.size) {
            throw new EOFException();
        }
        object = this.internalBuffer;
        int n = (int)start;
        short s2 = length;
        boolean bl = false;
        return new String((byte[])object, n, (int)s2, Charsets.UTF_8);
    }

    @Override
    public void write(int b) {
        this.writeByte(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter(b, "b");
        int n = off;
        int n2 = off + len;
        if (n < n2) {
            do {
                int i = n++;
                this.writeByte(b[i]);
            } while (n < n2);
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    private final void writeByteBuffer(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = byteBuffer.remaining();
        if (n < n2) {
            do {
                int i = n++;
                this.writeByte(byteBuffer.get() & 0xFF);
            } while (n < n2);
        }
    }

    @Override
    public void writeShort(int v) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).putShort(0, (short)v);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(2).putShort(0, v.toShort())");
        this.writeByteBuffer(byteBuffer);
    }

    @Override
    public void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeLong(long v) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(0, v);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(8).putLong(0, v)");
        this.writeByteBuffer(byteBuffer);
    }

    @Override
    public void writeFloat(float v) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).putFloat(0, v);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(4).putFloat(0, v)");
        this.writeByteBuffer(byteBuffer);
    }

    @Override
    public void writeDouble(double v) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putDouble(0, v);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(8).putDouble(0, v)");
        this.writeByteBuffer(byteBuffer);
    }

    @Override
    public void writeChars(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        String string = s2;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeChar(c);
        }
    }

    @Override
    public void writeUTF(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        this.writeShort(s2.length());
        String string = s2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        this.write(byArray);
    }

    @Override
    public void close() {
        this.internalBuffer = new byte[0];
        this.cursor = 0L;
        this.size = 0L;
    }
}

