/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.antlr.SNBTBaseVisitor;
import org.jglrxavpok.hephaistos.antlr.SNBTParser;
import org.jglrxavpok.hephaistos.nbt.CompoundBuilder;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTByte;
import org.jglrxavpok.hephaistos.nbt.NBTInt;
import org.jglrxavpok.hephaistos.nbt.NBTLong;
import org.jglrxavpok.hephaistos.nbt.NBTString;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020$H\u0016\u00a8\u0006%"}, d2={"Lorg/jglrxavpok/hephaistos/SNBTParsingVisitor;", "Lorg/jglrxavpok/hephaistos/antlr/SNBTBaseVisitor;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "()V", "aggregateResult", "aggregate", "nextResult", "unescape", "", "str", "visitByteArray", "ctx", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$ByteArrayContext;", "visitByteNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$ByteNBTContext;", "visitCompound", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$CompoundContext;", "visitDoubleNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$DoubleNBTContext;", "visitFloatNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$FloatNBTContext;", "visitIdentifier", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$IdentifierContext;", "visitIntArray", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$IntArrayContext;", "visitIntNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$IntNBTContext;", "visitList", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$ListContext;", "visitLongArray", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$LongArrayContext;", "visitLongNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$LongNBTContext;", "visitShortNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$ShortNBTContext;", "visitStringNBT", "Lorg/jglrxavpok/hephaistos/antlr/SNBTParser$StringNBTContext;", "common"})
public final class SNBTParsingVisitor
extends SNBTBaseVisitor<NBT> {
    @NotNull
    public static final SNBTParsingVisitor INSTANCE = new SNBTParsingVisitor();

    private SNBTParsingVisitor() {
    }

    @Override
    @Nullable
    protected NBT aggregateResult(@Nullable NBT aggregate, @Nullable NBT nextResult) {
        NBT nBT;
        if (aggregate == null && nextResult != null) {
            nBT = nextResult;
        } else if (aggregate != null && nextResult == null) {
            nBT = aggregate;
        } else if (aggregate == null && nextResult == null) {
            nBT = null;
        } else {
            String string = "Can't merge " + aggregate + " and " + nextResult;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return nBT;
    }

    @Override
    @NotNull
    public NBT visitCompound(@NotNull SNBTParser.CompoundContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        NBT.Companion this_$iv = NBT.Companion;
        boolean $i$f$Kompound = false;
        return this_$iv.Compound(new CompoundBuilder(ctx){
            final /* synthetic */ SNBTParser.CompoundContext $ctx$inlined;
            {
                this.$ctx$inlined = compoundContext;
            }

            public final void run(@NotNull MutableNBTCompound it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MutableNBTCompound $this$visitCompound_u24lambda_u2d1 = it;
                boolean bl = false;
                List<SNBTParser.NamedElementContext> list2 = this.$ctx$inlined.namedElement();
                Intrinsics.checkNotNullExpressionValue(list2, "ctx.namedElement()");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SNBTParser.NamedElementContext it2 = (SNBTParser.NamedElementContext)element$iv;
                    boolean bl2 = false;
                    T t2 = SNBTParsingVisitor.INSTANCE.visit(it2.name);
                    if (t2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jglrxavpok.hephaistos.nbt.NBTString");
                    }
                    String string = ((NBTString)t2).getValue();
                    t2 = SNBTParsingVisitor.INSTANCE.visit(it2.value);
                    Intrinsics.checkNotNullExpressionValue(t2, "visit(it.value)");
                    $this$visitCompound_u24lambda_u2d1.set(string, (NBT)t2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBT visitList(@NotNull SNBTParser.ListContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        List<SNBTParser.ElementContext> list2 = ctx.element();
        Intrinsics.checkNotNullExpressionValue(list2, "ctx.element()");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SNBTParser.ElementContext elementContext = (SNBTParser.ElementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            NBT nBT = (NBT)INSTANCE.visit((ParseTree)it);
            collection.add(nBT);
        }
        List elements = (List)destination$iv$iv;
        NBTType<NBTString> subtagType = elements.isEmpty() ? NBTType.TAG_String : ((NBT)elements.get(0)).getID();
        return NBT.Companion.List(subtagType, elements);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBT visitByteArray(@NotNull SNBTParser.ByteArrayContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        List<SNBTParser.ByteNBTContext> list2 = ctx.byteNBT();
        Intrinsics.checkNotNullExpressionValue(list2, "ctx.byteNBT()");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SNBTParser.ByteNBTContext byteNBTContext = (SNBTParser.ByteNBTContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Byte by = ((Number)((NBTByte)INSTANCE.visitByteNBT((SNBTParser.ByteNBTContext)it)).getValue()).byteValue();
            collection.add(by);
        }
        byte[] array = CollectionsKt.toByteArray((List)destination$iv$iv);
        return NBT.Companion.ByteArray(Arrays.copyOf(array, array.length));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBT visitIntArray(@NotNull SNBTParser.IntArrayContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        List<SNBTParser.IntNBTContext> list2 = ctx.intNBT();
        Intrinsics.checkNotNullExpressionValue(list2, "ctx.intNBT()");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SNBTParser.IntNBTContext intNBTContext = (SNBTParser.IntNBTContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Integer n = ((Number)((NBTInt)INSTANCE.visitIntNBT((SNBTParser.IntNBTContext)it)).getValue()).intValue();
            collection.add(n);
        }
        int[] array = CollectionsKt.toIntArray((List)destination$iv$iv);
        return NBT.Companion.IntArray(Arrays.copyOf(array, array.length));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBT visitLongArray(@NotNull SNBTParser.LongArrayContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        List<SNBTParser.LongNBTContext> list2 = ctx.longNBT();
        Intrinsics.checkNotNullExpressionValue(list2, "ctx.longNBT()");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SNBTParser.LongNBTContext longNBTContext = (SNBTParser.LongNBTContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Long l = ((Number)((NBTLong)INSTANCE.visitLongNBT((SNBTParser.LongNBTContext)it)).getValue()).longValue();
            collection.add(l);
        }
        long[] array = CollectionsKt.toLongArray((List)destination$iv$iv);
        return NBT.Companion.LongArray(Arrays.copyOf(array, array.length));
    }

    @Override
    @NotNull
    public NBT visitDoubleNBT(@NotNull SNBTParser.DoubleNBTContext ctx) {
        String string;
        String text;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                string = text = ctx.getText();
                Intrinsics.checkNotNullExpressionValue(string, "text");
                if (StringsKt.endsWith$default((CharSequence)string, 'd', false, 2, null)) break block2;
                string = text;
                Intrinsics.checkNotNullExpressionValue(string, "text");
                if (!StringsKt.endsWith$default((CharSequence)string, 'D', false, 2, null)) break block3;
            }
            string = text;
            Intrinsics.checkNotNullExpressionValue(string, "text");
            text = StringsKt.dropLast(string, 1);
        }
        string = text;
        Intrinsics.checkNotNullExpressionValue(string, "text");
        boolean bl = false;
        return NBT.Companion.Double(Double.parseDouble(string));
    }

    @Override
    @NotNull
    public NBT visitFloatNBT(@NotNull SNBTParser.FloatNBTContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String string = ctx.getText();
        Intrinsics.checkNotNullExpressionValue(string, "ctx.text");
        string = StringsKt.dropLast(string, 1);
        boolean bl = false;
        return NBT.Companion.Float(Float.parseFloat(string));
    }

    @Override
    @NotNull
    public NBT visitLongNBT(@NotNull SNBTParser.LongNBTContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String string = ctx.LONG().getText();
        Intrinsics.checkNotNullExpressionValue(string, "ctx.LONG().text");
        string = StringsKt.dropLast(string, 1);
        boolean bl = false;
        long value = Long.parseLong(string);
        return NBT.Companion.Long(value);
    }

    @Override
    @NotNull
    public NBT visitByteNBT(@NotNull SNBTParser.ByteNBTContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        TerminalNode terminalNode = ctx.BOOLEAN();
        if (terminalNode != null) {
            TerminalNode terminalNode2 = terminalNode;
            boolean bl = false;
            boolean bl2 = false;
            TerminalNode it = terminalNode2;
            boolean bl3 = false;
            boolean booleanValue = Intrinsics.areEqual(ctx.BOOLEAN().getText(), "true");
            return NBT.Companion.Boolean(booleanValue);
        }
        String string = ctx.BYTE().getText();
        Intrinsics.checkNotNullExpressionValue(string, "ctx.BYTE().text");
        string = StringsKt.dropLast(string, 1);
        boolean bl = false;
        byte value = Byte.parseByte(string);
        return NBT.Companion.Byte(value);
    }

    @Override
    @NotNull
    public NBT visitShortNBT(@NotNull SNBTParser.ShortNBTContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String string = ctx.SHORT().getText();
        Intrinsics.checkNotNullExpressionValue(string, "ctx.SHORT().text");
        string = StringsKt.dropLast(string, 1);
        boolean bl = false;
        short value = Short.parseShort(string);
        return NBT.Companion.Short(value);
    }

    private final String unescape(String str) {
        boolean escaped = false;
        StringBuilder buffer = new StringBuilder();
        int toSkip = 0;
        String string = str;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            int index = i;
            char c = string.charAt(i);
            if (toSkip > 0) {
                n2 = toSkip;
                toSkip = n2 + -1;
                continue;
            }
            if (escaped) {
                n2 = c;
                if ((n2 == 92 ? true : n2 == 34) ? true : n2 == 39) {
                    buffer.append(c);
                    escaped = false;
                    continue;
                }
                if (n2 == 110) {
                    buffer.append('\n');
                    escaped = false;
                    continue;
                }
                if (n2 == 114) {
                    buffer.append('\r');
                    escaped = false;
                    continue;
                }
                if (n2 == 98) {
                    buffer.append('\b');
                    escaped = false;
                    continue;
                }
                if (n2 == 117) {
                    if (index + 4 >= str.length()) {
                        String string2 = "Not enough characters for Unicode escape sequence";
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    buffer.append(Character.toChars(Integer.parseInt(StringsKt.substring(str, new IntRange(index + 1, index + 4)), 16)));
                    toSkip = 4;
                    escaped = false;
                    continue;
                }
                String string3 = Intrinsics.stringPlus("Unrecognized escape sequence: \\", Character.valueOf(c));
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            buffer.append(c);
        }
        string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
        return string;
    }

    @Override
    @NotNull
    public NBT visitStringNBT(@NotNull SNBTParser.StringNBTContext ctx) {
        NBT nBT;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (ctx.DoubleQuoteText() != null) {
            String string = ctx.DoubleQuoteText().getText();
            Intrinsics.checkNotNullExpressionValue(string, "ctx.DoubleQuoteText().text");
            nBT = NBT.Companion.String(this.unescape(StringsKt.dropLast(StringsKt.drop(string, 1), 1)));
        } else if (ctx.SingleQuoteText() != null) {
            String string = ctx.SingleQuoteText().getText();
            Intrinsics.checkNotNullExpressionValue(string, "ctx.SingleQuoteText().text");
            nBT = NBT.Companion.String(this.unescape(StringsKt.dropLast(StringsKt.drop(string, 1), 1)));
        } else {
            String string = ctx.getText();
            Intrinsics.checkNotNullExpressionValue(string, "ctx.text");
            nBT = NBT.Companion.String(string);
        }
        return nBT;
    }

    @Override
    @NotNull
    public NBT visitIntNBT(@NotNull SNBTParser.IntNBTContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String string = ctx.INTEGER().getText();
        Intrinsics.checkNotNullExpressionValue(string, "ctx.INTEGER().text");
        boolean bl = false;
        return NBT.Companion.Int(Integer.parseInt(string));
    }

    @Override
    @Nullable
    public NBT visitIdentifier(@Nullable SNBTParser.IdentifierContext ctx) {
        String string = "Should not access this rule directly";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }
}

