/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\"\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J9\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J*\u0010\u001a\u001a\u00020\u0004\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u001c\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J:\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010!\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\"\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J@\u0010#\u001a\u00020\u0004\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J8\u0010'\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u001e\u0010(\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0006\u0012\u0004\u0018\u00010*0)0\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010+\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016JN\u0010,\u001a\u00020\u0004\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0006H\u0016JW\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00132\u001e\u00103\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0006\u0012\u0004\u0018\u00010*0)0\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00105J$\u00106\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u00067"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "concat", "", "separator", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expr", "", "Lorg/jetbrains/exposed/sql/Expression;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/QueryBuilder;[Lorg/jetbrains/exposed/sql/Expression;)V", "day", "T", "delete", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "limit", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "groupConcat", "Lorg/jetbrains/exposed/sql/GroupConcat;", "hour", "insert", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "minute", "month", "regexp", "expr1", "pattern", "caseSensitive", "replace", "data", "Lkotlin/Pair;", "", "second", "substring", "start", "length", "builder", "prefix", "update", "target", "columnsAndValues", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "year", "exposed-core"})
public final class SQLiteFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final SQLiteFunctionProvider INSTANCE = new SQLiteFunctionProvider();

    private SQLiteFunctionProvider() {
    }

    @Override
    public <T extends String> void substring(@NotNull Expression<T> expr, @NotNull Expression<Integer> start, @NotNull Expression<Integer> length, @NotNull QueryBuilder builder, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(length, "length");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        super.substring(expr, start, length, builder, "substr");
    }

    @Override
    public void concat(@NotNull String separator, @NotNull QueryBuilder queryBuilder, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expr, "expr");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(separator, expr){
            final /* synthetic */ String $separator;
            final /* synthetic */ Expression<?>[] $expr;
            {
                this.$separator = $separator;
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                if (Intrinsics.areEqual(this.$separator, "")) {
                    ExpressionKt.appendTo$default(ArraysKt.toList(this.$expr), $this$invoke, " || ", null, null, concat.1.INSTANCE, 12, null);
                } else {
                    ExpressionKt.appendTo$default(ArraysKt.toList(this.$expr), $this$invoke, " || '" + this.$separator + "' || ", null, null, concat.2.INSTANCE, 12, null);
                }
            }
        });
    }

    @Override
    public <T extends String> void groupConcat(@NotNull GroupConcat<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Transaction tr = TransactionManager.Companion.current();
        if (!(expr.getOrderBy().length == 0)) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLite doesn't support ORDER BY in GROUP_CONCAT function.");
            throw new KotlinNothingValueException();
        }
        if (expr.getDistinct()) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLite doesn't support DISTINCT in GROUP_CONCAT function.");
            throw new KotlinNothingValueException();
        }
        super.groupConcat(expr, queryBuilder);
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, "expr1");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "SQLite doesn't provide built in REGEXP expression, use LIKE instead.");
        throw new KotlinNothingValueException();
    }

    @Override
    public <T> void year(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%Y',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void month(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%m',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void day(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%d',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void hour(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%H',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void minute(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%M',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void second(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("STRFTIME('%S',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.insert(false, table, columns2, expr, transaction2);
        return ignore ? StringsKt.replaceFirst$default(def, "INSERT", "INSERT OR IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String update(@NotNull Table target, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (!SQLiteDialect.Companion.getENABLE_UPDATE_DELETE_LIMIT() && limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "SQLite doesn't support LIMIT in UPDATE clause.");
            throw new KotlinNothingValueException();
        }
        return super.update(target, columnsAndValues, limit, where, transaction2);
    }

    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data2, @NotNull Transaction transaction2) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        QueryBuilder builder = new QueryBuilder(true);
        String columns2 = CollectionsKt.joinToString$default(data2, null, null, null, 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, CharSequence>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<? extends Column<?>, ? extends Object> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$transaction.identity(it.getFirst());
            }
        }, 31, null);
        QueryBuilder $this$replace_u24lambda_u240 = queryBuilder = builder;
        boolean bl = false;
        QueryBuilder.appendTo$default($this$replace_u24lambda_u240, data2, null, null, null, (Function2)replace.values.1.1.INSTANCE, 7, null);
        String values2 = queryBuilder.toString();
        return "INSERT OR REPLACE INTO " + transaction2.identity(table) + " (" + columns2 + ") VALUES (" + values2 + ')';
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (!SQLiteDialect.Companion.getENABLE_UPDATE_DELETE_LIMIT() && limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "SQLite doesn't support LIMIT in DELETE clause.");
            throw new KotlinNothingValueException();
        }
        String def = super.delete(false, table, where, limit, transaction2);
        return ignore ? StringsKt.replaceFirst$default(def, "DELETE", "DELETE OR IGNORE", false, 4, null) : def;
    }
}

