/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J9\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J*\u0010\u0016\u001a\u00020\u0004\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0018\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0019\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u001a\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0016J \u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0016J\u0017\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010&J@\u0010'\u001a\u00020\u0004\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010*\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010+\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JW\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.2\u001e\u0010/\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000302\u0012\u0006\u0012\u0004\u0018\u00010301002\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u0001042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u00105JW\u0010,\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000f2\u001e\u0010/\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000302\u0012\u0006\u0012\u0004\u0018\u00010301002\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u0001042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u00107J$\u00108\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u00069"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "day", "", "T", "expr", "Lorg/jetbrains/exposed/sql/Expression;", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "delete", "", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "limit", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "groupConcat", "Lorg/jetbrains/exposed/sql/GroupConcat;", "hour", "minute", "month", "nextVal", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "builder", "queryLimit", "size", "offset", "", "alreadyOrdered", "random", "seed", "(Ljava/lang/Integer;)Ljava/lang/String;", "regexp", "expr1", "pattern", "caseSensitive", "second", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "target", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "year", "exposed-core"})
public final class SQLServerFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final SQLServerFunctionProvider INSTANCE = new SQLServerFunctionProvider();

    private SQLServerFunctionProvider() {
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(seq){
            final /* synthetic */ Sequence $seq;
            {
                this.$seq = $seq;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"NEXT VALUE FOR ", this.$seq.getIdentifier()};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    @NotNull
    public String random(@Nullable Integer seed) {
        return seed != null ? "RAND(" + seed + ')' : "RAND(CHECKSUM(NEWID()))";
    }

    @Override
    public <T extends String> void groupConcat(@NotNull GroupConcat<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Transaction tr = TransactionManager.Companion.current();
        if (expr.getSeparator() == null) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLServer requires explicit separator in STRING_AGG.");
            throw new KotlinNothingValueException();
        }
        if (expr.getOrderBy().length > 1) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLServer supports only single column in ORDER BY clause in STRING_AGG.");
            throw new KotlinNothingValueException();
        }
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ GroupConcat<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    $this$invoke.append("STRING_AGG(");
                    $this$invoke.append(this.$expr.getExpr());
                    $this$invoke.append(", '" + this.$expr.getSeparator() + "')");
                    Pair<Expression<?>, SortOrder> pair = ArraysKt.singleOrNull(this.$expr.getOrderBy());
                    if (pair == null) break block0;
                    Pair<Expression<?>, SortOrder> pair2 = pair;
                    boolean bl = false;
                    Expression<?> col = pair2.component1();
                    SortOrder order = pair2.component2();
                    Object[] objectArray = new Object[]{" WITHIN GROUP (ORDER BY ", col, " ", order.name(), ")"};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            }
        });
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, "expr1");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "SQLServer doesn't provide built in REGEXP expression, use LIKE instead.");
        throw new KotlinNothingValueException();
    }

    @Override
    public <T> void year(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(YEAR, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void month(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(MONTH, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void day(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(DAY, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void hour(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(HOUR, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void second(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(SECOND, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void minute(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"DATEPART(MINUTE, ", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    @NotNull
    public String update(@NotNull Table target, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.update(target, columnsAndValues, null, where, transaction2);
        return limit != null ? StringsKt.replaceFirst$default(def, "UPDATE", "UPDATE TOP(" + limit + ')', false, 4, null) : def;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        QueryBuilder $this$update_u24lambda_u244;
        block10: {
            boolean bl;
            Table tableToUpdate;
            block9: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(targets, "targets");
                Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                $this$update_u24lambda_u244 = new QueryBuilder(true);
                boolean bl2 = false;
                Iterable $this$map$iv = columnsAndValues;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(((Column)it.getFirst()).getTable());
                }
                Table table = (Table)CollectionsKt.singleOrNull(CollectionsKt.distinct((List)destination$iv$iv));
                if (table == null) {
                    ExceptionsKt.throwUnsupportedException(transaction2, "SQLServer supports a join updates with a single table columns to update.");
                    throw new KotlinNothingValueException();
                }
                tableToUpdate = table;
                Iterable $this$any$iv = targets.getJoinParts$exposed_core();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Join.JoinPart it = (Join.JoinPart)element$iv;
                        boolean bl4 = false;
                        if (!(it.getJoinType() != JoinType.INNER)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            if (limit != null) {
                $this$update_u24lambda_u244.unaryPlus("UPDATE TOP(" + limit + ')');
            } else {
                $this$update_u24lambda_u244.unaryPlus("UPDATE ");
            }
            tableToUpdate.describe(transaction2, $this$update_u24lambda_u244);
            $this$update_u24lambda_u244.unaryPlus(" SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u244, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(2);
                }

                public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> pair) {
                    Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                    Intrinsics.checkNotNullParameter(pair, "<name for destructuring parameter 0>");
                    Column<?> col = pair.component1();
                    Object value = pair.component2();
                    $this$appendTo.append(this.$transaction.fullIdentity(col) + '=');
                    $this$appendTo.registerArgument(col, value);
                }
            }, 14, null);
            INSTANCE.appendJoinPartForUpdateClause($this$update_u24lambda_u244, tableToUpdate, targets, transaction2);
            Op<Boolean> op = where;
            if (op != null) {
                Op<Boolean> it = op;
                boolean bl5 = false;
                $this$update_u24lambda_u244.unaryPlus(" AND ");
                $this$update_u24lambda_u244.unaryPlus((Expression)it);
            }
            Integer n = limit;
            if (n == null) break block10;
            int it = ((Number)n).intValue();
            boolean bl6 = false;
            $this$update_u24lambda_u244.unaryPlus(" LIMIT " + it);
        }
        return $this$update_u24lambda_u244.toString();
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.delete(ignore, table, where, null, transaction2);
        return limit != null ? StringsKt.replaceFirst$default(def, "DELETE", "DELETE TOP(" + limit + ')', false, 4, null) : def;
    }

    @Override
    @NotNull
    public String queryLimit(int size, long offset, boolean alreadyOrdered) {
        return (alreadyOrdered ? "" : " ORDER BY(SELECT NULL)") + " OFFSET " + offset + " ROWS FETCH NEXT " + size + " ROWS ONLY";
    }
}

