/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J(\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0014J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0016J\u0014\u0010&\u001a\u00020\r2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\"\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u00061"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "nonAcceptableDefaults", "", "", "[Ljava/lang/String;", "supportsIfNotExists", "getSupportsIfNotExists", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "createDatabase", "name", "createIndexWithType", "table", "columns", "type", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    @NotNull
    private final String[] nonAcceptableDefaults;
    @NotNull
    private final Map<Character, Character> likePatternSpecialChars;
    @NotNull
    private static final Map<Character, Character> sqlServerLikePatternSpecialChars;

    public SQLServerDialect() {
        super(Companion.getDialectName(), SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[]{"DEFAULT"};
        this.nonAcceptableDefaults = stringArray;
        this.likePatternSpecialChars = sqlServerLikePatternSpecialChars;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        String string = e.toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String columnDefault = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains(this.nonAcceptableDefaults, columnDefault);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, "MODIFY COLUMN", "ALTER COLUMN", false, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "CREATE DATABASE " + DefaultKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "DROP DATABASE " + DefaultKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u241, stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u241, " AUTHORIZATION ", schema.getAuthorization());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$dropSchema_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP SCHEMA ", schema.getIdentifier()};
        StringsKt.append($this$dropSchema_u24lambda_u242, stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u242.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name2, @NotNull String table, @NotNull String columns2, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type2, "type");
        return "CREATE " + type2 + " INDEX " + name2 + " ON " + table + ' ' + columns2;
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return this.likePatternSpecialChars;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('%'), null), TuplesKt.to(Character.valueOf('_'), null), TuplesKt.to(Character.valueOf('['), Character.valueOf(']'))};
        sqlServerLikePatternSpecialChars = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "sqlServerLikePatternSpecialChars", "", "", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("sqlserver");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

