/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\u0014\u0010\u001d\u001a\u00020\u00042\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0006\u0010 \u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "Lkotlin/Lazy;", "supportsCreateSequence", "getSupportsCreateSequence", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "createSchema", "", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropIndex", "tableName", "indexName", "dropSchema", "cascade", "fillConstraintCacheForTables", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "setSchema", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(isMysql8.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        String[] stringArray = new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP()", "NOW()", "CURRENT_TIMESTAMP(6)", "NOW(6)"};
        String[] acceptableDefaults = stringArray;
        return ArraysKt.contains(acceptableDefaults, ((Object)StringsKt.trim((CharSequence)e.toString())).toString()) && this.isFractionDateTimeSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.nameInDatabaseCase(), element$iv$iv);
        }
        Map allTables = destination$iv$iv;
        Set<String> allTableNames = allTables.keySet();
        String inTableList = CollectionsKt.joinToString$default(allTableNames, "','", " ku.TABLE_NAME IN ('", "')", 0, null, null, 56, null);
        Transaction tr = TransactionManager.Companion.current();
        String schemaName = '\'' + this.getDatabase() + '\'';
        HashMap<String, Map<String, ForeignKeyConstraint>> constraintsToLoad = new HashMap<String, Map<String, ForeignKeyConstraint>>();
        Transaction.exec$default(tr, StringsKt.trimIndent("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + schemaName + "\n                  AND ku.CONSTRAINT_SCHEMA = " + schemaName + "\n                  AND rc.CONSTRAINT_SCHEMA = " + schemaName + "\n                  AND " + inTableList + "\n                ORDER BY ku.ORDINAL_POSITION\n            "), null, null, new Function1<ResultSet, Unit>(allTableNames, this, tr, (Map<String, ? extends Table>)allTables, constraintsToLoad){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, Map<String, ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = $allTableNames;
                this.this$0 = $receiver;
                this.$tr = $tr;
                this.$allTables = $allTables;
                this.$constraintsToLoad = $constraintsToLoad;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultSet rs) {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Column column;
                Map fromTableName;
                Intrinsics.checkNotNullParameter(rs, "rs");
                while (rs.next()) {
                    String constraintName;
                    Object object;
                    T element$iv3;
                    Column fromColumn;
                    Object object2;
                    block7: {
                        String targetTableName;
                        Object v1;
                        Column $this$firstOrNull$iv;
                        Transaction transaction2;
                        MysqlDialect mysqlDialect;
                        block6: {
                            Intrinsics.checkNotNull(rs.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(fromTableName)) continue;
                            String string = rs.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull(string);
                            String fromColumnName = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, this.$tr);
                            Iterable iterable = MapsKt.getValue(this.$allTables, fromTableName).getColumns();
                            mysqlDialect = this.this$0;
                            transaction2 = this.$tr;
                            boolean $i$f$firstOrNull = false;
                            object2 = $this$firstOrNull$iv.iterator();
                            while (object2.hasNext()) {
                                T element$iv2 = object2.next();
                                Column it = (Column)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), fromColumnName)) continue;
                                v1 = element$iv2;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((column = (Column)v1) == null) continue;
                        $this$firstOrNull$iv = column;
                        mysqlDialect = this.this$0;
                        transaction2 = this.$tr;
                        Map<String, Table> $i$f$firstOrNull = this.$allTables;
                        object2 = this.$constraintsToLoad;
                        fromColumn = $this$firstOrNull$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(rs.getString("CONSTRAINT_NAME"));
                        Intrinsics.checkNotNull(rs.getString("REFERENCED_TABLE_NAME"));
                        String string = rs.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull(string);
                        String targetColumnName = mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(string, transaction2);
                        Iterable $this$first$iv = MapsKt.getValue($i$f$firstOrNull, targetTableName).getColumns();
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), targetColumnName)) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    String string = rs.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull(string);
                    ReferenceOption constraintUpdateRule = ReferenceOption.valueOf(StringsKt.replace$default(string, " ", "_", false, 4, null));
                    String string2 = rs.getString("DELETE_RULE");
                    Intrinsics.checkNotNull(string2);
                    ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default(string2, " ", "_", false, 4, null));
                    Map $this$getOrPut$iv = (Map)object2;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(fromTableName);
                    if (value$iv == null) {
                        boolean bl = false;
                        Map answer$iv = new LinkedHashMap<K, V>();
                        $this$getOrPut$iv.put(fromTableName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Map)object).merge(constraintName, new ForeignKeyConstraint(targetColumn, fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName), (arg_0, arg_1) -> fillConstraintCacheForTables.1.invoke$lambda$4$lambda$3(fillConstraintCacheForTables.2.2.INSTANCE, arg_0, arg_1));
                }
                fromTableName = this.$constraintsToLoad;
                Map<String, Collection<ForeignKeyConstraint>> map2 = this.this$0.getColumnConstraintsCache();
                boolean $i$f$mapValues = false;
                column = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    Map v = (Map)entry2.getValue();
                    Collection<V> collection = v.values();
                    map4.put(k, collection);
                }
                map2.putAll(destination$iv$iv);
            }

            private static final ForeignKeyConstraint invoke$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (ForeignKeyConstraint)$tmp0.invoke(p0, p1);
            }
        }, 6, null);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return "ALTER TABLE " + tableName + " DROP INDEX " + indexName2;
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u241, stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DefaultKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DefaultKt.getCurrentDialect());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("mysql");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

