/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "booleanFromStringToBoolean", "", "value", "dateTimeType", "largeTextType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "textType", "ubyteType", "uintegerType", "ulongType", "ushortType", "exposed-core"})
public final class MysqlDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    private MysqlDataTypeProvider() {
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String dateTimeType() {
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        return (mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false) ? "DATETIME(6)" : "DATETIME";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    @NotNull
    public String textType() {
        return "text";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    @NotNull
    public String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value;
        return Intrinsics.areEqual(string, "0") ? false : (Intrinsics.areEqual(string, "1") ? true : Boolean.parseBoolean(value));
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                ExpressionAlias expressionAlias = expression instanceof ExpressionAlias ? (ExpressionAlias)expression : null;
                if (expressionAlias == null || (expressionAlias = expressionAlias.getAlias()) == null) {
                    expressionAlias = expression;
                }
                ExpressionAlias exp = expressionAlias;
                SortOrder sortOrderAdjusted = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.DESC : SortOrder.ASC;
                Object[] objectArray = new Object[]{"-", exp, " ", sortOrderAdjusted.getCode()};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

