/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J8\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00170\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016JW\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u001e\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00170\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "insert", "", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "expr", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "nextVal", "", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "builder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "replace", "data", "Lkotlin/Pair;", "", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "limit", "", "where", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "exposed-core"})
public final class H2FunctionProvider
extends FunctionProvider {
    @NotNull
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        Intrinsics.checkNotNullParameter(builder, "builder");
        DatabaseDialect databaseDialect = TransactionManager.Companion.current().getDb().getDialect();
        Intrinsics.checkNotNull(databaseDialect, "null cannot be cast to non-null type org.jetbrains.exposed.sql.vendors.H2Dialect");
        switch (WhenMappings.$EnumSwitchMapping$0[((H2Dialect)databaseDialect).getMajorVersion$exposed_core().ordinal()]) {
            case 1: {
                super.nextVal(seq, builder);
                break;
            }
            case 2: {
                builder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(seq){
                    final /* synthetic */ Sequence $seq;
                    {
                        this.$seq = $seq;
                        super(1);
                    }

                    public final void invoke(@NotNull QueryBuilder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.append("NEXT VALUE FOR " + this.$seq.getIdentifier());
                    }
                });
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        String string;
        void $this$flatMapTo$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Set uniqueCols = new LinkedHashSet();
        Iterable $this$filter$iv = table.getIndices();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            if (!it.getUnique()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getColumns();
            CollectionsKt.addAll((Collection)uniqueCols, list$iv);
        }
        Column<?>[] columnArray = table.getPrimaryKey();
        if (columnArray != null && (columnArray = columnArray.getColumns()) != null) {
            Column<?>[] primaryKeys = columnArray;
            boolean bl = false;
            CollectionsKt.addAll((Collection)uniqueCols, primaryKeys);
        }
        DatabaseDialect databaseDialect = transaction2.getDb().getDialect();
        Intrinsics.checkNotNull(databaseDialect, "null cannot be cast to non-null type org.jetbrains.exposed.sql.vendors.H2Dialect");
        H2Dialect h2Dialect = (H2Dialect)databaseDialect;
        String version2 = h2Dialect.getVersion$exposed_core();
        boolean isMySQLMode = h2Dialect.getH2Mode() == H2Dialect.H2CompatibilityMode.MySQL;
        if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode && version2.compareTo("1.4.197") < 0) {
            String def = super.insert(false, table, columns2, expr, transaction2);
            string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default(uniqueCols, null, null, null, 0, null, new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Column<?> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$transaction.identity(it) + "=VALUES(" + this.$transaction.identity(it) + ')';
                }
            }, 31, null);
        } else if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode) {
            string = StringsKt.replace$default(super.insert(false, table, columns2, expr, transaction2), "INSERT", "INSERT IGNORE", false, 4, null);
        } else {
            if (ignore) {
                ExceptionsKt.throwUnsupportedException(transaction2, "INSERT IGNORE supported only on H2 v1.4.197+ with MODE=MYSQL.");
                throw new KotlinNothingValueException();
            }
            string = super.insert(ignore, table, columns2, expr, transaction2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        QueryBuilder $this$update_u24lambda_u246;
        block6: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(targets, "targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            $this$update_u24lambda_u246 = new QueryBuilder(true);
            boolean bl = false;
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Column)it.getFirst()).getTable());
            }
            Table table = (Table)CollectionsKt.singleOrNull(CollectionsKt.distinct((List)destination$iv$iv));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            Table tableToUpdate = table;
            Join.JoinPart joinPart = CollectionsKt.singleOrNull(targets.getJoinParts$exposed_core());
            if (joinPart == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with only one table to join.");
                throw new KotlinNothingValueException();
            }
            Join.JoinPart joinPart2 = joinPart;
            if (joinPart2.getJoinType() != JoinType.INNER) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            $this$update_u24lambda_u246.unaryPlus("MERGE INTO ");
            tableToUpdate.describe(transaction2, $this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" USING ");
            ColumnSet it = $i$f$map = joinPart2.getJoinPart();
            boolean bl3 = false;
            ColumnSet columnSet = !Intrinsics.areEqual(it, tableToUpdate) ? $i$f$map : null;
            if (columnSet == null) {
                columnSet = targets.getTable();
            }
            columnSet.describe(transaction2, $this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" ON ");
            joinPart2.appendConditions($this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u246, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(2);
                }

                public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> pair) {
                    Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                    Intrinsics.checkNotNullParameter(pair, "<name for destructuring parameter 0>");
                    Column<?> col = pair.component1();
                    Object value = pair.component2();
                    $this$appendTo.append(this.$transaction.fullIdentity(col) + '=');
                    $this$appendTo.registerArgument(col, value);
                }
            }, 14, null);
            Op<Boolean> op = where;
            if (op == null) break block6;
            Op<Boolean> it2 = op;
            boolean bl4 = false;
            $this$update_u24lambda_u246.unaryPlus(" WHERE ");
            $this$update_u24lambda_u246.unaryPlus((Expression)it2);
        }
        return $this$update_u24lambda_u246.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data2, @NotNull Transaction transaction2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (data2.isEmpty()) {
            return "";
        }
        Iterable $this$map$iv = data2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Column)it.getFirst());
        }
        List columns2 = (List)destination$iv$iv;
        QueryBuilder builder = new QueryBuilder(true);
        String sql2 = ExpressionKt.appendTo$default(data2, builder, null, "VALUES (", ")", replace.sql.1.INSTANCE, 2, null).toString();
        return StringsKt.replaceFirst$default(super.insert(false, table, columns2, sql2, transaction2), "INSERT", "MERGE", false, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2MajorVersion.values().length];
            try {
                nArray[H2Dialect.H2MajorVersion.One.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2MajorVersion.Two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

