/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 _2\u00020\u0001:\u0001_J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001400H&J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u000206H\u0016JW\u00107\u001a8\u0012(\u0012&\u0012\u0004\u0012\u000206\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030:09j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:`;08\u0012\n\u0012\b\u0012\u0004\u0012\u00020<000\u000f2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u0002060>\"\u000206H\u0016\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020CH&J\u0010\u0010D\u001a\u00020\u00142\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0014H&J\u0018\u0010K\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\u0006\u0010L\u001a\u00020\u0018H\u0016J3\u0010M\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020C000\u000f2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u0002060>\"\u000206H\u0016\u00a2\u0006\u0002\u0010?J\b\u0010N\u001a\u00020\u0014H&J\u0014\u0010O\u001a\u00020\u00182\n\u0010P\u001a\u0006\u0012\u0002\b\u00030QH\u0016J\"\u0010R\u001a\b\u0012\u0004\u0012\u00020\u0014002\n\u0010S\u001a\u0006\u0012\u0002\b\u00030:2\u0006\u0010T\u001a\u00020UH&J\b\u0010V\u001a\u00020WH&J\b\u0010X\u001a\u00020WH&J\u0010\u0010Y\u001a\u00020\u00182\u0006\u0010E\u001a\u00020FH&J\u0010\u0010Z\u001a\u00020\u00142\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010[\u001a\u00020\u0018H&J3\u0010\\\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020]000\u000f2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u0002060>\"\u000206H\u0016\u00a2\u0006\u0002\u0010?J\u0010\u0010^\u001a\u00020\u00182\u0006\u00105\u001a\u000206H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001aR\u0014\u0010!\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0014\u0010#\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001aR\u0012\u0010%\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001aR\u0014\u0010'\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001aR\u0014\u0010)\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0014\u0010+\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001aR\u0014\u0010-\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001a\u00a8\u0006`"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "name", "", "getName", "()Ljava/lang/String;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsCreateSchema", "getSupportsCreateSchema", "supportsCreateSequence", "getSupportsCreateSequence", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "allTablesNames", "", "catalog", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "checkTableMapping", "table", "Lorg/jetbrains/exposed/sql/Table;", "columnConstraints", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "dropSchema", "cascade", "existingIndices", "getDatabase", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "column", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resetCaches", "", "resetSchemaCaches", "schemaExists", "setSchema", "supportsSelectForUpdate", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "Companion", "exposed-core"})
public interface DatabaseDialect {
    @NotNull
    public static final Companion Companion = org.jetbrains.exposed.sql.vendors.DatabaseDialect$Companion.$$INSTANCE;

    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    public boolean getSupportsIfNotExists();

    public boolean getSupportsCreateSequence();

    public boolean getNeedsSequenceToAutoInc();

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean getSupportsSequenceAsGeneratedKeys();

    public boolean getSupportsOnlyIdentifiersInGeneratedKeys();

    public boolean getSupportsCreateSchema();

    public boolean getSupportsSubqueryUnions();

    public boolean getSupportsDualTableConcept();

    public boolean getSupportsOrderByNullsFirstLast();

    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars();

    @NotNull
    public String getDatabase();

    @NotNull
    public List<String> allTablesNames();

    public boolean tableExists(@NotNull Table var1);

    public boolean schemaExists(@NotNull Schema var1);

    public boolean checkTableMapping(@NotNull Table var1);

    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... var1);

    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... var1);

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... var1);

    public boolean supportsSelectForUpdate();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    @NotNull
    public String catalog(@NotNull Transaction var1);

    public void resetCaches();

    public void resetSchemaCaches();

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2);

    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> var1, @NotNull ColumnDiff var2);

    @NotNull
    public String createDatabase(@NotNull String var1);

    @NotNull
    public String dropDatabase(@NotNull String var1);

    @NotNull
    public String setSchema(@NotNull Schema var1);

    @NotNull
    public String createSchema(@NotNull Schema var1);

    @NotNull
    public String dropSchema(@NotNull Schema var1, boolean var2);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect$Companion;", "", "()V", "defaultLikePatternSpecialChars", "", "", "", "exposed-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Map defaultLikePatternSpecialChars;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('%'), null), TuplesKt.to(Character.valueOf('_'), null)};
            defaultLikePatternSpecialChars = MapsKt.mapOf(pairArray);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean getSupportsIfNotExists(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsCreateSequence(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(@NotNull DatabaseDialect $this) {
            return false;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(@NotNull DatabaseDialect $this) {
            return ReferenceOption.RESTRICT;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsSequenceAsGeneratedKeys(@NotNull DatabaseDialect $this) {
            return $this.getSupportsCreateSequence();
        }

        public static boolean getSupportsOnlyIdentifiersInGeneratedKeys(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsCreateSchema(@NotNull DatabaseDialect $this) {
            return true;
        }

        public static boolean getSupportsSubqueryUnions(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsDualTableConcept(@NotNull DatabaseDialect $this) {
            return false;
        }

        public static boolean getSupportsOrderByNullsFirstLast(@NotNull DatabaseDialect $this) {
            return false;
        }

        @NotNull
        public static Map<Character, Character> getLikePatternSpecialChars(@NotNull DatabaseDialect $this) {
            return org.jetbrains.exposed.sql.vendors.DatabaseDialect$Companion.defaultLikePatternSpecialChars;
        }

        public static boolean checkTableMapping(@NotNull DatabaseDialect $this, @NotNull Table table) {
            Intrinsics.checkNotNullParameter(table, "table");
            return true;
        }

        @NotNull
        public static Map<Table, List<ColumnMetadata>> tableColumns(@NotNull DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(@NotNull DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Table, List<Index>> existingIndices(@NotNull DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            return MapsKt.emptyMap();
        }

        public static boolean isAllowedAsColumnDefault(@NotNull DatabaseDialect $this, @NotNull Expression<?> e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return e instanceof LiteralOp;
        }

        @NotNull
        public static String catalog(@NotNull DatabaseDialect $this, @NotNull Transaction transaction2) {
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            return transaction2.getConnection().getCatalog();
        }

        @NotNull
        public static String createDatabase(@NotNull DatabaseDialect $this, @NotNull String name2) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return "CREATE DATABASE IF NOT EXISTS " + DefaultKt.inProperCase(name2);
        }

        @NotNull
        public static String dropDatabase(@NotNull DatabaseDialect $this, @NotNull String name2) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return "DROP DATABASE IF EXISTS " + DefaultKt.inProperCase(name2);
        }

        @NotNull
        public static String setSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema) {
            Intrinsics.checkNotNullParameter(schema, "schema");
            return "SET SCHEMA " + schema.getIdentifier();
        }

        @NotNull
        public static String createSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(schema, "schema");
            StringBuilder $this$createSchema_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createSchema_u24lambda_u240.append("CREATE SCHEMA IF NOT EXISTS ");
            $this$createSchema_u24lambda_u240.append(schema.getIdentifier());
            SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u240, " AUTHORIZATION ", schema.getAuthorization());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public static String dropSchema(@NotNull DatabaseDialect $this, @NotNull Schema schema, boolean cascade) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(schema, "schema");
            StringBuilder $this$dropSchema_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String[] stringArray = new String[]{"DROP SCHEMA IF EXISTS ", schema.getIdentifier()};
            StringsKt.append($this$dropSchema_u24lambda_u241, stringArray);
            if (cascade) {
                $this$dropSchema_u24lambda_u241.append(" CASCADE");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

