/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.NotInitializedManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H&J(\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0014H&R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0005\"\u0004\b\u0010\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "defaultReadOnly", "", "getDefaultReadOnly", "()Z", "setDefaultReadOnly", "(Z)V", "defaultRepetitionAttempts", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "bindTransactionToThread", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "currentOrNull", "newTransaction", "isolation", "readOnly", "outerTransaction", "Companion", "exposed-core"})
public interface TransactionManager {
    @NotNull
    public static final Companion Companion = org.jetbrains.exposed.sql.transactions.TransactionManager$Companion.$$INSTANCE;

    public int getDefaultIsolationLevel();

    public void setDefaultIsolationLevel(int var1);

    public boolean getDefaultReadOnly();

    public void setDefaultReadOnly(boolean var1);

    public int getDefaultRepetitionAttempts();

    public void setDefaultRepetitionAttempts(int var1);

    @NotNull
    public Transaction newTransaction(int var1, boolean var2, @Nullable Transaction var3);

    @Nullable
    public Transaction currentOrNull();

    public void bindTransactionToThread(@Nullable Transaction var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u001cJ\u0006\u0010!\u001a\u00020\"J\u0012\u0010#\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u0016\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010%\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion;", "", "()V", "currentDefaultDatabase", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/exposed/sql/Database;", "getCurrentDefaultDatabase$exposed_core", "()Ljava/util/concurrent/atomic/AtomicReference;", "currentThreadManager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion$TransactionManagerThreadLocal;", "databases", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "value", "defaultDatabase", "getDefaultDatabase", "()Lorg/jetbrains/exposed/sql/Database;", "setDefaultDatabase", "(Lorg/jetbrains/exposed/sql/Database;)V", "manager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "getManager", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "registeredDatabases", "Ljava/util/concurrent/ConcurrentHashMap;", "closeAndUnregister", "", "database", "current", "Lorg/jetbrains/exposed/sql/Transaction;", "currentOrNew", "isolation", "", "currentOrNull", "isInitialized", "", "managerFor", "registerManager", "resetCurrent", "TransactionManagerThreadLocal", "exposed-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final AtomicReference<Database> currentDefaultDatabase;
        @NotNull
        private static final ConcurrentLinkedDeque<Database> databases;
        @NotNull
        private static final ConcurrentHashMap<Database, TransactionManager> registeredDatabases;
        @NotNull
        private static final TransactionManagerThreadLocal currentThreadManager;

        private Companion() {
        }

        @NotNull
        public final AtomicReference<Database> getCurrentDefaultDatabase$exposed_core() {
            return currentDefaultDatabase;
        }

        @Nullable
        public final synchronized Database getDefaultDatabase() {
            Database database = currentDefaultDatabase.get();
            if (database == null) {
                database = (Database)CollectionsKt.firstOrNull((Iterable)databases);
            }
            return database;
        }

        public final synchronized void setDefaultDatabase(@Nullable Database value) {
            currentDefaultDatabase.set(value);
        }

        public final synchronized void registerManager(@NotNull Database database, @NotNull TransactionManager manager) {
            Intrinsics.checkNotNullParameter(database, "database");
            Intrinsics.checkNotNullParameter(manager, "manager");
            if (this.getDefaultDatabase() == null) {
                currentThreadManager.remove();
            }
            if (!registeredDatabases.containsKey(database)) {
                databases.push(database);
            }
            ((Map)registeredDatabases).put(database, manager);
        }

        public final synchronized void closeAndUnregister(@NotNull Database database) {
            block1: {
                TransactionManager manager;
                Intrinsics.checkNotNullParameter(database, "database");
                TransactionManager transactionManager = manager = registeredDatabases.get(database);
                if (transactionManager == null) break block1;
                TransactionManager it = transactionManager;
                boolean bl = false;
                registeredDatabases.remove(database);
                databases.remove(database);
                currentDefaultDatabase.compareAndSet(database, null);
                if (currentThreadManager.isInitialized() && Intrinsics.areEqual(currentThreadManager.get(), it)) {
                    currentThreadManager.remove();
                }
            }
        }

        @Nullable
        public final TransactionManager managerFor(@Nullable Database database) {
            Database database2 = database;
            return database2 != null ? registeredDatabases.get(database2) : this.getManager();
        }

        @NotNull
        public final TransactionManager getManager() {
            Object t2 = currentThreadManager.get();
            Intrinsics.checkNotNullExpressionValue(t2, "currentThreadManager.get()");
            return (TransactionManager)t2;
        }

        public final void resetCurrent(@Nullable TransactionManager manager) {
            Unit unit;
            TransactionManager transactionManager = manager;
            if (transactionManager != null) {
                TransactionManager it = transactionManager;
                boolean bl = false;
                currentThreadManager.set(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                currentThreadManager.remove();
            }
        }

        @NotNull
        public final Transaction currentOrNew(int isolation) {
            Transaction transaction2 = this.currentOrNull();
            if (transaction2 == null) {
                transaction2 = DefaultImpls.newTransaction$default(this.getManager(), isolation, false, null, 6, null);
            }
            return transaction2;
        }

        @Nullable
        public final Transaction currentOrNull() {
            return this.getManager().currentOrNull();
        }

        @NotNull
        public final Transaction current() {
            Transaction transaction2 = this.currentOrNull();
            if (transaction2 == null) {
                throw new IllegalStateException("No transaction in context.".toString());
            }
            return transaction2;
        }

        public final boolean isInitialized() {
            return this.getDefaultDatabase() != null;
        }

        static {
            $$INSTANCE = new Companion();
            currentDefaultDatabase = new AtomicReference();
            databases = new ConcurrentLinkedDeque();
            registeredDatabases = new ConcurrentHashMap();
            currentThreadManager = new TransactionManagerThreadLocal();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0002H\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion$TransactionManagerThreadLocal;", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "()V", "isInitialized", "", "()Z", "setInitialized", "(Z)V", "initialValue", "remove", "", "set", "value", "exposed-core"})
        private static final class TransactionManagerThreadLocal
        extends ThreadLocal<TransactionManager> {
            private boolean isInitialized;

            public final boolean isInitialized() {
                return this.isInitialized;
            }

            public final void setInitialized(boolean bl) {
                this.isInitialized = bl;
            }

            @Override
            @NotNull
            protected TransactionManager initialValue() {
                Object object;
                block3: {
                    block2: {
                        this.isInitialized = true;
                        object = $$INSTANCE.getDefaultDatabase();
                        if (object == null) break block2;
                        Database it = object;
                        boolean bl = false;
                        TransactionManager transactionManager = (TransactionManager)MapsKt.getValue(registeredDatabases, it);
                        object = transactionManager;
                        if (transactionManager != null) break block3;
                    }
                    object = NotInitializedManager.INSTANCE;
                }
                return object;
            }

            @Override
            public void set(@Nullable TransactionManager value) {
                this.isInitialized = true;
                super.set(value);
            }

            @Override
            public void remove() {
                this.isInitialized = false;
                super.remove();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Transaction newTransaction$default(TransactionManager transactionManager, int n, boolean bl, Transaction transaction2, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newTransaction");
            }
            if ((n2 & 1) != 0) {
                n = transactionManager.getDefaultIsolationLevel();
            }
            if ((n2 & 2) != 0) {
                bl = transactionManager.getDefaultReadOnly();
            }
            if ((n2 & 4) != 0) {
                transaction2 = null;
            }
            return transactionManager.newTransaction(n, bl, transaction2);
        }
    }
}

