/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Ljava/util/UUID;", "valueToUUID", "Companion", "exposed-core"})
public final class UUIDColumnType
extends ColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        CharSequence charSequence;
        UUID uUID;
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof String && uuidRegexp.matches(charSequence = (CharSequence)value)) {
            UUID uUID2 = UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(value)");
        } else if (value instanceof String) {
            charSequence = (String)value;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            ByteBuffer b = ByteBuffer.wrap(byArray);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidToDB(this.valueToUUID(value));
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return "" + '\'' + this.valueToUUID(value) + '\'';
    }

    private final UUID valueToUUID(Object value) {
        UUID uUID;
        Object object = value;
        if (object instanceof UUID) {
            uUID = (UUID)value;
        } else if (object instanceof String) {
            UUID uUID2 = UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(value)");
        } else if (object instanceof byte[]) {
            ByteBuffer it = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new UUID(it.getLong(), it.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value.getClass().getCanonicalName()).toString());
        }
        return uUID;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return DefaultKt.getCurrentDialect() instanceof MariaDBDialect ? rs.getBytes(index) : (byte[])super.readObject(rs, index);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType$Companion;", "", "()V", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

