/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.LongQueryException;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 |2\u00020\u00012\u00020\u0002:\u0001|B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\t\u0010Q\u001a\u00020RH\u0096\u0001J\u0006\u0010S\u001a\u00020RJ\b\u0010T\u001a\u00020RH\u0016J\u0018\u0010U\u001a\u00020$2\u0006\u0010V\u001a\u00020\u001a2\u0006\u0010W\u001a\u00020$H\u0002JA\u0010X\u001a\u0004\u0018\u00010R2\b\b\u0001\u0010W\u001a\u00020$2\u001c\b\u0002\u0010Y\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020[\u0012\u0006\u0012\u0004\u0018\u00010\\0?0Z2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010^\u00a2\u0006\u0002\u0010_J_\u0010X\u001a\u0004\u0018\u0001H`\"\b\b\u0000\u0010`*\u00020\\2\b\b\u0001\u0010W\u001a\u00020$2\u001c\b\u0002\u0010Y\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020[\u0012\u0006\u0012\u0004\u0018\u00010\\0?0Z2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010^2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u0002H`0b\u00a2\u0006\u0002\u0010dJ!\u0010X\u001a\u0004\u0018\u0001H`\"\u0004\b\u0000\u0010`2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002H`0e\u00a2\u0006\u0002\u0010fJL\u0010X\u001a\u0004\u0018\u0001Hg\"\u0004\b\u0000\u0010`\"\u0004\b\u0001\u0010g2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002H`0e2#\u0010h\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H`0e\u0012\u0004\u0012\u0002H`\u0012\u0004\u0012\u0002Hg0i\u00a2\u0006\u0002\bj\u00a2\u0006\u0002\u0010kJ\u0014\u0010l\u001a\u00020R2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0nJ\u0012\u0010o\u001a\u00020$2\n\u0010p\u001a\u0006\u0012\u0002\b\u00030qJ!\u0010o\u001a\u00020R2\n\u0010p\u001a\u0006\u0012\u0002\b\u00030q2\u0006\u0010r\u001a\u00020sH\u0000\u00a2\u0006\u0002\btJ\u0012\u0010u\u001a\u00020$2\n\u0010p\u001a\u0006\u0012\u0002\b\u00030qJ\u000e\u0010u\u001a\u00020$2\u0006\u0010v\u001a\u00020wJ\u000e\u0010x\u001a\u00020\u00142\u0006\u0010y\u001a\u00020+J\b\u0010z\u001a\u00020RH\u0016J\u000e\u0010{\u001a\u00020\u00142\u0006\u0010y\u001a\u00020+R\u0016\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R$\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+0*j\b\u0012\u0004\u0012\u00020+`,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u00105\u001a\u0004\u0018\u00010\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0016R\u001a\u0010:\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00102\"\u0004\b<\u00104RO\u0010=\u001a6\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0?0>j\u001a\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0?`@8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010(\u001a\u0004\bA\u0010BR\u0015\u0010D\u001a\u00060Ej\u0002`F\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010I\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u00102R\u001e\u0010K\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010P\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006}"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "transactionImpl", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "currentStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "executedStatements", "", "getExecutedStatements$exposed_core", "()Ljava/util/List;", "id", "", "getId", "()Ljava/lang/String;", "id$delegate", "Lkotlin/Lazy;", "interceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;", "Lkotlin/collections/ArrayList;", "getInterceptors$exposed_core", "()Ljava/util/ArrayList;", "openResultSetsCount", "", "getOpenResultSetsCount$exposed_core", "()I", "setOpenResultSetsCount$exposed_core", "(I)V", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "readOnly", "getReadOnly", "statementCount", "getStatementCount", "setStatementCount", "statementStats", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "getStatementStats", "()Ljava/util/HashMap;", "statementStats$delegate", "statements", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "transactionIsolation", "getTransactionIsolation", "warnLongQueriesDuration", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "close", "", "closeExecutedStatements", "commit", "describeStatement", "delta", "stmt", "exec", "args", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "explicitStatementType", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;)Lkotlin/Unit;", "T", "transform", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "R", "body", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "execInBatch", "stmts", "", "fullIdentity", "column", "Lorg/jetbrains/exposed/sql/Column;", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "fullIdentity$exposed_core", "identity", "table", "Lorg/jetbrains/exposed/sql/Table;", "registerInterceptor", "interceptor", "rollback", "unregisterInterceptor", "Companion", "exposed-core"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionInterface transactionImpl;
    @NotNull
    private final Database db;
    private int statementCount;
    private long duration;
    @Nullable
    private Long warnLongQueriesDuration;
    private boolean debug;
    @NotNull
    private final Lazy id$delegate;
    @Nullable
    private PreparedStatementApi currentStatement;
    @NotNull
    private final List<PreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    @NotNull
    private final StringBuilder statements;
    @NotNull
    private final Lazy statementStats$delegate;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public Transaction(@NotNull TransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter(transactionImpl, "transactionImpl");
        this.transactionImpl = transactionImpl;
        this.db = this.transactionImpl.getDb();
        this.warnLongQueriesDuration = this.db.getConfig().getWarnLongQueriesDuration();
        this.id$delegate = LazyKt.lazy(id.2.INSTANCE);
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        this.statements = new StringBuilder();
        this.statementStats$delegate = LazyKt.lazy(statementStats.2.INSTANCE);
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        SQLLogKt.addLogger(this, sqlLoggerArray);
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    @Nullable
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public boolean getReadOnly() {
        return this.transactionImpl.getReadOnly();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    @NotNull
    public final Database getDb() {
        return this.db;
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    @Nullable
    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(@Nullable Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getId() {
        Lazy lazy = this.id$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final PreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable PreparedStatementApi preparedStatementApi) {
        this.currentStatement = preparedStatementApi;
    }

    @NotNull
    public final List<PreparedStatementApi> getExecutedStatements$exposed_core() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_core() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_core(int n) {
        this.openResultSetsCount = n;
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_core() {
        return this.interceptors;
    }

    @NotNull
    public final StringBuilder getStatements() {
        return this.statements;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        Lazy lazy = this.statementStats$delegate;
        return (HashMap)lazy.getValue();
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, "interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, "interceptor");
        return this.interceptors.remove(interceptor);
    }

    @Override
    public void commit() {
        StatementInterceptor it;
        HashMap dataToStore = new HashMap();
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        this.getUserdata().putAll(dataToStore);
    }

    @Override
    public void rollback() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        this.getUserdata().clear();
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take(stmt, 1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args2, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter(stmt, "stmt");
        Intrinsics.checkNotNullParameter(args2, "args");
        return (Unit)this.exec(stmt, args2, explicitStatementType, exec.1.INSTANCE);
    }

    public static /* synthetic */ Unit exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args2, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform2) {
        Intrinsics.checkNotNullParameter(stmt, "stmt");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (((CharSequence)stmt).length() == 0) {
            return null;
        }
        StatementType statementType = explicitStatementType;
        if (statementType == null) {
            StatementType statementType2;
            block4: {
                StatementType[] statementTypeArray = StatementType.values();
                int n = statementTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    StatementType statementType3;
                    StatementType it = statementType3 = statementTypeArray[i];
                    boolean bl = false;
                    if (!StringsKt.startsWith(((Object)StringsKt.trim((CharSequence)stmt)).toString(), it.name(), true)) continue;
                    statementType2 = statementType3;
                    break block4;
                }
                statementType2 = statementType = null;
            }
            if (statementType2 == null) {
                statementType = StatementType.OTHER;
            }
        }
        StatementType type2 = statementType;
        List list2 = CollectionsKt.emptyList();
        return this.exec(new Statement<T>(type2, transform2, stmt, args2, list2){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
                T t2;
                ResultSet result2;
                ResultSet resultSet;
                Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: {
                        resultSet = $this$executeInternal.executeQuery();
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        resultSet = $this$executeInternal.getResultSet();
                    }
                }
                ResultSet resultSet2 = result2 = resultSet;
                if (resultSet2 != null) {
                    AutoCloseable autoCloseable = resultSet2;
                    Function1<ResultSet, T> function1 = this.$transform;
                    Throwable throwable = null;
                    try {
                        ResultSet it = (ResultSet)autoCloseable;
                        boolean bl = false;
                        T t3 = function1.invoke(it);
                        t2 = t3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                } else {
                    t2 = null;
                }
                return t2;
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction2) {
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                return this.$stmt;
            }

            @NotNull
            public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
                return CollectionsKt.listOf(this.$args);
            }
        });
    }

    public static /* synthetic */ Object exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull Statement<? extends T> stmt) {
        Intrinsics.checkNotNullParameter(stmt, "stmt");
        return (T)this.exec(stmt, exec.3.INSTANCE);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, "stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull Statement<? extends T> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        R r;
        Intrinsics.checkNotNullParameter(stmt, "stmt");
        Intrinsics.checkNotNullParameter(body, "body");
        int n = this.statementCount;
        this.statementCount = n + 1;
        long start = System.nanoTime();
        Pair<T, List<StatementContext>> answer = stmt.executeIn$exposed_core(this);
        long it2 = System.nanoTime() - start;
        boolean bl = false;
        long delta = TimeUnit.NANOSECONDS.toMillis(it2);
        Lazy lazySQL2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<String>(answer, this){
            final /* synthetic */ Pair<T, List<StatementContext>> $answer;
            final /* synthetic */ Transaction this$0;
            {
                this.$answer = $answer;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$answer.getSecond();
                Transaction transaction2 = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StatementContext statementContext = (StatementContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.sql(transaction2));
                }
                return CollectionsKt.joinToString$default(CollectionsKt.distinct((List)destination$iv$iv), null, null, null, 0, null, null, 63, null);
            }
        });
        this.duration += delta;
        if (this.debug) {
            Object object;
            void $this$getOrPut$iv;
            this.statements.append(this.describeStatement(delta, (String)lazySQL2.getValue()));
            Map it2 = this.getStatementStats();
            Object key$iv = lazySQL2.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair<Integer, Long> answer$iv = TuplesKt.to(0, 0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Pair pair = (Pair)object;
            boolean bl3 = false;
            int count2 = ((Number)pair.component1()).intValue();
            long time = ((Number)pair.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazySQL2.getValue(), TuplesKt.to(count2 + 1, time + delta));
        }
        Long l = this.warnLongQueriesDuration;
        if (delta > (l != null ? l : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(delta, (String)lazySQL2.getValue()), new LongQueryException());
        }
        T t2 = answer.getFirst();
        if (t2 != null) {
            T it3 = t2;
            boolean bl4 = false;
            r = body.invoke((Statement<? extends T>)stmt, (T)it3);
        } else {
            r = null;
        }
        return r;
    }

    @NotNull
    public final String identity(@NotNull Table table) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(table, "table");
                object = table instanceof Alias ? (Alias)table : null;
                if (object == null) break block2;
                Alias it = object;
                boolean bl = false;
                String string = this.identity((Table)it.getDelegate()) + ' ' + this.db.getIdentifierManager().quoteIfNecessary(it.getAlias());
                object = string;
                if (string != null) break block3;
            }
            object = this.db.getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(table.getTableName()));
        }
        return object;
    }

    @NotNull
    public final String fullIdentity(@NotNull Column<?> column) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(column, "column");
        QueryBuilder it = queryBuilder = new QueryBuilder(false);
        boolean bl = false;
        this.fullIdentity$exposed_core(column, it);
        return queryBuilder.toString();
    }

    public final void fullIdentity$exposed_core(@NotNull Column<?> column, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(column, this){
            final /* synthetic */ Column<?> $column;
            final /* synthetic */ Transaction this$0;
            {
                this.$column = $column;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                if (this.$column.getTable() instanceof Alias) {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(((Alias)this.$column.getTable()).getAlias()));
                } else {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(this.$column.getTable().getTableName())));
                }
                $this$invoke.append('.');
                $this$invoke.append(this.this$0.identity(this.$column));
            }
        });
    }

    @NotNull
    public final String identity(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, "column");
        return this.db.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.getName());
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreparedStatementApi it = (PreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(GlobalStatementInte\u2026::class.java.classLoader)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/Transaction$Companion;", "", "()V", "globalInterceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "getGlobalInterceptors$exposed_core", "()Ljava/util/ArrayList;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors$exposed_core() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

