/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0006J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/exposed/sql/LikePattern;", "", "pattern", "", "escapeChar", "", "(Ljava/lang/String;Ljava/lang/Character;)V", "getEscapeChar", "()Ljava/lang/Character;", "Ljava/lang/Character;", "getPattern", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Character;)Lorg/jetbrains/exposed/sql/LikePattern;", "equals", "", "other", "hashCode", "", "plus", "rhs", "toString", "Companion", "exposed-core"})
public final class LikePattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @Nullable
    private final Character escapeChar;

    public LikePattern(@NotNull String pattern, @Nullable Character escapeChar) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.pattern = pattern;
        this.escapeChar = escapeChar;
    }

    public /* synthetic */ LikePattern(String string, Character c, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = null;
        }
        this(string, c);
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @Nullable
    public final Character getEscapeChar() {
        return this.escapeChar;
    }

    @NotNull
    public final LikePattern plus(@NotNull LikePattern rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        if (!Intrinsics.areEqual(this.escapeChar, rhs.escapeChar)) {
            boolean bl = false;
            String string = "Mixing escape chars '" + this.escapeChar + "' vs. '" + rhs.escapeChar + " is not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        return new LikePattern(this.pattern + rhs.pattern, rhs.escapeChar);
    }

    @NotNull
    public final LikePattern plus(@NotNull String rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return new LikePattern(this.pattern + rhs, this.escapeChar);
    }

    @NotNull
    public final String component1() {
        return this.pattern;
    }

    @Nullable
    public final Character component2() {
        return this.escapeChar;
    }

    @NotNull
    public final LikePattern copy(@NotNull String pattern, @Nullable Character escapeChar) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return new LikePattern(pattern, escapeChar);
    }

    public static /* synthetic */ LikePattern copy$default(LikePattern likePattern, String string, Character c, int n, Object object) {
        if ((n & 1) != 0) {
            string = likePattern.pattern;
        }
        if ((n & 2) != 0) {
            c = likePattern.escapeChar;
        }
        return likePattern.copy(string, c);
    }

    @NotNull
    public String toString() {
        return "LikePattern(pattern=" + this.pattern + ", escapeChar=" + this.escapeChar + ')';
    }

    public int hashCode() {
        int result2 = this.pattern.hashCode();
        result2 = result2 * 31 + (this.escapeChar == null ? 0 : ((Object)this.escapeChar).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LikePattern)) {
            return false;
        }
        LikePattern likePattern = (LikePattern)other;
        if (!Intrinsics.areEqual(this.pattern, likePattern.pattern)) {
            return false;
        }
        return Intrinsics.areEqual(this.escapeChar, likePattern.escapeChar);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/LikePattern$Companion;", "", "()V", "ofLiteral", "Lorg/jetbrains/exposed/sql/LikePattern;", "text", "", "escapeChar", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LikePattern ofLiteral(@NotNull String text, char escapeChar) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(text, "text");
            Map<Character, Character> likePatternSpecialChars = DefaultKt.getCurrentDialect().getLikePatternSpecialChars();
            ArrayList<Character> nextExpectedPatternQueue = new ArrayList<Character>();
            Character nextCharToEscape = null;
            StringBuilder $this$ofLiteral_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence $this$forEach$iv = text;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                boolean shouldEscape;
                boolean bl2;
                char element$iv;
                char it = element$iv = $this$forEach$iv.charAt(i);
                boolean bl3 = false;
                char c = it;
                if (c == escapeChar) {
                    bl2 = true;
                } else {
                    Character c2 = Character.valueOf(c);
                    if (likePatternSpecialChars.containsKey(c2)) {
                        Character c3 = likePatternSpecialChars.get(Character.valueOf(it));
                        if (c3 != null) {
                            char nextChar = c3.charValue();
                            boolean bl4 = false;
                            nextExpectedPatternQueue.add(Character.valueOf(nextChar));
                            nextCharToEscape = Character.valueOf(nextChar);
                        }
                        bl2 = true;
                    } else {
                        Character c4 = nextCharToEscape;
                        if (c4 != null && c == c4.charValue()) {
                            CollectionsKt.removeLast((List)nextExpectedPatternQueue);
                            nextCharToEscape = (Character)CollectionsKt.lastOrNull((List)nextExpectedPatternQueue);
                            bl2 = true;
                        } else {
                            bl2 = shouldEscape = false;
                        }
                    }
                }
                if (shouldEscape) {
                    $this$ofLiteral_u24lambda_u242.append(escapeChar);
                }
                $this$ofLiteral_u24lambda_u242.append(it);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            String escapedPattern = string;
            return new LikePattern(escapedPattern, Character.valueOf(escapeChar));
        }

        public static /* synthetic */ LikePattern ofLiteral$default(Companion companion, String string, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = (char)92;
            }
            return companion.ofLiteral(string, c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

