/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/sql/IntegerColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "sqlType", "", "valueFromDB", "", "value", "", "(Ljava/lang/Object;)Ljava/lang/Integer;", "exposed-core"})
public final class IntegerColumnType
extends ColumnType {
    public IntegerColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().integerType();
    }

    @Override
    @NotNull
    public Integer valueFromDB(@NotNull Object value) {
        int n;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (object instanceof Number) {
            n = ((Number)value).intValue();
        } else if (object instanceof String) {
            n = Integer.parseInt((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Int: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return n;
    }
}

