/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnKt;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u00100\u001a\u0002012\n\u00102\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0010\u00104\u001a\u00020\b2\b\b\u0002\u00105\u001a\u00020%J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0013\u00107\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u000108H\u0096\u0002J\b\u00109\u001a\u000201H\u0016J\r\u0010:\u001a\u00020%H\u0000\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\bJ\u0018\u0010+\u001a\n\u0012\u0004\u0012\u0002HA\u0018\u00010\u0000\"\b\b\u0001\u0010A*\u00028\u0000J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020\bH\u0016J\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0014\u0010'\u001a\u00020%8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006H"}, d2={"Lorg/jetbrains/exposed/sql/Column;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "name", "", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "dbDefaultValue", "Lorg/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed_core", "()Lorg/jetbrains/exposed/sql/Expression;", "setDbDefaultValue$exposed_core", "(Lorg/jetbrains/exposed/sql/Expression;)V", "ddl", "", "getDdl", "()Ljava/util/List;", "defaultValueFun", "Lkotlin/Function0;", "getDefaultValueFun", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun", "(Lkotlin/jvm/functions/Function0;)V", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getForeignKey", "()Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "setForeignKey", "(Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;)V", "isLastColumnInPK", "", "()Z", "isPrimaryConstraintWillBeDefined", "isPrimaryConstraintWillBeDefined$exposed_core", "getName", "()Ljava/lang/String;", "referee", "getReferee", "()Lorg/jetbrains/exposed/sql/Column;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "compareTo", "", "other", "createStatement", "descriptionDdl", "modify", "dropStatement", "equals", "", "hashCode", "isOneColumnPK", "isOneColumnPK$exposed_core", "modifyStatement", "modifyStatements", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "nameInDatabaseCase", "S", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "toString", "withColumnType", "exposed-core"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements DdlAware,
Comparable<Column<?>> {
    @NotNull
    private final Table table;
    @NotNull
    private final String name;
    @NotNull
    private final IColumnType columnType;
    @Nullable
    private ForeignKeyConstraint foreignKey;
    @Nullable
    private Function0<? extends T> defaultValueFun;
    @Nullable
    private Expression<T> dbDefaultValue;

    public Column(@NotNull Table table, @NotNull String name2, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        this.table = table;
        this.name = name2;
        this.columnType = columnType;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IColumnType getColumnType() {
        return this.columnType;
    }

    @Nullable
    public final ForeignKeyConstraint getForeignKey() {
        return this.foreignKey;
    }

    public final void setForeignKey(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
        this.foreignKey = foreignKeyConstraint;
    }

    @Nullable
    public final Column<?> getReferee() {
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKey;
        return foreignKeyConstraint != null ? foreignKeyConstraint.targetOf(this) : null;
    }

    @Nullable
    public final <S extends T> Column<S> referee() {
        Column<?> column = this.getReferee();
        return column instanceof Column ? column : null;
    }

    @Nullable
    public final Function0<T> getDefaultValueFun() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun(@Nullable Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    @Nullable
    public final Expression<T> getDbDefaultValue$exposed_core() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed_core(@Nullable Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        TransactionManager.Companion.current().fullIdentity$exposed_core(this, queryBuilder);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    @NotNull
    public final String nameInDatabaseCase() {
        return DefaultKt.inProperCase(this.name);
    }

    private final boolean isLastColumnInPK() {
        Column<?>[] columnArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual(columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.last(columnArray) : null, this);
    }

    public final boolean isPrimaryConstraintWillBeDefined$exposed_core() {
        return DefaultKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType()) ? false : (this.table.isCustomPKNameDefined$exposed_core() ? this.isLastColumnInPK() : (this.isOneColumnPK$exposed_core() ? false : this.isLastColumnInPK()));
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        String alterTablePrefix = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        boolean isH2withCustomPKConstraint = DefaultKt.getCurrentDialect() instanceof H2Dialect && this.isLastColumnInPK();
        String columnDefinition = this.isPrimaryConstraintWillBeDefined$exposed_core() && this.isLastColumnInPK() && !isH2withCustomPKConstraint ? this.descriptionDdl(false) + ", ADD " + this.table.primaryKeyConstraint$exposed_core() : (isH2withCustomPKConstraint ? this.descriptionDdl(true) : this.descriptionDdl(false));
        String addConstr = isH2withCustomPKConstraint ? alterTablePrefix + ' ' + this.table.primaryKeyConstraint$exposed_core() : null;
        String[] stringArray = new String[]{alterTablePrefix + ' ' + columnDefinition, addConstr};
        return CollectionsKt.listOfNotNull(stringArray);
    }

    @NotNull
    public final List<String> modifyStatements(@NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        return DefaultKt.getCurrentDialect().modifyColumn(this, columnDiff);
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return DefaultKt.getCurrentDialect().modifyColumn(this, ColumnDiff.Companion.getAllChanged());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        Transaction tr = TransactionManager.Companion.current();
        return CollectionsKt.listOf("ALTER TABLE " + tr.identity(this.table) + " DROP COLUMN " + tr.identity(this));
    }

    public final boolean isOneColumnPK$exposed_core() {
        Column<?>[] columnArray = this.table.getPrimaryKey();
        return Intrinsics.areEqual(columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.singleOrNull(columnArray) : null, this);
    }

    @NotNull
    public final String descriptionDdl(boolean modify) {
        StringBuilder stringBuilder;
        StringBuilder $this$descriptionDdl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Transaction tr = TransactionManager.Companion.current();
        Column column = this;
        $this$descriptionDdl_u24lambda_u240.append(tr.identity(column));
        $this$descriptionDdl_u24lambda_u240.append(" ");
        Column<?>[] columnArray = this.table.getPrimaryKey();
        boolean isPKColumn = columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.contains(columnArray, column) : false;
        boolean isSQLiteAutoIncColumn = DefaultKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType());
        if (!isPKColumn && isSQLiteAutoIncColumn) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to primary key column");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && !this.isOneColumnPK$exposed_core()) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to a single column primary key");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && this.table.isCustomPKNameDefined$exposed_core()) {
            String rawType = StringsKt.substringBefore$default(this.getColumnType().sqlType(), "PRIMARY KEY", null, 2, null);
            String string = this.table.primaryKeyConstraint$exposed_core();
            Intrinsics.checkNotNull(string);
            String constraintPart = StringsKt.substringBefore$default(string, "(", null, 2, null);
            $this$descriptionDdl_u24lambda_u240.append(rawType + ' ' + constraintPart + " AUTOINCREMENT");
        } else {
            $this$descriptionDdl_u24lambda_u240.append(this.getColumnType().sqlType());
        }
        Expression<T> defaultValue = this.dbDefaultValue;
        if (defaultValue != null) {
            String expressionSQL = DefaultKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue(defaultValue);
            if (!DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                String clientDefault = this.defaultValueFun != null ? " Expression will be evaluated on the client." : (!this.getColumnType().getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error(DefaultKt.getCurrentDialect().getName() + ' ' + tr.getDb().getVersion() + " doesn't support expression '" + expressionSQL + "' as default value." + clientDefault);
            } else {
                $this$descriptionDdl_u24lambda_u240.append(" DEFAULT " + expressionSQL);
            }
        }
        if (this.getColumnType().getNullable() || defaultValue != null && this.defaultValueFun == null && !DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
            $this$descriptionDdl_u24lambda_u240.append(" NULL");
        } else if (!isPKColumn || DefaultKt.getCurrentDialect() instanceof SQLiteDialect && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u240.append(" NOT NULL");
        }
        if (!modify && this.isOneColumnPK$exposed_core() && !this.isPrimaryConstraintWillBeDefined$exposed_core() && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u240.append(" PRIMARY KEY");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String descriptionDdl$default(Column column, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return column.descriptionDdl(bl);
    }

    @NotNull
    public final Column<T> withColumnType(@NotNull IColumnType columnType) {
        Column<T> column;
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        Column<T> it = column = new Column<T>(this.table, this.name, columnType);
        boolean bl = false;
        it.foreignKey = this.foreignKey;
        it.defaultValueFun = this.defaultValueFun;
        it.dbDefaultValue = this.dbDefaultValue;
        return column;
    }

    @Override
    public int compareTo(@NotNull Column<?> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColumnKt.access$getComparator$p().compare(this, other);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.table, ((Column)other).table)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.name, ((Column)other).name)) {
            return false;
        }
        return Intrinsics.areEqual(this.getColumnType(), ((Column)other).getColumnType());
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.table.getClass().getName() + '.' + this.name;
    }
}

