/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/exposed/sql/CharacterColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "", "(Ljava/lang/Object;)Ljava/lang/Character;", "exposed-core"})
public final class CharacterColumnType
extends ColumnType {
    public CharacterColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return "CHAR";
    }

    @Override
    @NotNull
    public Character valueFromDB(@NotNull Object value) {
        char c;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Character) {
            c = ((Character)value).charValue();
        } else if (object instanceof Number) {
            c = (char)((Number)value).intValue();
        } else if (object instanceof String) {
            c = StringsKt.single((CharSequence)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Char: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return Character.valueOf(c);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return value.toString();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return "" + '\'' + value + '\'';
    }
}

