/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.exceptions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/exceptions/ExposedSQLException;", "Ljava/sql/SQLException;", "cause", "", "contexts", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Ljava/lang/Throwable;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)V", "getContexts", "()Ljava/util/List;", "originalSQLException", "causedByQueries", "", "getErrorCode", "", "getSQLState", "toString", "exposed-core"})
public final class ExposedSQLException
extends SQLException {
    @NotNull
    private final List<StatementContext> contexts;
    @NotNull
    private final Transaction transaction;
    @Nullable
    private final SQLException originalSQLException;

    public ExposedSQLException(@Nullable Throwable cause, @NotNull List<StatementContext> contexts, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(contexts, "contexts");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        super(cause);
        this.contexts = contexts;
        this.transaction = transaction2;
        this.originalSQLException = cause instanceof SQLException ? (SQLException)cause : null;
    }

    @NotNull
    public final List<StatementContext> getContexts() {
        return this.contexts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> causedByQueries() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.contexts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                string = this.transaction.getDebug() ? StatementKt.expandArgs((StatementContext)it, this.transaction) : it.sql(this.transaction);
            }
            catch (Throwable _) {
                String string2;
                String string3;
                try {
                    Statement<?> statement = it.getStatement();
                    AbstractQuery abstractQuery = statement instanceof AbstractQuery ? (AbstractQuery)statement : null;
                    string3 = abstractQuery != null ? abstractQuery.prepareSQL(new QueryBuilder(!this.transaction.getDebug())) : null;
                }
                catch (Throwable _2) {
                    string3 = null;
                }
                if ((string2 = string3) == null) {
                    string2 = "Failed on expanding args for " + (Object)((Object)it.getStatement().getType()) + ": " + it.getStatement();
                }
                string = string2;
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getSQLState() {
        SQLException sQLException = this.originalSQLException;
        String string = sQLException != null ? sQLException.getSQLState() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        SQLException sQLException = this.originalSQLException;
        return sQLException != null ? sQLException.getErrorCode() : 0;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "\nSQL: " + this.causedByQueries();
    }
}

