/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.BaseSpscLinkedArrayQueueProducerColdFields;
import org.jctools.queues.IndexedQueueSizeUtil;
import org.jctools.queues.LinkedArrayQueueUtil;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MessagePassingQueueUtil;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.PortableJvmInfo;
import org.jctools.util.UnsafeRefArrayAccess;

abstract class BaseSpscLinkedArrayQueue<E>
extends BaseSpscLinkedArrayQueueProducerColdFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    BaseSpscLinkedArrayQueue() {
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final void soNext(E[] curr, E[] next) {
        long offset = LinkedArrayQueueUtil.nextArrayOffset(curr);
        UnsafeRefArrayAccess.soRefElement(curr, offset, next);
    }

    protected final E[] lvNextArrayAndUnlink(E[] curr) {
        long offset = LinkedArrayQueueUtil.nextArrayOffset(curr);
        Object[] nextBuffer = (Object[])UnsafeRefArrayAccess.lvRefElement(curr, offset);
        UnsafeRefArrayAccess.soRefElement(curr, offset, null);
        return nextBuffer;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return MessagePassingQueueUtil.drain(this, c);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result2 = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result2;
        } while ((result2 += (long)filled) <= (long)capacity);
        return (int)result2;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit) {
        if (null == s2) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        for (int i = 0; i < limit; ++i) {
            Object[] buffer = this.producerBuffer;
            long index = this.lpProducerIndex();
            long mask = this.producerMask;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
            if (index < this.producerBufferLimit) {
                this.writeToQueue(buffer, s2.get(), index, offset);
                continue;
            }
            if (this.offerColdPath(buffer, mask, index, offset, null, s2)) continue;
            return i;
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, wait, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s2, wait, exit);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        Object[] buffer = this.producerBuffer;
        long index = this.lpProducerIndex();
        long mask = this.producerMask;
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
        if (index < this.producerBufferLimit) {
            this.writeToQueue(buffer, e, index, offset);
            return true;
        }
        return this.offerColdPath(buffer, mask, index, offset, e, null);
    }

    abstract boolean offerColdPath(E[] var1, long var2, long var4, long var6, E var8, MessagePassingQueue.Supplier<? extends E> var9);

    @Override
    public E poll() {
        boolean isNextBuffer;
        long mask;
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        boolean bl = isNextBuffer = e == JUMP;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
            return (E)e;
        }
        if (isNextBuffer) {
            return (E)this.newBufferPoll(buffer, index);
        }
        return null;
    }

    @Override
    public E peek() {
        long mask;
        Object[] buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == JUMP) {
            return (E)this.newBufferPeek(buffer, index);
        }
        return (E)e;
    }

    final void linkOldToNew(long currIndex, E[] oldBuffer, long offset, E[] newBuffer, long offsetInNew, E e) {
        UnsafeRefArrayAccess.soRefElement(newBuffer, offsetInNew, e);
        this.soNext(oldBuffer, newBuffer);
        UnsafeRefArrayAccess.soRefElement(oldBuffer, offset, JUMP);
        this.soProducerIndex(currIndex + 1L);
    }

    final void writeToQueue(E[] buffer, E e, long index, long offset) {
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
    }

    private E newBufferPeek(E[] buffer, long index) {
        long mask;
        Object[] nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerBuffer = nextBuffer;
        this.consumerMask = mask = (long)(LinkedArrayQueueUtil.length(nextBuffer) - 2);
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
        return (E)UnsafeRefArrayAccess.lvRefElement(nextBuffer, offset);
    }

    private E newBufferPoll(E[] buffer, long index) {
        long mask;
        Object[] nextBuffer = this.lvNextArrayAndUnlink(buffer);
        this.consumerBuffer = nextBuffer;
        this.consumerMask = mask = (long)(LinkedArrayQueueUtil.length(nextBuffer) - 2);
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
        Object n = UnsafeRefArrayAccess.lvRefElement(nextBuffer, offset);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.soConsumerIndex(index + 1L);
        UnsafeRefArrayAccess.soRefElement(nextBuffer, offset, null);
        return (E)n;
    }
}

