/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.shrinkwrap.resolver.impl.maven.util.IOUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public final class FileUtil
extends Enum<FileUtil> {
    public static final /* enum */ FileUtil INSTANCE = new FileUtil();
    private static final /* synthetic */ FileUtil[] $VALUES;

    public static FileUtil[] values() {
        return (FileUtil[])$VALUES.clone();
    }

    public static FileUtil valueOf(String name2) {
        return Enum.valueOf(FileUtil.class, name2);
    }

    public File fileFromClassLoaderResource(String path, ClassLoader cl) {
        assert (path != null && path.length() > 0) : "path must be specified";
        assert (cl != null) : "ClassLoader is required";
        URL url2 = cl.getResource(path);
        Validate.notNull(url2, path + " doesn't exist or can't be accessed on from " + cl);
        File file = null;
        try {
            file = new File(url2.toURI());
            Validate.readable(file, "Should be readable");
        }
        catch (IllegalArgumentException iae) {
            try {
                file = new File(url2.getPath());
                Validate.readable(file, "Should be readable");
            }
            catch (RuntimeException re) {
                file = null;
            }
        }
        catch (URISyntaxException e) {
            try {
                file = new File(url2.getPath());
            }
            catch (RuntimeException re) {
                file = null;
            }
        }
        if (file == null) {
            try {
                String localResourcePath = this.getLocalResourcePathFromResourceName(path, cl);
                file = new File(localResourcePath);
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("Resource + " + path + " in " + cl + " points to " + url2.toString() + ", and cannot be resolved as a " + File.class.getName());
            }
        }
        return file;
    }

    private String getLocalResourcePathFromResourceName(String resourceName, ClassLoader cl) {
        URL resourceUrl = cl.getResource(resourceName);
        Validate.notNull(resourceUrl, resourceName + " doesn't exist or can't be accessed on classpath");
        try {
            File localResource = this.temporaryFile(resourceName);
            localResource.deleteOnExit();
            IOUtil.copyWithClose(resourceUrl.openStream(), new FileOutputStream(localResource));
            return localResource.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to open resource name specified by " + resourceName, e);
        }
    }

    private File temporaryFile(String resourceName) throws IOException {
        File tmpDir = new File(SecurityActions.getProperty("java.io.tmpdir"));
        Validate.writeableDirectory(tmpDir.getAbsolutePath(), "Unable to access temporary directory at " + tmpDir.getAbsolutePath());
        File localResource = File.createTempFile(resourceName.replace("/", "-").replace("\\", "-").replace(File.pathSeparator, "-").replaceAll("\\s", "-"), ".tmp", tmpDir);
        localResource.deleteOnExit();
        return localResource;
    }

    static {
        $VALUES = new FileUtil[]{INSTANCE};
    }
}

