/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.jboss.shrinkwrap.resolver.impl.maven.GetTcclAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    static Properties getProperties() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    static URL getResource(final String resource) {
        try {
            URL value = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return SecurityActions.getThreadContextClassLoader().getResource(resource);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }
}

