/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.logging;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class LogTransferListener
extends AbstractTransferListener {
    private static final Logger log = Logger.getLogger(LogTransferListener.class.getName());
    private final Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private static final long TRANSFER_THRESHOLD = 51200L;

    @Override
    public void transferInitiated(TransferEvent event) {
        TransferResource resource = event.getResource();
        StringBuilder sb = new StringBuilder().append(event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading").append(":").append(resource.getRepositoryUrl()).append(resource.getResourceName());
        this.downloads.put(resource, new Long(0L));
        log.fine(sb.toString());
    }

    @Override
    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        long lastTransferred = this.downloads.get(resource);
        long transferred = event.getTransferredBytes();
        if (transferred - lastTransferred >= 51200L) {
            this.downloads.put(resource, transferred);
            long total = resource.getContentLength();
            log.finer(this.getStatus(transferred, total) + ", ");
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
            StringBuilder sb = new StringBuilder().append("Completed").append(event.getRequestType() == TransferEvent.RequestType.PUT ? " upload of " : " download of ").append(resource.getResourceName()).append(event.getRequestType() == TransferEvent.RequestType.PUT ? " into " : " from ").append(resource.getRepositoryUrl()).append(", transferred ").append(contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B").append(" at ").append(new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH)).format(kbPerSec)).append("KB/sec");
            log.fine(sb.toString());
        }
    }

    @Override
    public void transferFailed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        StringBuilder sb = new StringBuilder().append("Failed").append(event.getRequestType() == TransferEvent.RequestType.PUT ? " uploading " : " downloading ").append(resource.getResourceName()).append(event.getRequestType() == TransferEvent.RequestType.PUT ? " into " : " from ").append(resource.getRepositoryUrl()).append(". ");
        if (event.getException() != null) {
            sb.append("Reason: \n").append(event.getException());
        }
        log.warning(sb.toString());
    }

    @Override
    public void transferCorrupted(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        StringBuilder sb = new StringBuilder().append("Corrupted").append(event.getRequestType() == TransferEvent.RequestType.PUT ? " upload of " : " download of ").append(resource.getResourceName()).append(event.getRequestType() == TransferEvent.RequestType.PUT ? " into " : " from ").append(resource.getRepositoryUrl()).append(". ");
        if (event.getException() != null) {
            sb.append("Reason: \n").append(event.getException());
        }
        log.warning(sb.toString());
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB";
        }
        return complete + " B";
    }

    private long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

