/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded.pom.equipped;

import java.io.File;
import java.util.Properties;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.ConfigurationDistributionStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.ConfigurationStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.PomEquippedEmbeddedMaven;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.pom.equipped.ConfigurationStageImpl;

public class PomEquippedEmbeddedMavenImpl
extends ConfigurationStageImpl
implements PomEquippedEmbeddedMaven {
    protected final InvocationRequest request = new DefaultInvocationRequest();
    protected Invoker invoker = new DefaultInvoker();
    private StringBuffer logBuffer = new StringBuffer("");
    private boolean quiet = false;

    protected PomEquippedEmbeddedMavenImpl(File pomFile) {
        Validate.notNull(pomFile, "Pom file can not be null!");
        File absoluteFile = pomFile.getAbsoluteFile();
        if (!absoluteFile.exists()) {
            throw new IllegalArgumentException("Given pom file does not exist: " + absoluteFile);
        }
        if (!absoluteFile.isFile()) {
            throw new IllegalArgumentException("Given pom file is not a file" + absoluteFile);
        }
        this.request.setPomFile(absoluteFile);
        Properties properties2 = new Properties();
        properties2.put("skipTests", "true");
        this.request.setProperties(properties2);
    }

    @Override
    protected InvocationRequest getInvocationRequest() {
        return this.request;
    }

    @Override
    protected Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    protected ConfigurationStage returnNextStepType() {
        return this;
    }

    @Override
    protected StringBuffer getLogBuffer() {
        return this.logBuffer;
    }

    @Override
    public ConfigurationDistributionStage setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public ConfigurationDistributionStage setQuiet() {
        this.setQuiet(true);
        return this;
    }

    @Override
    protected boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public ConfigurationDistributionStage setAlternatePomFile(String pomFile) {
        if (pomFile != null) {
            File pom = new File(pomFile).getAbsoluteFile();
            if (pom.isDirectory()) {
                pom = new File(pom, "pom.xml");
            }
            this.getInvocationRequest().setPomFile(pom);
        }
        return this;
    }

    @Override
    public ConfigurationDistributionStage setDebugLoggerLevel() {
        this.invoker.getLogger().setThreshold(4);
        return this;
    }
}

