/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded.daemon;

import java.util.concurrent.CountDownLatch;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.daemon.DaemonBuild;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BuildTrigger;

public class DaemonBuildImpl
implements DaemonBuild {
    private Thread daemonBuildThread;
    private DaemonRunnable daemonRunnable;

    public DaemonBuildImpl(BuildTrigger buildTrigger) {
        this.daemonRunnable = new DaemonRunnable(buildTrigger, null);
    }

    public DaemonBuildImpl(BuildTrigger buildTrigger, String expectedRegex) {
        this.daemonRunnable = new DaemonRunnable(buildTrigger, expectedRegex);
    }

    @Override
    public boolean isAlive() {
        return this.daemonBuildThread.isAlive();
    }

    @Override
    public BuiltProject getBuiltProject() {
        if (this.isAlive()) {
            return null;
        }
        return this.daemonRunnable.getBuiltProject();
    }

    public String getExpectedRegex() {
        return this.daemonRunnable.getExpectedRegex();
    }

    DaemonBuild build(CountDownLatch countDownLatch) {
        this.daemonRunnable.setCountDownLatch(countDownLatch);
        return this.build();
    }

    DaemonBuild build() {
        this.daemonBuildThread = new Thread(this.daemonRunnable);
        this.daemonBuildThread.start();
        return this;
    }

    private class DaemonRunnable
    implements Runnable {
        private CountDownLatch countDownLatch;
        private String expectedRegex;
        private BuildTrigger buildTrigger;
        private BuiltProject builtProject;

        DaemonRunnable(BuildTrigger buildTrigger, String expectedRegex) {
            this.buildTrigger = buildTrigger;
            this.expectedRegex = expectedRegex;
        }

        @Override
        public void run() {
            this.builtProject = this.buildTrigger.build(this.expectedRegex, this.countDownLatch);
        }

        BuiltProject getBuiltProject() {
            return this.builtProject;
        }

        void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        String getExpectedRegex() {
            return this.expectedRegex;
        }
    }
}

