/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class BuiltProjectImpl
implements BuiltProject {
    private File pom;
    private File globalSettingsXml;
    private File userSettingsXml;
    private String[] profiles;
    private Model model;
    private String mavenLog;
    private int mavenBuildExitCode = 0;
    private Properties properties;

    public BuiltProjectImpl(String pom, String ... profiles) {
        this(new File(pom), (File)null, (File)null, (Properties)null, profiles);
    }

    public BuiltProjectImpl(File pom, String ... profiles) {
        this(pom, (File)null, (File)null, (Properties)null, profiles);
    }

    public BuiltProjectImpl(String pom, File globalSettingsXml, File userSettingsXml, Properties properties2, String ... profiles) {
        this(new File(pom), globalSettingsXml, userSettingsXml, properties2, profiles);
    }

    public BuiltProjectImpl(File pom, File globalSettingsXml, File userSettingsXml, Properties properties2, String ... profiles) {
        this.pom = pom;
        this.profiles = profiles;
        this.globalSettingsXml = globalSettingsXml;
        this.userSettingsXml = userSettingsXml;
        this.properties = properties2;
    }

    @Override
    public Model getModel() {
        if (this.model == null) {
            MavenWorkingSessionImpl mavenWorkingSession = new MavenWorkingSessionImpl();
            mavenWorkingSession.configureSettingsFromFile(this.globalSettingsXml, this.userSettingsXml);
            ParsedPomFile parsedPomFile = mavenWorkingSession.loadPomFromFile(this.pom, this.properties, this.profiles).getParsedPomFile();
            this.model = parsedPomFile.getModel();
        }
        return this.model;
    }

    @Override
    public Archive getDefaultBuiltArchive() {
        String finalName = this.getModel().getBuild().getFinalName();
        String buildDirectory = this.getModel().getBuild().getDirectory();
        String packaging = this.getModel().getPackaging();
        PackagingType packagingType = PackagingType.fromCache(packaging);
        if (packagingType == null) {
            throw new IllegalArgumentException("The packaging type " + packaging + " is not supported");
        }
        if (packagingType != PackagingType.POM) {
            File zipFile = new File(buildDirectory + File.separator + finalName + "." + packaging);
            return ShrinkWrap.createFromZipFile(this.getArchiveRepresentation(packagingType), zipFile);
        }
        return null;
    }

    private Class<? extends Archive> getArchiveRepresentation(PackagingType packagingType) {
        if (packagingType == PackagingType.EAR) {
            return EnterpriseArchive.class;
        }
        if (packagingType == PackagingType.WAR) {
            return WebArchive.class;
        }
        return JavaArchive.class;
    }

    @Override
    public BuiltProject getModule(String moduleName) {
        List<String> modules = this.getModel().getModules();
        File projectDirectory = this.getModel().getProjectDirectory();
        for (String module : modules) {
            if (!moduleName.equals(module)) continue;
            return this.getSubmodule(projectDirectory + File.separator + module + File.separator + "pom.xml");
        }
        return null;
    }

    @Override
    public List<BuiltProject> getModules() {
        List<String> modules = this.getModel().getModules();
        File projectDirectory = this.getModel().getProjectDirectory();
        ArrayList<BuiltProject> projects = new ArrayList<BuiltProject>(modules.size());
        for (String module : modules) {
            projects.add(this.getSubmodule(projectDirectory + File.separator + module + File.separator + "pom.xml"));
        }
        return projects;
    }

    private BuiltProject getSubmodule(String pomfile) {
        BuiltProjectImpl submodule = new BuiltProjectImpl(pomfile, this.globalSettingsXml, this.userSettingsXml, this.properties, this.profiles);
        submodule.setMavenBuildExitCode(this.getMavenBuildExitCode());
        submodule.setMavenLog(this.getMavenLog());
        return submodule;
    }

    @Override
    public File getTargetDirectory() {
        if (this.getModel().getBuild() == null) {
            return null;
        }
        return new File(this.getModel().getBuild().getDirectory());
    }

    @Override
    public List<Archive> getArchives() {
        File[] allFirstLevelFiles = this.getFirstLevelFiles();
        if (allFirstLevelFiles == null) {
            return null;
        }
        ArrayList<Archive> archives = new ArrayList<Archive>(allFirstLevelFiles.length);
        for (File file : allFirstLevelFiles) {
            Class<? extends Archive> archiveType = this.getIfSupported(file);
            if (archiveType == null) continue;
            archives.add(ShrinkWrap.createFromZipFile(archiveType, file));
        }
        return archives;
    }

    private File[] getFirstLevelFiles() {
        File targetDirectory = this.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return targetDirectory.listFiles();
    }

    private Class<? extends Archive> getIfSupported(File file) {
        PackagingType packagingType;
        String extension = FilenameUtils.getExtension(file.getName());
        if (!Validate.isNullOrEmpty(extension) && (packagingType = PackagingType.fromCache(extension)) != null && packagingType != PackagingType.POM) {
            return this.getArchiveRepresentation(packagingType);
        }
        return null;
    }

    @Override
    public <A extends Archive<?>> List<A> getArchives(Class<A> type2) {
        File[] allFirstLevelFiles = this.getFirstLevelFiles();
        if (allFirstLevelFiles == null) {
            return null;
        }
        ArrayList<A> archives = new ArrayList<A>();
        for (File file : allFirstLevelFiles) {
            Class<? extends Archive> archiveType = this.getIfSupported(file);
            if (archiveType == null || !archiveType.isAssignableFrom(type2)) continue;
            archives.add(ShrinkWrap.createFromZipFile(type2, file));
        }
        return archives;
    }

    @Override
    public String getMavenLog() {
        return this.mavenLog;
    }

    @Override
    public void setMavenLog(String mavenLog) {
        this.mavenLog = mavenLog;
    }

    @Override
    public int getMavenBuildExitCode() {
        return this.mavenBuildExitCode;
    }

    @Override
    public void setMavenBuildExitCode(int mavenBuildExitCode) {
        this.mavenBuildExitCode = mavenBuildExitCode;
    }
}

