/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.net.DownloadTool;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.MarkerFileHandler;

public class BinaryDownloader {
    private final Logger log = Logger.getLogger(BinaryDownloader.class.getName());
    private final String target;
    private final MarkerFileHandler markerFileHandler;
    private final URL mavenDistribution;

    private BinaryDownloader(File mavenDir, URL mavenDistribution) {
        String distUrl = mavenDistribution.toString();
        this.mavenDistribution = mavenDistribution;
        this.target = new File(mavenDir, distUrl.substring(distUrl.lastIndexOf("/"))).getAbsolutePath();
        this.markerFileHandler = new MarkerFileHandler(mavenDir, new File(this.target).getName() + "-downloadProcess.tmp");
    }

    static File download(File mavenDir, URL mavenDistribution) {
        return new BinaryDownloader(mavenDir, mavenDistribution).download();
    }

    private File download() {
        File downloaded = this.checkIfItIsAlreadyDownloaded();
        if (downloaded == null) {
            this.markerFileHandler.createMarkerFile();
            for (int i = 0; i < 3; ++i) {
                try {
                    downloaded = this.runDownloadExecution(this.mavenDistribution, this.target).await();
                    break;
                }
                catch (ExecutionException ee) {
                    System.err.print("ERROR: the downloading of Maven binaries has failed. ");
                    if (2 - i <= 0) {
                        System.err.println("For more information see the stacktrace of an exception");
                        throw ee;
                    }
                    System.err.println("Trying again - number of remaining attempts: " + (2 - i));
                    continue;
                }
            }
            this.markerFileHandler.deleteMarkerFile();
        }
        return downloaded;
    }

    private Execution<File> runDownloadExecution(URL mavenDistribution, String target) {
        Execution<File> execution = Spacelift.task(DownloadTool.class).from(mavenDistribution).to(target).execute();
        System.out.println("Resolver: downloading Maven binaries from " + mavenDistribution + " to " + target);
        while (!execution.isFinished()) {
            System.out.print(".");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.log.warning("Problem occurred when the thread was sleeping:\n" + e.getMessage());
            }
        }
        System.out.println();
        return execution;
    }

    private File checkIfItIsAlreadyDownloaded() {
        if (this.isExtractionFinished() && new File(this.target).exists()) {
            return new File(this.target);
        }
        return null;
    }

    private boolean isExtractionFinished() {
        boolean fileIsStillPresent = this.markerFileHandler.waitTillMarkerFileIsGone(60000L, "download");
        if (fileIsStillPresent) {
            try {
                Files.delete(Paths.get(this.target, new String[0]));
                this.markerFileHandler.deleteMarkerFile();
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete a file.", e);
            }
        }
        return true;
    }
}

