/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.coordinate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.spi.MavenDependencySPI;

public final class MavenDependencyImpl
implements MavenDependencySPI {
    private final MavenCoordinate delegate;
    private final Set<MavenDependencyExclusion> exclusions;
    private final ScopeType scope;
    private final boolean optional;
    private final boolean undeclaredScope;

    public MavenDependencyImpl(MavenCoordinate coordinate, ScopeType scope2, boolean optional, MavenDependencyExclusion ... exclusions) {
        this(coordinate, scope2, optional, false, exclusions);
    }

    public MavenDependencyImpl(MavenCoordinate coordinate, ScopeType scope2, boolean optional, boolean undeclaredScope, MavenDependencyExclusion ... exclusions) {
        assert (coordinate != null) : "coodinate is required";
        this.delegate = coordinate;
        this.scope = scope2 == null ? ScopeType.COMPILE : scope2;
        this.optional = optional;
        this.undeclaredScope = undeclaredScope;
        HashSet<MavenDependencyExclusion> exclusionsToSet = new HashSet<MavenDependencyExclusion>(exclusions == null ? 0 : exclusions.length);
        if (exclusions != null) {
            for (MavenDependencyExclusion exclusion : exclusions) {
                if (exclusion == null) continue;
                exclusionsToSet.add(exclusion);
            }
        }
        this.exclusions = Collections.unmodifiableSet(exclusionsToSet);
    }

    @Override
    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    @Override
    public String toCanonicalForm() {
        return this.delegate.toCanonicalForm() + ':' + this.getScope().toString();
    }

    @Override
    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    @Override
    public PackagingType getPackaging() {
        return this.delegate.getPackaging();
    }

    @Override
    public PackagingType getType() {
        return this.delegate.getType();
    }

    @Override
    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public Set<MavenDependencyExclusion> getExclusions() {
        return this.exclusions;
    }

    @Override
    public ScopeType getScope() {
        return this.scope;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isUndeclaredScope() {
        return this.undeclaredScope;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyImpl other = (MavenDependencyImpl)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return MavenDependency.class.getSimpleName() + " [" + this.toCanonicalForm() + "]";
    }
}

