/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    static String getEnvProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getenv(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    static Properties getProperties() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof NullPointerException) {
                throw (NullPointerException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }

    static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments2) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(arguments2);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                @Override
                public Constructor<T> run() throws NoSuchMethodException {
                    return clazz.getDeclaredConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t2 = pae.getCause();
            if (t2 instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t2;
            }
            try {
                throw (RuntimeException)t2;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t2);
            }
        }
    }
}

