/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporterException;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.Validate;

public class MavenArchiveConfiguration {
    private final ParsedPomFile pomFile;
    private final boolean addMavenDescriptor = true;
    private final boolean compress = true;
    private final boolean forced = true;
    private final boolean index = false;
    private final File manifestFile;
    private final File pomPropertiesFile;
    private final boolean manifestAddClasspath = false;
    private final boolean manifestAddDefaultImplementationEntries;
    private final boolean manifestAddDefaultSpecificationEntries;
    private final boolean manifestAddExtensions = false;
    private final String manifestClasspathLayoutType = "simple";
    private final boolean manifestClasspathMavenRepositoryLayout = false;
    private final String manifestClassPathPrefix = "";
    private final String manifestMainClass;
    private final String manifestPackageName;
    private final Map<String, Map<String, String>> manifestSections;
    private final Map<String, String> manifestEntries;

    public MavenArchiveConfiguration(ParsedPomFile pomFile, Map<String, Object> configuration) {
        this.pomFile = pomFile;
        this.manifestEntries = new HashMap<String, String>();
        this.manifestEntries.putAll(ConfigurationUtils.valueAsMapOfStrings(configuration, new ConfigurationUtils.Key("manifestEntries"), Collections.emptyMap()));
        this.manifestFile = ConfigurationUtils.valueAsFile(configuration, new ConfigurationUtils.Key("manifestFile"), pomFile.getBaseDirectory(), null);
        this.pomPropertiesFile = ConfigurationUtils.valueAsFile(configuration, new ConfigurationUtils.Key("pomPropertiesFile"), pomFile.getBaseDirectory(), null);
        Map<String, Object> manifestConfiguration = ConfigurationUtils.valueAsMap(configuration, new ConfigurationUtils.Key("manifest"), Collections.emptyMap());
        this.manifestMainClass = ConfigurationUtils.valueAsString(manifestConfiguration, new ConfigurationUtils.Key("mainClass"), null);
        this.manifestPackageName = ConfigurationUtils.valueAsString(manifestConfiguration, new ConfigurationUtils.Key("packageName"), null);
        this.manifestAddDefaultImplementationEntries = ConfigurationUtils.valueAsBoolean(manifestConfiguration, new ConfigurationUtils.Key("addDefaultImplementationEntries"), false);
        this.manifestAddDefaultSpecificationEntries = ConfigurationUtils.valueAsBoolean(manifestConfiguration, new ConfigurationUtils.Key("addDefaultSpecificationEntries"), false);
        this.manifestSections = this.parseManifestSections(configuration);
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public Map<String, String> getManifestEntries() {
        return this.manifestEntries;
    }

    public String getManifestPackageName() {
        return this.manifestPackageName;
    }

    public boolean isManifestAddDefaultImplementationEntries() {
        return this.manifestAddDefaultImplementationEntries;
    }

    public boolean isManifestAddDefaultSpecificationEntries() {
        return this.manifestAddDefaultSpecificationEntries;
    }

    public String getManifestMainClass() {
        return this.manifestMainClass;
    }

    public Map<String, Map<String, String>> getManifestSections() {
        return this.manifestSections;
    }

    public ParsedPomFile getPomFile() {
        return this.pomFile;
    }

    public Manifest asManifest() throws MavenImporterException {
        return new ManifestBuilder().addCustomEntries().addDefaultImplementationEntries().addDefaultSpecificationEntries().addManifestEntries().addManifestSections().addMainClass().loadFile().build();
    }

    private Map<String, Map<String, String>> parseManifestSections(Map<String, Object> configuration) {
        HashMap<String, Map<String, String>> map2 = new HashMap<String, Map<String, String>>();
        Object rawOrSectionMap = configuration.get("manifestSections");
        if (rawOrSectionMap == null || !(rawOrSectionMap instanceof Map)) {
            return Collections.emptyMap();
        }
        Object sections = ((Map)rawOrSectionMap).get("manifestSection");
        if (sections instanceof Map) {
            sections = Arrays.asList(sections);
        } else if (sections == null || !(sections instanceof Iterable)) {
            return Collections.emptyMap();
        }
        for (Object rawOrSection : (Iterable)sections) {
            if (!(rawOrSection instanceof Map)) continue;
            Map section = (Map)rawOrSection;
            String name2 = ConfigurationUtils.valueAsString(section, new ConfigurationUtils.Key("name"), null);
            Map<String, String> values2 = ConfigurationUtils.valueAsMapOfStrings(section, new ConfigurationUtils.Key("manifestEntries"), Collections.emptyMap());
            map2.put(name2, values2);
        }
        return map2;
    }

    private static class ManifestMerger {
        private ManifestMerger() {
        }

        static Manifest merge(Manifest source, Manifest target) {
            ManifestMerger.mergeAttributes(source.getMainAttributes(), target.getMainAttributes());
            for (Map.Entry<String, Attributes> entry2 : source.getEntries().entrySet()) {
                if (target.getAttributes(entry2.getKey()) == null) {
                    if (entry2.getValue() == null) continue;
                    target.getEntries().put(entry2.getKey(), new Attributes(entry2.getValue()));
                    continue;
                }
                ManifestMerger.mergeAttributes(entry2.getValue(), target.getEntries().get(entry2.getKey()));
            }
            return target;
        }

        static Attributes mergeAttributes(Attributes source, Attributes target) {
            for (Object key : source.keySet()) {
                target.put(key, source.get(key));
            }
            return target;
        }
    }

    private class ManifestBuilder {
        private Manifest manifest = new Manifest();

        ManifestBuilder() {
            this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }

        ManifestBuilder loadFile() throws MavenImporterException {
            if (Validate.isReadable(MavenArchiveConfiguration.this.getManifestFile())) {
                InputStream is = null;
                try {
                    is = new FileInputStream(MavenArchiveConfiguration.this.getManifestFile());
                    Manifest userSupplied = new Manifest(is);
                    this.manifest = ManifestMerger.merge(userSupplied, this.manifest);
                }
                catch (IOException e) {
                    throw new MavenImporterException("Unable to build MANIFEST.MF from file " + MavenArchiveConfiguration.this.getManifestFile().getAbsolutePath(), e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this;
        }

        ManifestBuilder addManifestEntries() {
            if (MavenArchiveConfiguration.this.getManifestEntries().size() > 0) {
                for (Map.Entry<String, String> entry2 : MavenArchiveConfiguration.this.getManifestEntries().entrySet()) {
                    this.addMainAttribute(entry2.getKey(), entry2.getValue());
                }
            }
            return this;
        }

        ManifestBuilder addManifestSections() {
            if (MavenArchiveConfiguration.this.getManifestSections().size() > 0) {
                for (Map.Entry<String, Map<String, String>> entry2 : MavenArchiveConfiguration.this.getManifestSections().entrySet()) {
                    for (Map.Entry<String, String> attrs : entry2.getValue().entrySet()) {
                        this.addSectionAttribute(entry2.getKey(), attrs.getKey(), attrs.getValue());
                    }
                }
            }
            return this;
        }

        ManifestBuilder addCustomEntries() {
            return this.addMainAttribute("Created-By", "ShrinkWrap Maven Resolver").addMainAttribute("Built-by", SecurityActions.getProperty("user.name")).addMainAttribute("Built-Jdk", SecurityActions.getProperty("java.version")).addMainAttribute("Package", MavenArchiveConfiguration.this.getManifestPackageName());
        }

        ManifestBuilder addDefaultSpecificationEntries() {
            if (MavenArchiveConfiguration.this.isManifestAddDefaultSpecificationEntries()) {
                return this.addMainAttribute("Specification-Title", MavenArchiveConfiguration.this.getPomFile().getName()).addMainAttribute("Specification-Version", MavenArchiveConfiguration.this.getPomFile().getVersion()).addMainAttribute("Specification-Vendor", MavenArchiveConfiguration.this.getPomFile().getOrganizationName());
            }
            return this;
        }

        ManifestBuilder addDefaultImplementationEntries() {
            if (MavenArchiveConfiguration.this.isManifestAddDefaultImplementationEntries()) {
                return this.addMainAttribute("Implementation-Title", MavenArchiveConfiguration.this.getPomFile().getName()).addMainAttribute("Implementation-Version", MavenArchiveConfiguration.this.getPomFile().getVersion()).addMainAttribute("Implementation-Vendor-Id", MavenArchiveConfiguration.this.getPomFile().getGroupId()).addMainAttribute("Implementation-Vendor", MavenArchiveConfiguration.this.getPomFile().getOrganizationName());
            }
            return this;
        }

        ManifestBuilder addMainClass() {
            this.addMainAttribute(Attributes.Name.MAIN_CLASS.toString(), MavenArchiveConfiguration.this.getManifestMainClass());
            return this;
        }

        Manifest build() {
            return this.manifest;
        }

        private ManifestBuilder addMainAttribute(String name2, String value) {
            if (!Validate.isNullOrEmpty(value)) {
                this.manifest.getMainAttributes().putValue(name2, value);
            }
            return this;
        }

        private ManifestBuilder addSectionAttribute(String section, String name2, String value) {
            if (!Validate.isNullOrEmpty(value)) {
                Attributes attrs = this.manifest.getAttributes(section);
                if (attrs == null) {
                    attrs = new Attributes();
                    Map<String, Attributes> entries2 = this.manifest.getEntries();
                    entries2.put(section, attrs);
                }
                attrs.putValue(name2, value);
            }
            return this;
        }
    }
}

