/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.AbstractPackagingPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;

public class JarPluginConfiguration
extends AbstractPackagingPluginConfiguration {
    private static final String JAR_PLUGIN_GA = "org.apache.maven.plugins:maven-jar-plugin";
    private final String[] excludes;
    private final String[] includes;

    public JarPluginConfiguration(ParsedPomFile pomFile) {
        super(pomFile);
        Map<String, Object> rawValues = pomFile.getPluginConfiguration(JAR_PLUGIN_GA);
        this.includes = ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("includes", "include"), Arrays.asList("**/**")).toArray(new String[0]);
        this.excludes = ConfigurationUtils.valueAsStringList(rawValues, new ConfigurationUtils.Key("excludes", "exclude"), Collections.emptyList()).toArray(new String[0]);
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public String getPluginGA() {
        return JAR_PLUGIN_GA;
    }
}

