/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.util.jar.Manifest;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.pom.Resource;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ArchiveFilteringUtils;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ManifestAsset;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.JarPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

public class JarPackagingProcessor
extends AbstractCompilingProcessor<JavaArchive>
implements PackagingProcessor<JavaArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-jar-plugin";
    private JavaArchive archive;

    @Override
    public boolean handles(PackagingType packagingType) {
        return PackagingType.JAR.equals(packagingType);
    }

    public JarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        String archiveName = JarPackagingProcessor.hasGeneratedName(archive) ? session.getParsedPomFile().getFinalName() : archive.getName();
        this.archive = ShrinkWrap.create(JavaArchive.class, archiveName);
        return this;
    }

    public JarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws ResolutionException, IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable(pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.PROVIDED, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes2 = ShrinkWrap.create(ExplodedImporter.class, "sources.jar").importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (JavaArchive)this.archive.merge(classes2);
        }
        JarPluginConfiguration jarConfiguration = new JarPluginConfiguration(pomFile);
        for (Resource resource : pomFile.getResources()) {
            this.archive.addAsResource(resource.getSource(), resource.getTargetPath());
        }
        Manifest manifest = jarConfiguration.getArchiveConfiguration().asManifest();
        this.archive.setManifest(new ManifestAsset(manifest));
        this.archive = ArchiveFilteringUtils.filterArchiveContent(this.archive, JavaArchive.class, jarConfiguration.getIncludes(), jarConfiguration.getExcludes());
        return this;
    }

    @Override
    public JavaArchive getResultingArchive() {
        return this.archive;
    }
}

