/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.SelectorUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;

public class ArchiveFilteringUtils {
    public static <T extends Archive<?>> T filterArchiveContent(T archive, Class<T> archiveType, String[] includes, String[] excludes) {
        return ArchiveFilteringUtils.filterArchiveContent(archive, archiveType, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public static <T extends Archive<?>> T filterArchiveContent(T archive, Class<T> archiveType, final List<String> includes, final List<String> excludes) {
        Map<ArchivePath, Node> includePart = archive.getContent(new Filter<ArchivePath>(){

            @Override
            public boolean include(ArchivePath path) {
                String pathAsString = path.get();
                pathAsString = pathAsString.startsWith("/") ? pathAsString.substring(1) : pathAsString;
                boolean include = false;
                block0: for (String i : includes) {
                    if (!SelectorUtils.matchPath(i, pathAsString, "/", true)) continue;
                    for (String e : excludes) {
                        if (!SelectorUtils.matchPath(e, pathAsString, "/", true)) continue;
                        break block0;
                    }
                    include = true;
                    break;
                }
                return include;
            }
        });
        Archive newArchive = (Archive)ShrinkWrap.create(archiveType, archive.getName());
        for (Map.Entry<ArchivePath, Node> entry2 : includePart.entrySet()) {
            if (entry2.getValue() == null || entry2.getValue().getAsset() == null) continue;
            newArchive.add(entry2.getValue().getAsset(), entry2.getKey());
        }
        return (T)newArchive;
    }
}

