/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive;

import java.io.File;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;

public final class ArchiveFormatProcessor<ARCHIVETYPE extends Archive<ARCHIVETYPE>>
implements FormatProcessor<MavenResolvedArtifact, ARCHIVETYPE> {
    @Override
    public ARCHIVETYPE process(MavenResolvedArtifact artifact, Class<ARCHIVETYPE> returnType) throws IllegalArgumentException {
        if (artifact == null) {
            throw new IllegalArgumentException("Resolution artifact must be specified");
        }
        File file = artifact.asFile();
        if (file == null) {
            throw new IllegalArgumentException("Artifact was not resolved");
        }
        return (ARCHIVETYPE)((Archive)((ZipImporter)ShrinkWrap.create(ZipImporter.class, file.getName()).importFrom(file)).as(returnType));
    }

    @Override
    public boolean handles(Class<?> resolvedTypeClass) {
        return MavenResolvedArtifact.class.isAssignableFrom(resolvedTypeClass);
    }

    @Override
    public boolean returns(Class<?> returnTypeClass) {
        return Archive.class.isAssignableFrom(returnTypeClass);
    }
}

