/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.aether;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jboss.shrinkwrap.resolver.impl.maven.aether.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClasspathWorkspaceReader
implements WorkspaceReader {
    private static final Logger log = Logger.getLogger(ClasspathWorkspaceReader.class.getName());
    private static final String CLASS_PATH_KEY = "java.class.path";
    static final String SUREFIRE_CLASS_PATH_KEY = "surefire.test.class.path";
    static final String FLATTENED_POM_PATH_KEY = "org.apache.maven.flattened-pom-path";
    private final Set<String> classPathEntries = new LinkedHashSet<String>();
    private final Map<String, FileInfo> classpathFileInfoCache = new HashMap<String, FileInfo>();
    private final Map<File, FileInfo> pomFileInfoCache = new HashMap<File, FileInfo>();
    private final Map<File, Artifact> foundArtifactCache = new HashMap<File, Artifact>();
    private final String flattenedPomPath;
    private DocumentBuilder documentBuilder;
    private XPath xPath;
    private XPathExpression xPathParentGroupIdExpression;
    private XPathExpression xPathGroupIdExpression;
    private XPathExpression xPathArtifactIdExpression;
    private XPathExpression xPathTypeExpression;
    private XPathExpression xPathVersionExpression;
    private XPathExpression xPathParentVersionExpression;

    public ClasspathWorkspaceReader() {
        String classPath = SecurityActions.getProperty(CLASS_PATH_KEY);
        String surefireClassPath = SecurityActions.getProperty(SUREFIRE_CLASS_PATH_KEY);
        this.classPathEntries.addAll(this.getClassPathEntries(surefireClassPath));
        this.classPathEntries.addAll(this.getClassPathEntries(classPath));
        String configuredFlattenedPomPath = SecurityActions.getProperty(FLATTENED_POM_PATH_KEY);
        this.flattenedPomPath = configuredFlattenedPomPath != null ? configuredFlattenedPomPath : ".flattened-pom.xml";
    }

    @Override
    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository("classpath");
    }

    @Override
    public File findArtifact(Artifact artifact) {
        for (String classpathEntry : this.classPathEntries) {
            File pomFile;
            Artifact foundArtifact;
            FileInfo pomFileInfo;
            String candidateName;
            int suffixPosition;
            FileInfo fileInfo = this.getClasspathFileInfo(classpathEntry);
            File file = fileInfo.getFile();
            if (fileInfo.isDirectory()) {
                File pomFile2;
                Artifact foundArtifact2;
                FileInfo pomFileInfo2 = this.getPomFileInfo(file);
                if (pomFileInfo2 == null || !pomFileInfo2.isFile() || !this.areEquivalent(artifact, foundArtifact2 = this.getFoundArtifact(pomFile2 = pomFileInfo2.getFile()))) continue;
                return pomFile2;
            }
            if (!fileInfo.isFile()) continue;
            StringBuilder name2 = new StringBuilder(artifact.getArtifactId()).append("-").append(artifact.getVersion());
            if (!Validate.isNullOrEmpty(artifact.getClassifier())) {
                name2.append("-").append(artifact.getClassifier());
            }
            if ((suffixPosition = (candidateName = file.getName()).lastIndexOf(46)) != -1) {
                candidateName = candidateName.substring(0, suffixPosition);
            }
            if (!candidateName.equals(name2.toString())) continue;
            if ("pom".equals(artifact.getExtension()) && (pomFileInfo = this.getPomFileInfo(file)) != null && pomFileInfo.isFile() && this.areEquivalent(artifact, foundArtifact = this.getFoundArtifact(pomFile = pomFileInfo.getFile()))) {
                return pomFile;
            }
            name2.append(".").append(artifact.getExtension());
            if (!file.getName().endsWith(name2.toString())) continue;
            return file;
        }
        return null;
    }

    private boolean areEquivalent(Artifact artifact, Artifact foundArtifact) {
        boolean areEquivalent = foundArtifact.getGroupId().equals(artifact.getGroupId()) && foundArtifact.getArtifactId().equals(artifact.getArtifactId()) && foundArtifact.getVersion().equals(artifact.getVersion());
        return areEquivalent;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    private Set<String> getClassPathEntries(String classPath) {
        if (Validate.isNullOrEmpty(classPath)) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(classPath.split(String.valueOf(File.pathSeparatorChar))));
    }

    private FileInfo getClasspathFileInfo(String classpathEntry) {
        FileInfo classpathFileInfo = this.classpathFileInfoCache.get(classpathEntry);
        if (classpathFileInfo == null) {
            classpathFileInfo = new FileInfo(classpathEntry);
            this.classpathFileInfoCache.put(classpathEntry, classpathFileInfo);
        }
        return classpathFileInfo;
    }

    private FileInfo getPomFileInfo(File childFile) {
        FileInfo pomFileInfo = this.pomFileInfoCache.get(childFile);
        if (pomFileInfo == null && (pomFileInfo = this.createPomFileInfo(childFile)) != null) {
            this.pomFileInfoCache.put(childFile, pomFileInfo);
        }
        return pomFileInfo;
    }

    private FileInfo createPomFileInfo(File childFile) {
        File parent = childFile.getParentFile();
        if (parent != null && (parent = parent.getParentFile()) != null) {
            File pomFile = new File(parent, "pom.xml");
            return new FileInfo(pomFile);
        }
        return null;
    }

    private Artifact getFoundArtifact(File pomFile) {
        Artifact foundArtifact = this.foundArtifactCache.get(pomFile);
        if (foundArtifact == null) {
            foundArtifact = this.createFoundArtifact(pomFile);
            this.foundArtifactCache.put(pomFile, foundArtifact);
        }
        return foundArtifact;
    }

    private Artifact createFoundArtifact(File pomFile) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing " + pomFile.getAbsolutePath() + " for classpath artifact resolution");
            }
            Document pom = this.loadPom(this.choosePomToLoad(pomFile));
            String groupId = this.getXPathGroupIdExpression().evaluate(pom);
            String artifactId = this.getXPathArtifactIdExpression().evaluate(pom);
            String type2 = this.getXPathTypeExpression().evaluate(pom);
            String version2 = this.getXPathVersionExpression().evaluate(pom);
            if (Validate.isNullOrEmpty(groupId)) {
                groupId = this.getXPathParentGroupIdExpression().evaluate(pom);
            }
            if (Validate.isNullOrEmpty(type2)) {
                type2 = "jar";
            }
            if (version2 == null || version2.equals("")) {
                version2 = this.getXPathParentVersionExpression().evaluate(pom);
            }
            DefaultArtifact foundArtifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + type2 + ":" + version2);
            foundArtifact.setFile(pomFile);
            return foundArtifact;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse pom.xml: " + pomFile, e);
        }
    }

    private File choosePomToLoad(File regularPomFile) {
        File flattenedPomFile;
        File parentDir = regularPomFile.getParentFile();
        if (parentDir != null && (flattenedPomFile = new File(parentDir, this.flattenedPomPath)).isFile()) {
            return flattenedPomFile;
        }
        return regularPomFile;
    }

    private Document loadPom(File pom) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        return documentBuilder.parse(pom);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private XPath getXPath() {
        if (this.xPath == null) {
            XPathFactory factory;
            try {
                factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", ClassLoader.getSystemClassLoader());
            }
            catch (XPathFactoryConfigurationException e) {
                factory = XPathFactory.newInstance();
            }
            this.xPath = factory.newXPath();
        }
        return this.xPath;
    }

    private XPathExpression getXPathParentGroupIdExpression() throws XPathExpressionException {
        if (this.xPathParentGroupIdExpression == null) {
            this.xPathParentGroupIdExpression = this.getXPath().compile("/project/parent/groupId");
        }
        return this.xPathParentGroupIdExpression;
    }

    private XPathExpression getXPathGroupIdExpression() throws XPathExpressionException {
        if (this.xPathGroupIdExpression == null) {
            this.xPathGroupIdExpression = this.getXPath().compile("/project/groupId");
        }
        return this.xPathGroupIdExpression;
    }

    private XPathExpression getXPathArtifactIdExpression() throws XPathExpressionException {
        if (this.xPathArtifactIdExpression == null) {
            this.xPathArtifactIdExpression = this.getXPath().compile("/project/artifactId");
        }
        return this.xPathArtifactIdExpression;
    }

    private XPathExpression getXPathTypeExpression() throws XPathExpressionException {
        if (this.xPathTypeExpression == null) {
            this.xPathTypeExpression = this.getXPath().compile("/project/packaging");
        }
        return this.xPathTypeExpression;
    }

    private XPathExpression getXPathVersionExpression() throws XPathExpressionException {
        if (this.xPathVersionExpression == null) {
            this.xPathVersionExpression = this.getXPath().compile("/project/version");
        }
        return this.xPathVersionExpression;
    }

    private XPathExpression getXPathParentVersionExpression() throws XPathExpressionException {
        if (this.xPathParentVersionExpression == null) {
            this.xPathParentVersionExpression = this.getXPath().compile("/project/parent/version");
        }
        return this.xPathParentVersionExpression;
    }

    private static final class FileInfo {
        private final File file;
        private final boolean isFile;
        private final boolean isDirectory;

        private FileInfo(File file, boolean isFile, boolean isDirectory) {
            this.file = file;
            this.isFile = isFile;
            this.isDirectory = isDirectory;
        }

        private FileInfo(File file) {
            this(file, file.isFile(), file.isDirectory());
        }

        private FileInfo(String classpathEntry) {
            this(new File(classpathEntry));
        }

        private File getFile() {
            return this.file;
        }

        private boolean isFile() {
            return this.isFile;
        }

        private boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

