/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;

public class MavenVersionRangeResultImpl
implements MavenVersionRangeResult {
    private final Artifact artifact;
    private final VersionRangeResult versionRangeResult;
    private List<MavenCoordinate> versions;

    public MavenVersionRangeResultImpl(Artifact artifact, VersionRangeResult versionRangeResult) {
        this.artifact = artifact;
        this.versionRangeResult = versionRangeResult;
    }

    @Override
    public MavenCoordinate getLowestVersion() {
        return this.getCoordinate(this.versionRangeResult.getLowestVersion());
    }

    @Override
    public MavenCoordinate getHighestVersion() {
        return this.getCoordinate(this.versionRangeResult.getHighestVersion());
    }

    @Override
    public List<MavenCoordinate> getVersions() {
        if (this.versions == null) {
            List<Version> versions = this.versionRangeResult.getVersions();
            ArrayList<MavenCoordinate> coordinates = new ArrayList<MavenCoordinate>(versions.size());
            for (Version version2 : versions) {
                coordinates.add(this.getCoordinate(version2));
            }
            this.versions = Collections.unmodifiableList(coordinates);
        }
        return this.versions;
    }

    private MavenCoordinate getCoordinate(Version version2) {
        if (version2 == null) {
            return null;
        }
        return MavenCoordinates.createCoordinate(this.artifact.getGroupId(), this.artifact.getArtifactId(), version2.toString(), PackagingType.of(this.artifact.getExtension()), this.artifact.getClassifier());
    }

    public String toString() {
        StringBuilder versionsBuilder = new StringBuilder("{");
        boolean first2 = true;
        for (MavenCoordinate version2 : this.getVersions()) {
            if (first2) {
                first2 = false;
            } else {
                versionsBuilder.append(',');
            }
            versionsBuilder.append(version2.getVersion());
        }
        versionsBuilder.append("}");
        return "MavenResolvedVersionsImpl[artifact=" + this.artifact + ", versions=" + versionsBuilder.toString() + ']';
    }
}

